/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.TileEntityOwnable;
import net.geforcemods.securitycraft.blocks.BlockBlockPocketManager;
import net.geforcemods.securitycraft.blocks.BlockBlockPocketWall;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedCrystalQuartz;
import net.geforcemods.securitycraft.misc.EnumModuleType;
import net.geforcemods.securitycraft.network.packets.PacketCToggleBlockPocketManager;
import net.geforcemods.securitycraft.network.packets.PacketSAssembleBlockPocket;
import net.geforcemods.securitycraft.tileentity.TileEntityBlockPocket;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityBlockPocketManager
extends CustomizableSCTE {
    public static final int RENDER_DISTANCE = 100;
    private static final ItemStack REINFORCED_CHISELED_CRYSTAL_QUARTZ = new ItemStack(SCContent.reinforcedCrystalQuartz, 1, 1);
    private static final ItemStack REINFORCED_CRYSTAL_QUARTZ_PILLAR = new ItemStack(SCContent.reinforcedCrystalQuartz, 1, 2);
    public boolean enabled = false;
    public boolean showOutline = false;
    public int size = 5;
    private List<BlockPos> blocks = new ArrayList<BlockPos>();
    private List<BlockPos> walls = new ArrayList<BlockPos>();
    private List<BlockPos> floor = new ArrayList<BlockPos>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TextComponentTranslation enableMultiblock() {
        TileEntity te;
        if (this.enabled) return null;
        if (this.field_145850_b.field_72995_K) {
            SecurityCraft.network.sendToServer((IMessage)new PacketCToggleBlockPocketManager(this, true, this.size));
        }
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        ArrayList<BlockPos> sides = new ArrayList<BlockPos>();
        ArrayList<BlockPos> floor = new ArrayList<BlockPos>();
        EnumFacing managerFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockBlockPocketManager.FACING);
        EnumFacing left = managerFacing.func_176746_e();
        EnumFacing right = left.func_176734_d();
        EnumFacing back = left.func_176746_e();
        boolean lowest = false;
        int highest = this.size - 1;
        BlockPos pos = this.func_174877_v().func_185334_h();
        int xi = 0;
        int yi = 0;
        int zi = 0;
        while (this.field_145850_b.func_180495_p(pos = pos.func_177972_a(left)).func_177230_c() instanceof BlockReinforcedCrystalQuartz) {
        }
        pos = pos.func_177972_a(right);
        BlockPos startingPos = pos.func_185334_h();
        while (yi < this.size) {
            while (zi < this.size) {
                while (xi < this.size) {
                    if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                        ++xi;
                        continue;
                    }
                    BlockPos currentPos = pos.func_177967_a(right, xi);
                    IBlockState currentState = this.field_145850_b.func_180495_p(currentPos);
                    if (currentState.func_177230_c() instanceof BlockBlockPocketManager && !currentPos.equals((Object)this.func_174877_v())) {
                        return new TextComponentTranslation("messages.securitycraft:blockpocket.multipleManagers", new Object[0]);
                    }
                    if (yi == 0 && !currentPos.equals((Object)this.func_174877_v()) || yi == highest) {
                        BlockQuartz.EnumType typeToCheckFor;
                        if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                            if (!(currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz) || currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != BlockQuartz.EnumType.CHISELED) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0]), new TextComponentTranslation(REINFORCED_CHISELED_CRYSTAL_QUARTZ.func_77977_a() + ".name", new Object[0])});
                            }
                        } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                            BlockQuartz.EnumType enumType = typeToCheckFor = managerFacing == EnumFacing.NORTH || managerFacing == EnumFacing.SOUTH ? BlockQuartz.EnumType.LINES_X : BlockQuartz.EnumType.LINES_Z;
                            if (!(currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz)) return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0]), new TextComponentTranslation(REINFORCED_CRYSTAL_QUARTZ_PILLAR.func_77977_a() + ".name", new Object[0])});
                            if (currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != typeToCheckFor) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock.rotation", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                            }
                        } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                            BlockQuartz.EnumType enumType = typeToCheckFor = managerFacing == EnumFacing.NORTH || managerFacing == EnumFacing.SOUTH ? BlockQuartz.EnumType.LINES_Z : BlockQuartz.EnumType.LINES_X;
                            if (!(currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz)) return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0]), new TextComponentTranslation(REINFORCED_CRYSTAL_QUARTZ_PILLAR.func_77977_a() + ".name", new Object[0])});
                            if (currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != typeToCheckFor) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock.rotation", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                            }
                        } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                            if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall)) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0]), new TextComponentTranslation(SCContent.blockPocketWall.func_149739_a() + ".name", new Object[0])});
                            }
                            floor.add(currentPos);
                            sides.add(currentPos);
                        }
                    } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                        if (!(currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz)) return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0]), new TextComponentTranslation(REINFORCED_CRYSTAL_QUARTZ_PILLAR.func_77977_a() + ".name", new Object[0])});
                        if (currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != BlockQuartz.EnumType.LINES_Y) {
                            return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock.rotation", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                        }
                    } else if (yi > 0 && yi < highest) {
                        if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                            if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall)) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0]), new TextComponentTranslation(SCContent.blockPocketWall.func_149739_a() + ".name", new Object[0])});
                            }
                            sides.add(currentPos);
                        } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                            if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall)) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0]), new TextComponentTranslation(SCContent.blockPocketWall.func_149739_a() + ".name", new Object[0])});
                            }
                            sides.add(currentPos);
                        }
                    }
                    te = (TileEntityOwnable)this.field_145850_b.func_175625_s(currentPos);
                    if (!this.getOwner().owns(new IOwnable[]{te})) {
                        return new TextComponentTranslation("messages.securitycraft:blockpocket.unowned", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                    }
                    blocks.add(currentPos);
                    ++xi;
                }
                xi = 0;
                pos = startingPos.func_177981_b(yi).func_177967_a(back, ++zi);
            }
            zi = 0;
            pos = startingPos.func_177981_b(++yi);
        }
        this.blocks = blocks;
        this.walls = sides;
        this.floor = floor;
        this.enabled = true;
        for (BlockPos blockPos : blocks) {
            te = this.field_145850_b.func_175625_s(blockPos);
            if (!(te instanceof TileEntityBlockPocket)) continue;
            ((TileEntityBlockPocket)te).setManager(this);
        }
        for (BlockPos blockPos : floor) {
            this.field_145850_b.func_175656_a(blockPos, this.field_145850_b.func_180495_p(blockPos).func_177226_a((IProperty)BlockBlockPocketWall.SOLID, (Comparable)Boolean.valueOf(true)));
        }
        this.setWalls(!this.hasModule(EnumModuleType.DISGUISE));
        return new TextComponentTranslation("messages.securitycraft:blockpocket.activated", new Object[0]);
    }

    public TextComponentTranslation autoAssembleMultiblock(EntityPlayer player) {
        if (!this.enabled) {
            if (this.field_145850_b.field_72995_K) {
                SecurityCraft.network.sendToServer((IMessage)new PacketSAssembleBlockPocket(this, this.size));
            }
            EnumFacing managerFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockBlockPocketManager.FACING);
            EnumFacing left = managerFacing.func_176746_e();
            EnumFacing right = left.func_176734_d();
            EnumFacing back = left.func_176746_e();
            boolean lowest = false;
            int half = (this.size - 1) / 2;
            int highest = this.size - 1;
            BlockPos pos = this.func_174877_v().func_185334_h();
            int xi = 0;
            int yi = 0;
            int zi = 0;
            int wallsNeeded = 0;
            int pillarsNeeded = 0;
            int chiseledNeeded = 0;
            pos = pos.func_177967_a(right, -half);
            BlockPos startingPos = pos.func_185334_h();
            while (yi < this.size) {
                while (zi < this.size) {
                    while (xi < this.size) {
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        BlockPos currentPos = pos.func_177967_a(right, xi);
                        IBlockState currentState = this.field_145850_b.func_180495_p(currentPos);
                        currentState.func_185904_a().func_76222_j();
                        if (yi == 0 && !currentPos.equals((Object)this.func_174877_v()) || yi == highest) {
                            BlockQuartz.EnumType typeToCheckFor;
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                if (!(currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz && currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) == BlockQuartz.EnumType.CHISELED || currentState.func_185904_a().func_76222_j())) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.blockInWay", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                                }
                                if (currentState.func_185904_a().func_76222_j()) {
                                    ++chiseledNeeded;
                                }
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                BlockQuartz.EnumType enumType = typeToCheckFor = managerFacing == EnumFacing.NORTH || managerFacing == EnumFacing.SOUTH ? BlockQuartz.EnumType.LINES_X : BlockQuartz.EnumType.LINES_Z;
                                if (!this.isReinforcedCrystalQuartzPillar(currentState) && !currentState.func_185904_a().func_76222_j() || currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz && currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != typeToCheckFor) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.blockInWay", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                                }
                                if (currentState.func_185904_a().func_76222_j()) {
                                    ++pillarsNeeded;
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                BlockQuartz.EnumType enumType = typeToCheckFor = managerFacing == EnumFacing.NORTH || managerFacing == EnumFacing.SOUTH ? BlockQuartz.EnumType.LINES_Z : BlockQuartz.EnumType.LINES_X;
                                if (!this.isReinforcedCrystalQuartzPillar(currentState) && !currentState.func_185904_a().func_76222_j() || currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz && currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != typeToCheckFor) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.blockInWay", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                                }
                                if (currentState.func_185904_a().func_76222_j()) {
                                    ++pillarsNeeded;
                                }
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall) && !currentState.func_185904_a().func_76222_j()) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.blockInWay", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                                }
                                if (currentState.func_185904_a().func_76222_j()) {
                                    ++wallsNeeded;
                                }
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            if (!this.isReinforcedCrystalQuartzPillar(currentState) && !currentState.func_185904_a().func_76222_j() || currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz && currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != BlockQuartz.EnumType.LINES_Y) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.blockInWay", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                            }
                            if (currentState.func_185904_a().func_76222_j()) {
                                ++pillarsNeeded;
                            }
                        } else if (yi > 0 && yi < highest) {
                            if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall) && !currentState.func_185904_a().func_76222_j()) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.blockInWay", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                                }
                                if (currentState.func_185904_a().func_76222_j()) {
                                    ++wallsNeeded;
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall) && !currentState.func_185904_a().func_76222_j()) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.blockInWay", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                                }
                                if (currentState.func_185904_a().func_76222_j()) {
                                    ++wallsNeeded;
                                }
                            }
                        }
                        if (this.field_145850_b.func_175625_s(currentPos) instanceof TileEntityOwnable) {
                            TileEntityOwnable te = (TileEntityOwnable)this.field_145850_b.func_175625_s(currentPos);
                            if (!this.getOwner().owns(te)) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.unowned", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_185473_a(this.field_145850_b, currentPos, currentState).func_77977_a() + ".name", new Object[0])});
                            }
                        }
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.func_177981_b(yi).func_177967_a(back, ++zi);
                }
                zi = 0;
                pos = startingPos.func_177981_b(++yi);
            }
            if (chiseledNeeded + pillarsNeeded + wallsNeeded == 0) {
                return new TextComponentTranslation("messages.securitycraft:blockpocket.alreadyAssembled", new Object[0]);
            }
            if (!player.func_184812_l_()) {
                Block block;
                ItemStack stackToCheck;
                int i;
                int chiseledFound = 0;
                int pillarsFound = 0;
                int wallsFound = 0;
                NonNullList inventory = player.field_71071_by.field_70462_a;
                for (i = 1; i <= inventory.size(); ++i) {
                    stackToCheck = (ItemStack)inventory.get(i - 1);
                    if (stackToCheck.func_190926_b() || !(stackToCheck.func_77973_b() instanceof ItemBlock)) continue;
                    block = ((ItemBlock)stackToCheck.func_77973_b()).func_179223_d();
                    if (block instanceof BlockShulkerBox && stackToCheck.func_77942_o()) {
                        NonNullList contents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                        ItemStackHelper.func_191283_b((NBTTagCompound)stackToCheck.func_77978_p().func_74775_l("BlockEntityTag"), (NonNullList)contents);
                        for (ItemStack boxStack : contents) {
                            if (!(boxStack.func_77973_b() instanceof ItemBlock)) continue;
                            block = ((ItemBlock)boxStack.func_77973_b()).func_179223_d();
                            if (block == SCContent.blockPocketWall) {
                                wallsFound += boxStack.func_190916_E();
                                continue;
                            }
                            if (block == SCContent.reinforcedCrystalQuartz && boxStack.func_77960_j() == 1) {
                                chiseledFound += boxStack.func_190916_E();
                                continue;
                            }
                            if (block != SCContent.reinforcedCrystalQuartz || boxStack.func_77960_j() != 2) continue;
                            pillarsFound += boxStack.func_190916_E();
                        }
                        continue;
                    }
                    if (block == SCContent.blockPocketWall) {
                        wallsFound += stackToCheck.func_190916_E();
                        continue;
                    }
                    if (block == SCContent.reinforcedCrystalQuartz && stackToCheck.func_77960_j() == 1) {
                        chiseledFound += stackToCheck.func_190916_E();
                        continue;
                    }
                    if (block != SCContent.reinforcedCrystalQuartz || stackToCheck.func_77960_j() != 2) continue;
                    pillarsFound += stackToCheck.func_190916_E();
                }
                if (chiseledNeeded > chiseledFound || pillarsNeeded > pillarsFound || wallsNeeded > wallsFound) {
                    return new TextComponentTranslation("messages.securitycraft:blockpocket.notEnoughItems", new Object[0]);
                }
                for (i = 1; i <= inventory.size(); ++i) {
                    stackToCheck = (ItemStack)inventory.get(i - 1);
                    if (stackToCheck.func_190926_b() || !(stackToCheck.func_77973_b() instanceof ItemBlock)) continue;
                    block = ((ItemBlock)stackToCheck.func_77973_b()).func_179223_d();
                    int count = stackToCheck.func_190916_E();
                    if (block instanceof BlockShulkerBox && stackToCheck.func_77942_o()) {
                        NBTTagCompound stackTag = stackToCheck.func_77978_p();
                        NBTTagCompound blockEntityTag = stackTag.func_74775_l("BlockEntityTag");
                        NonNullList contents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                        ItemStackHelper.func_191283_b((NBTTagCompound)blockEntityTag, (NonNullList)contents);
                        for (int j = 0; j < contents.size(); ++j) {
                            ItemStack boxStack = (ItemStack)contents.get(j);
                            if (!(boxStack.func_77973_b() instanceof ItemBlock)) continue;
                            block = ((ItemBlock)boxStack.func_77973_b()).func_179223_d();
                            count = boxStack.func_190916_E();
                            if (block == SCContent.blockPocketWall) {
                                if (count <= wallsNeeded) {
                                    contents.set(j, (Object)ItemStack.field_190927_a);
                                    wallsNeeded -= count;
                                    continue;
                                }
                                while (wallsNeeded != 0) {
                                    boxStack.func_190918_g(1);
                                    --wallsNeeded;
                                }
                                continue;
                            }
                            if (block == SCContent.reinforcedCrystalQuartz && boxStack.func_77960_j() == 1) {
                                if (count <= chiseledNeeded) {
                                    contents.set(j, (Object)ItemStack.field_190927_a);
                                    chiseledNeeded -= count;
                                    continue;
                                }
                                while (chiseledNeeded != 0) {
                                    boxStack.func_190918_g(1);
                                    --chiseledNeeded;
                                }
                                continue;
                            }
                            if (block != SCContent.reinforcedCrystalQuartz || boxStack.func_77960_j() != 2) continue;
                            if (count <= pillarsNeeded) {
                                contents.set(j, (Object)ItemStack.field_190927_a);
                                pillarsNeeded -= count;
                                continue;
                            }
                            while (pillarsNeeded != 0) {
                                boxStack.func_190918_g(1);
                                --pillarsNeeded;
                            }
                        }
                        ItemStackHelper.func_191282_a((NBTTagCompound)blockEntityTag, (NonNullList)contents);
                        stackTag.func_74782_a("BlockEntityTag", (NBTBase)blockEntityTag);
                        stackToCheck.func_77982_d(stackTag);
                        continue;
                    }
                    if (block == SCContent.blockPocketWall) {
                        if (count <= wallsNeeded) {
                            inventory.set(i - 1, (Object)ItemStack.field_190927_a);
                            wallsNeeded -= count;
                            continue;
                        }
                        while (wallsNeeded != 0) {
                            stackToCheck.func_190918_g(1);
                            --wallsNeeded;
                        }
                        inventory.set(i - 1, (Object)stackToCheck);
                        continue;
                    }
                    if (block == SCContent.reinforcedCrystalQuartz && stackToCheck.func_77960_j() == 1) {
                        if (count <= chiseledNeeded) {
                            inventory.set(i - 1, (Object)ItemStack.field_190927_a);
                            chiseledNeeded -= count;
                            continue;
                        }
                        while (chiseledNeeded != 0) {
                            stackToCheck.func_190918_g(1);
                            --chiseledNeeded;
                        }
                        inventory.set(i - 1, (Object)stackToCheck);
                        continue;
                    }
                    if (block != SCContent.reinforcedCrystalQuartz || stackToCheck.func_77960_j() != 2) continue;
                    if (count <= pillarsNeeded) {
                        inventory.set(i - 1, (Object)ItemStack.field_190927_a);
                        pillarsNeeded -= count;
                        continue;
                    }
                    while (pillarsNeeded != 0) {
                        stackToCheck.func_190918_g(1);
                        --pillarsNeeded;
                    }
                    inventory.set(i - 1, (Object)stackToCheck);
                }
            }
            pos = this.func_174877_v().func_185334_h().func_177967_a(right, -half);
            xi = 0;
            yi = 0;
            zi = 0;
            while (yi < this.size) {
                while (zi < this.size) {
                    while (xi < this.size) {
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        BlockPos currentPos = pos.func_177967_a(right, xi);
                        IBlockState currentState = this.field_145850_b.func_180495_p(currentPos);
                        if (currentState.func_177230_c() instanceof BlockBlockPocketManager && !currentPos.equals((Object)this.func_174877_v())) {
                            return new TextComponentTranslation("messages.securitycraft:blockpocket.multipleManagers", new Object[0]);
                        }
                        if (yi == 0 && !currentPos.equals((Object)this.func_174877_v()) || yi == highest) {
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                if (!(currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz) || currentState.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a) != BlockQuartz.EnumType.CHISELED) {
                                    this.field_145850_b.func_175656_a(currentPos, SCContent.reinforcedCrystalQuartz.func_176223_P().func_177226_a((IProperty)BlockReinforcedCrystalQuartz.field_176335_a, (Comparable)BlockQuartz.EnumType.CHISELED));
                                }
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                BlockQuartz.EnumType typeToPlace;
                                BlockQuartz.EnumType enumType = typeToPlace = managerFacing == EnumFacing.NORTH || managerFacing == EnumFacing.SOUTH ? BlockQuartz.EnumType.LINES_X : BlockQuartz.EnumType.LINES_Z;
                                if (!(currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz)) {
                                    this.field_145850_b.func_175656_a(currentPos, SCContent.reinforcedCrystalQuartz.func_176223_P().func_177226_a((IProperty)BlockReinforcedCrystalQuartz.field_176335_a, (Comparable)typeToPlace));
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                BlockQuartz.EnumType typeToPlace;
                                BlockQuartz.EnumType enumType = typeToPlace = managerFacing == EnumFacing.NORTH || managerFacing == EnumFacing.SOUTH ? BlockQuartz.EnumType.LINES_Z : BlockQuartz.EnumType.LINES_X;
                                if (!(currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz)) {
                                    this.field_145850_b.func_175656_a(currentPos, SCContent.reinforcedCrystalQuartz.func_176223_P().func_177226_a((IProperty)BlockReinforcedCrystalQuartz.field_176335_a, (Comparable)typeToPlace));
                                }
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest && !(currentState.func_177230_c() instanceof BlockBlockPocketWall)) {
                                this.field_145850_b.func_175656_a(currentPos, SCContent.blockPocketWall.func_176223_P());
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            if (!(currentState.func_177230_c() instanceof BlockReinforcedCrystalQuartz)) {
                                this.field_145850_b.func_175656_a(currentPos, SCContent.reinforcedCrystalQuartz.func_176223_P().func_177226_a((IProperty)BlockReinforcedCrystalQuartz.field_176335_a, (Comparable)BlockQuartz.EnumType.LINES_Y));
                            }
                        } else if (yi > 0 && yi < highest) {
                            if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall)) {
                                    this.field_145850_b.func_175656_a(currentPos, SCContent.blockPocketWall.func_176223_P());
                                }
                            } else if (!(xi != 0 && xi != highest || zi <= 0 || zi >= highest || currentState.func_177230_c() instanceof BlockBlockPocketWall)) {
                                this.field_145850_b.func_175656_a(currentPos, SCContent.blockPocketWall.func_176223_P());
                            }
                        }
                        if (this.field_145850_b.func_175625_s(currentPos) instanceof TileEntityOwnable) {
                            TileEntityOwnable te = (TileEntityOwnable)this.field_145850_b.func_175625_s(currentPos);
                            te.getOwner().set(this.getOwner());
                        }
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.func_177981_b(yi).func_177967_a(back, ++zi);
                }
                zi = 0;
                pos = startingPos.func_177981_b(++yi);
            }
            return new TextComponentTranslation("messages.securitycraft:blockpocket.assembled", new Object[0]);
        }
        return null;
    }

    public void disableMultiblock() {
        if (this.enabled) {
            if (this.field_145850_b.field_72995_K) {
                SecurityCraft.network.sendToServer((IMessage)new PacketCToggleBlockPocketManager(this, false, this.size));
                PlayerUtils.sendMessageToPlayer(SecurityCraft.proxy.getClientPlayer(), ClientUtils.localize(SCContent.blockPocketManager.func_149739_a() + ".name", new Object[0]), ClientUtils.localize("messages.securitycraft:blockpocket.deactivated", new Object[0]), TextFormatting.DARK_AQUA);
            }
            this.enabled = false;
            for (BlockPos pos : this.blocks) {
                TileEntity te = this.field_145850_b.func_175625_s(pos);
                if (!(te instanceof TileEntityBlockPocket)) continue;
                ((TileEntityBlockPocket)te).removeManager();
            }
            for (BlockPos pos : this.floor) {
                IBlockState state = this.field_145850_b.func_180495_p(pos);
                if (!state.func_177228_b().containsKey((Object)BlockBlockPocketWall.SOLID)) continue;
                this.field_145850_b.func_175656_a(pos, state.func_177226_a((IProperty)BlockBlockPocketWall.SOLID, (Comparable)Boolean.valueOf(false)));
            }
            if (this.hasModule(EnumModuleType.DISGUISE)) {
                this.setWalls(true);
            }
            this.blocks.clear();
            this.walls.clear();
            this.floor.clear();
        }
    }

    public void toggleOutline() {
        this.showOutline = !this.showOutline;
    }

    public void setWalls(boolean seeThrough) {
        for (BlockPos pos : this.walls) {
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof BlockBlockPocketWall)) continue;
            this.field_145850_b.func_175656_a(pos, state.func_177226_a((IProperty)BlockBlockPocketWall.SEE_THROUGH, (Comparable)Boolean.valueOf(seeThrough)));
        }
    }

    @Override
    public void onTileEntityDestroyed() {
        super.onTileEntityDestroyed();
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != SCContent.blockPocketManager) {
            this.disableMultiblock();
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, EnumModuleType module) {
        super.onModuleInserted(stack, module);
        if (this.enabled && module == EnumModuleType.DISGUISE) {
            this.setWalls(false);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumModuleType module) {
        super.onModuleRemoved(stack, module);
        if (this.enabled && module == EnumModuleType.DISGUISE) {
            this.setWalls(true);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        int i;
        tag.func_74757_a("BlockPocketEnabled", this.enabled);
        tag.func_74757_a("ShowOutline", this.showOutline);
        tag.func_74768_a("Size", this.size);
        for (i = 0; i < this.blocks.size(); ++i) {
            tag.func_74772_a("BlocksList" + i, this.blocks.get(i).func_177986_g());
        }
        for (i = 0; i < this.walls.size(); ++i) {
            tag.func_74772_a("WallsList" + i, this.walls.get(i).func_177986_g());
        }
        for (i = 0; i < this.floor.size(); ++i) {
            tag.func_74772_a("FloorList" + i, this.floor.get(i).func_177986_g());
        }
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        int i = 0;
        super.func_145839_a(tag);
        this.enabled = tag.func_74767_n("BlockPocketEnabled");
        this.showOutline = tag.func_74767_n("ShowOutline");
        this.size = tag.func_74762_e("Size");
        while (tag.func_74764_b("BlocksList" + i)) {
            this.blocks.add(BlockPos.func_177969_a((long)tag.func_74763_f("BlocksList" + i)));
            ++i;
        }
        i = 0;
        while (tag.func_74764_b("WallsList" + i)) {
            this.walls.add(BlockPos.func_177969_a((long)tag.func_74763_f("WallsList" + i)));
            ++i;
        }
        i = 0;
        while (tag.func_74764_b("FloorList" + i)) {
            this.floor.add(BlockPos.func_177969_a((long)tag.func_74763_f("FloorList" + i)));
            ++i;
        }
    }

    @Override
    public EnumModuleType[] acceptedModules() {
        return new EnumModuleType[]{EnumModuleType.DISGUISE, EnumModuleType.WHITELIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g(100.0);
    }

    private boolean isReinforcedCrystalQuartzPillar(IBlockState state) {
        if (state.func_177230_c() instanceof BlockReinforcedCrystalQuartz) {
            BlockQuartz.EnumType type = (BlockQuartz.EnumType)state.func_177229_b((IProperty)BlockReinforcedCrystalQuartz.field_176335_a);
            return type == BlockQuartz.EnumType.LINES_X || type == BlockQuartz.EnumType.LINES_Y || type == BlockQuartz.EnumType.LINES_Z;
        }
        return false;
    }
}

