/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.mojang.blaze3d.platform.GlStateManager;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.SecurityCameraEntity;
import net.geforcemods.securitycraft.entity.SentryEntity;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.SecurityCameraTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.GuiUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class SCClientEventHandler {
    public static final ResourceLocation CAMERA_DASHBOARD = new ResourceLocation("securitycraft:textures/gui/camera/camera_dashboard.png");
    public static final ResourceLocation NIGHT_VISION = new ResourceLocation("minecraft:textures/mob_effect/night_vision.png");

    @SubscribeEvent
    public static void onPlayerRendered(RenderPlayerEvent.Pre event) {
        if (event.getEntity() instanceof LivingEntity && PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onDrawBlockHighlight(DrawBlockHighlightEvent event) {
        if (event.getTarget().func_216346_c() == RayTraceResult.Type.BLOCK && PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71439_g.func_184187_bx().func_180425_c().equals((Object)((BlockRayTraceResult)event.getTarget()).func_216350_a())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE && Minecraft.func_71410_x().field_71439_g != null && PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.func_71410_x().field_71439_g)) {
            if (BlockUtils.getBlock((IBlockReader)Minecraft.func_71410_x().field_71441_e, BlockUtils.toPos((int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70165_t), (int)Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70163_u, (int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70161_v))) instanceof SecurityCameraBlock) {
                SCClientEventHandler.drawCameraOverlay(Minecraft.func_71410_x(), (AbstractGui)Minecraft.func_71410_x().field_71456_v, Minecraft.func_71410_x().field_195558_d, (PlayerEntity)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e, BlockUtils.toPos((int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70165_t), (int)Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70163_u, (int)Math.floor(Minecraft.func_71410_x().field_71439_g.func_184187_bx().field_70161_v)));
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            World world = player.func_130014_f_();
            int held = player.field_71071_by.field_70461_c;
            if (held < 0 || held >= player.field_71071_by.field_70462_a.size()) {
                return;
            }
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(held);
            if (!stack.func_190926_b() && stack.func_77973_b() == SCContent.CAMERA_MONITOR.get()) {
                String textureToUse = "item_not_bound";
                double eyeHeight = player.func_70047_e();
                Vec3d lookVec = new Vec3d(player.field_70165_t + player.func_70040_Z().field_72450_a * 5.0, eyeHeight + player.field_70163_u + player.func_70040_Z().field_72448_b * 5.0, player.field_70161_v + player.func_70040_Z().field_72449_c * 5.0);
                BlockRayTraceResult mop = world.func_217299_a(new RayTraceContext(new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v), lookVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
                if (mop != null && mop.func_216346_c() == RayTraceResult.Type.BLOCK && world.func_175625_s(mop.func_216350_a()) instanceof SecurityCameraTileEntity) {
                    CompoundNBT cameras = stack.func_77978_p();
                    if (cameras != null) {
                        for (int i = 1; i < 31; ++i) {
                            String[] coords;
                            if (!cameras.func_74764_b("Camera" + i) || Integer.parseInt((coords = cameras.func_74779_i("Camera" + i).split(" "))[0]) != mop.func_216350_a().func_177958_n() || Integer.parseInt(coords[1]) != mop.func_216350_a().func_177956_o() || Integer.parseInt(coords[2]) != mop.func_216350_a().func_177952_p()) continue;
                            textureToUse = "item_bound";
                            break;
                        }
                    }
                    GlStateManager.enableAlphaTest();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("securitycraft", "textures/gui/" + textureToUse + ".png"));
                    SCClientEventHandler.drawNonStandardTexturedRect(Minecraft.func_71410_x().field_195558_d.func_198107_o() / 2 - 90 + held * 20 + 2, Minecraft.func_71410_x().field_195558_d.func_198087_p() - 16 - 3, 0, 0, 16, 16, 16, 16);
                    GlStateManager.disableAlphaTest();
                }
            } else if (!stack.func_190926_b() && stack.func_77973_b() == SCContent.REMOTE_ACCESS_MINE.get()) {
                String textureToUse = "item_not_bound";
                double eyeHeight = player.func_70047_e();
                Vec3d lookVec = new Vec3d(player.field_70165_t + player.func_70040_Z().field_72450_a * 5.0, eyeHeight + player.field_70163_u + player.func_70040_Z().field_72448_b * 5.0, player.field_70161_v + player.func_70040_Z().field_72449_c * 5.0);
                BlockRayTraceResult mop = world.func_217299_a(new RayTraceContext(new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v), lookVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
                if (mop != null && mop.func_216346_c() == RayTraceResult.Type.BLOCK && world.func_180495_p(mop.func_216350_a()).func_177230_c() instanceof IExplosive) {
                    CompoundNBT mines = stack.func_77978_p();
                    if (mines != null) {
                        for (int i = 1; i <= 6; ++i) {
                            int[] coords;
                            if (stack.func_77978_p().func_74759_k("mine" + i).length <= 0 || (coords = mines.func_74759_k("mine" + i))[0] != mop.func_216350_a().func_177958_n() || coords[1] != mop.func_216350_a().func_177956_o() || coords[2] != mop.func_216350_a().func_177952_p()) continue;
                            textureToUse = "item_bound";
                            break;
                        }
                    }
                    GlStateManager.enableAlphaTest();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("securitycraft", "textures/gui/" + textureToUse + ".png"));
                    SCClientEventHandler.drawNonStandardTexturedRect(Minecraft.func_71410_x().field_195558_d.func_198107_o() / 2 - 90 + held * 20 + 2, Minecraft.func_71410_x().field_195558_d.func_198087_p() - 16 - 3, 0, 0, 16, 16, 16, 16);
                    GlStateManager.disableAlphaTest();
                }
            } else if (!stack.func_190926_b() && stack.func_77973_b() == SCContent.REMOTE_ACCESS_SENTRY.get()) {
                String textureToUse = "item_not_bound";
                Entity hitEntity = Minecraft.func_71410_x().field_147125_j;
                if (hitEntity instanceof SentryEntity) {
                    CompoundNBT sentries = stack.func_77978_p();
                    if (sentries != null) {
                        for (int i = 1; i <= 12; ++i) {
                            int[] coords;
                            if (stack.func_77978_p().func_74759_k("sentry" + i).length <= 0 || (coords = sentries.func_74759_k("sentry" + i))[0] != hitEntity.func_180425_c().func_177958_n() || coords[1] != hitEntity.func_180425_c().func_177956_o() || coords[2] != hitEntity.func_180425_c().func_177952_p()) continue;
                            textureToUse = "item_bound";
                            break;
                        }
                    }
                    GlStateManager.enableAlphaTest();
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("securitycraft", "textures/gui/" + textureToUse + ".png"));
                    SCClientEventHandler.drawNonStandardTexturedRect(Minecraft.func_71410_x().field_195558_d.func_198107_o() / 2 - 90 + held * 20 + 2, Minecraft.func_71410_x().field_195558_d.func_198087_p() - 16 - 3, 0, 0, 16, 16, 16, 16);
                    GlStateManager.disableAlphaTest();
                }
            }
        }
    }

    @SubscribeEvent
    public static void fovUpdateEvent(FOVUpdateEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getEntity())) {
            event.setNewfov(((SecurityCameraEntity)event.getEntity().func_184187_bx()).getZoomAmount());
        }
    }

    @SubscribeEvent
    public static void renderHandEvent(RenderHandEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.func_71410_x().field_71439_g)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMouseClicked(GuiScreenEvent.MouseClickedEvent.Pre event) {
        if (Minecraft.func_71410_x().field_71441_e != null && event.getButton() != 1 && Minecraft.func_71410_x().field_71439_g.field_71070_bA == null && PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70448_g().func_77973_b() != SCContent.CAMERA_MONITOR.get()) {
            event.setCanceled(true);
        }
    }

    private static void drawNonStandardTexturedRect(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        double z = 200.0;
        double widthFactor = 1.0 / (double)textureWidth;
        double heightFactor = 1.0 / (double)textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), z).func_187315_a((double)u * widthFactor, (double)(v + height) * heightFactor).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), z).func_187315_a((double)(u + width) * widthFactor, (double)(v + height) * heightFactor).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, z).func_187315_a((double)(u + width) * widthFactor, (double)v * heightFactor).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, z).func_187315_a((double)u * widthFactor, (double)v * heightFactor).func_181675_d();
        tessellator.func_78381_a();
    }

    private static void drawCameraOverlay(Minecraft mc, AbstractGui gui, MainWindow resolution, PlayerEntity player, World world, BlockPos pos) {
        SecurityCameraTileEntity te = (SecurityCameraTileEntity)world.func_175625_s(pos);
        int timeY = 25;
        if (te.hasCustomSCName()) {
            String cameraName = te.getCustomSCName().func_150254_d();
            Minecraft.func_71410_x().field_71466_p.func_175063_a(cameraName, (float)(resolution.func_198107_o() - Minecraft.func_71410_x().field_71466_p.func_78256_a(cameraName) - 8), 25.0f, 0xFFFFFF);
            timeY += 10;
        }
        Minecraft.func_71410_x().field_71466_p.func_175063_a(ClientUtils.getFormattedMinecraftTime(), (float)(resolution.func_198107_o() - Minecraft.func_71410_x().field_71466_p.func_78256_a(ClientUtils.getFormattedMinecraftTime()) - 8), (float)timeY, 0xFFFFFF);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(Minecraft.func_71410_x().field_71474_y.field_74311_E.func_197978_k() + " - " + ClientUtils.localize("gui.securitycraft:camera.exit", new Object[0]), (float)(resolution.func_198107_o() - Minecraft.func_71410_x().field_71466_p.func_78256_a(Minecraft.func_71410_x().field_71474_y.field_74311_E.func_197978_k() + " - " + ClientUtils.localize("gui.securitycraft:camera.exit", new Object[0])) - 8), (float)(resolution.func_198087_p() - 70), 0xFFFFFF);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(KeyBindings.cameraZoomIn.func_197978_k() + "/" + KeyBindings.cameraZoomOut.func_197978_k() + " - " + ClientUtils.localize("gui.securitycraft:camera.zoom", new Object[0]), (float)(resolution.func_198107_o() - Minecraft.func_71410_x().field_71466_p.func_78256_a(KeyBindings.cameraZoomIn.func_197978_k() + "/" + ClientUtils.localize(KeyBindings.cameraZoomOut.func_197982_m(), new Object[0]) + " - " + ClientUtils.localize("gui.securitycraft:camera.zoom", new Object[0])) - 8), (float)(resolution.func_198087_p() - 60), 0xFFFFFF);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(KeyBindings.cameraActivateNightVision.func_197978_k() + " - " + ClientUtils.localize("gui.securitycraft:camera.activateNightVision", new Object[0]), (float)(resolution.func_198107_o() - Minecraft.func_71410_x().field_71466_p.func_78256_a(KeyBindings.cameraActivateNightVision.func_197978_k() + " - " + ClientUtils.localize("gui.securitycraft:camera.activateNightVision", new Object[0])) - 8), (float)(resolution.func_198087_p() - 50), 0xFFFFFF);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(KeyBindings.cameraEmitRedstone.func_197978_k() + " - " + ClientUtils.localize("gui.securitycraft:camera.toggleRedstone", new Object[0]), (float)(resolution.func_198107_o() - Minecraft.func_71410_x().field_71466_p.func_78256_a(KeyBindings.cameraEmitRedstone.func_197978_k() + " - " + ClientUtils.localize("gui.securitycraft:camera.toggleRedstone", new Object[0])) - 8), (float)(resolution.func_198087_p() - 40), te.hasModule(ModuleType.REDSTONE) ? 0xFFFFFF : 0xFF3377);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(ClientUtils.localize("gui.securitycraft:camera.toggleRedstoneNote", new Object[0]), (float)(resolution.func_198107_o() - Minecraft.func_71410_x().field_71466_p.func_78256_a(ClientUtils.localize("gui.securitycraft:camera.toggleRedstoneNote", new Object[0])) - 8), (float)(resolution.func_198087_p() - 30), te.hasModule(ModuleType.REDSTONE) ? 0xFFFFFF : 0xFF3377);
        mc.func_110434_K().func_110577_a(CAMERA_DASHBOARD);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        gui.blit(5, 0, 0, 0, 90, 20);
        gui.blit(resolution.func_198107_o() - 55, 5, 205, 0, 50, 30);
        if (!player.func_70644_a(Effects.field_76439_r)) {
            gui.blit(28, 4, 90, 12, 16, 11);
        } else {
            mc.func_110434_K().func_110577_a(NIGHT_VISION);
            AbstractGui.blit((int)27, (int)-1, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
            mc.func_110434_K().func_110577_a(CAMERA_DASHBOARD);
        }
        if (world.func_180495_p(pos).func_185911_a((IBlockReader)world, pos, (Direction)BlockUtils.getBlockProperty(world, pos, SecurityCameraBlock.FACING)) == 0 && !te.hasModule(ModuleType.REDSTONE)) {
            gui.blit(12, 2, 104, 0, 12, 12);
        } else if (world.func_180495_p(pos).func_185911_a((IBlockReader)world, pos, (Direction)BlockUtils.getBlockProperty(world, pos, SecurityCameraBlock.FACING)) == 0 && te.hasModule(ModuleType.REDSTONE)) {
            gui.blit(12, 3, 90, 0, 12, 11);
        } else {
            GuiUtils.drawItemToGui(Items.field_151137_ax, 10, 0, false);
        }
    }
}

