/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class SecurityCraftTileEntity
extends OwnableTileEntity
implements ITickableTileEntity,
INameable {
    protected boolean intersectsEntities = false;
    protected boolean viewActivated = false;
    private boolean attacks = false;
    private boolean canBeNamed = false;
    private ITextComponent customName = new StringTextComponent("name");
    private double attackRange = 0.0;
    private int viewCooldown = this.getViewCooldown();
    private int ticksBetweenAttacks = 0;
    private int attackCooldown = 0;
    private Class<? extends Entity> typeToAttack = Entity.class;

    public SecurityCraftTileEntity() {
        this(SCContent.teTypeAbstract);
    }

    public SecurityCraftTileEntity(TileEntityType<?> type) {
        super(type);
    }

    public void func_73660_a() {
        List entities;
        AxisAlignedBB area;
        int z;
        int y;
        int x;
        if (this.intersectsEntities) {
            x = this.field_174879_c.func_177958_n();
            y = this.field_174879_c.func_177956_o();
            z = this.field_174879_c.func_177952_p();
            area = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
            entities = this.field_145850_b.func_217357_a(Entity.class, area);
            for (Entity entity : entities) {
                this.entityIntersecting(entity);
            }
        }
        if (this.viewActivated) {
            if (this.viewCooldown > 0) {
                --this.viewCooldown;
                return;
            }
            x = this.field_174879_c.func_177958_n();
            y = this.field_174879_c.func_177956_o();
            z = this.field_174879_c.func_177952_p();
            area = new AxisAlignedBB((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72314_b(5.0, 5.0, 5.0);
            entities = this.field_145850_b.func_217357_a(LivingEntity.class, area);
            for (Entity entity : entities) {
                double eyeHeight = entity.func_70047_e();
                boolean isPlayer = entity instanceof PlayerEntity;
                Vec3d lookVec = new Vec3d(entity.field_70165_t + entity.func_70040_Z().field_72450_a * 5.0, eyeHeight + entity.field_70163_u + entity.func_70040_Z().field_72448_b * 5.0, entity.field_70161_v + entity.func_70040_Z().field_72449_c * 5.0);
                BlockRayTraceResult mop = this.func_145831_w().func_217299_a(new RayTraceContext(new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), lookVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity));
                if (mop == null || mop.func_216346_c() != RayTraceResult.Type.BLOCK || mop.func_216350_a().func_177958_n() != this.func_174877_v().func_177958_n() || mop.func_216350_a().func_177956_o() != this.func_174877_v().func_177956_o() || mop.func_216350_a().func_177952_p() != this.func_174877_v().func_177952_p() || (!isPlayer || !this.activatedOnlyByPlayer()) && this.activatedOnlyByPlayer()) continue;
                this.entityViewed((LivingEntity)entity);
                this.viewCooldown = this.getViewCooldown();
            }
        }
        if (this.attacks) {
            if (this.attackCooldown < this.getTicksBetweenAttacks()) {
                ++this.attackCooldown;
                return;
            }
            if (this.canAttack()) {
                AxisAlignedBB area2 = new AxisAlignedBB(this.field_174879_c).func_72314_b(this.getAttackRange(), this.getAttackRange(), this.getAttackRange());
                List entities2 = this.field_145850_b.func_217357_a(this.entityTypeToAttack(), area2);
                Iterator iterator = entities2.iterator();
                if (!this.field_145850_b.field_72995_K) {
                    boolean attacked = false;
                    if (!iterator.hasNext()) {
                        this.attackFailed();
                    }
                    while (iterator.hasNext()) {
                        Entity mobToAttack = (Entity)iterator.next();
                        if (mobToAttack == null || mobToAttack instanceof ItemEntity || !this.shouldAttackEntityType(mobToAttack) || !this.attackEntity(mobToAttack)) continue;
                        attacked = true;
                    }
                    if (attacked || this.shouldRefreshAttackCooldown()) {
                        this.attackCooldown = 0;
                    }
                    if (attacked || this.shouldSyncToClient()) {
                        this.sync();
                    }
                }
            }
        }
    }

    public void entityIntersecting(Entity entity) {
        if (!(this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() instanceof IIntersectable)) {
            return;
        }
        ((IIntersectable)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c()).onEntityIntersected(this.func_145831_w(), this.func_174877_v(), entity);
    }

    public void entityViewed(LivingEntity entity) {
    }

    public boolean attackEntity(Entity entity) {
        return false;
    }

    public void attackFailed() {
    }

    public boolean canAttack() {
        return false;
    }

    public boolean shouldAttackEntityType(Entity entity) {
        return entity instanceof PlayerEntity || this.typeToAttack.isAssignableFrom(entity.getClass());
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("intersectsEntities", this.intersectsEntities);
        tag.func_74757_a("viewActivated", this.viewActivated);
        tag.func_74757_a("attacks", this.attacks);
        tag.func_74757_a("canBeNamed", this.canBeNamed);
        tag.func_74780_a("attackRange", this.attackRange);
        tag.func_74768_a("attackCooldown", this.attackCooldown);
        tag.func_74768_a("ticksBetweenAttacks", this.ticksBetweenAttacks);
        tag.func_74778_a("customName", this.customName.func_150254_d());
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("intersectsEntities")) {
            this.intersectsEntities = tag.func_74767_n("intersectsEntities");
        }
        if (tag.func_74764_b("viewActivated")) {
            this.viewActivated = tag.func_74767_n("viewActivated");
        }
        if (tag.func_74764_b("attacks")) {
            this.attacks = tag.func_74767_n("attacks");
        }
        if (tag.func_74764_b("canBeNamed")) {
            this.canBeNamed = tag.func_74767_n("canBeNamed");
        }
        if (tag.func_74764_b("attackRange")) {
            this.attackRange = tag.func_74769_h("attackRange");
        }
        if (tag.func_74764_b("attackCooldown")) {
            this.attackCooldown = tag.func_74762_e("attackCooldown");
        }
        if (tag.func_74764_b("ticksBetweenAttacks")) {
            this.ticksBetweenAttacks = tag.func_74762_e("ticksBetweenAttacks");
        }
        if (tag.func_74764_b("customName")) {
            this.customName = new StringTextComponent(tag.func_74779_i("customName"));
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onTileEntityDestroyed();
    }

    public void onTileEntityDestroyed() {
    }

    public void sync() {
        if (this.field_145850_b == null) {
            return;
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
    }

    public SecurityCraftTileEntity intersectsEntities() {
        this.intersectsEntities = true;
        return this;
    }

    public boolean doesIntersectsEntities() {
        return this.intersectsEntities;
    }

    public SecurityCraftTileEntity activatedByView() {
        this.viewActivated = true;
        return this;
    }

    public int getViewCooldown() {
        return 0;
    }

    public boolean activatedOnlyByPlayer() {
        return true;
    }

    public boolean isActivatedByView() {
        return this.viewActivated;
    }

    public SecurityCraftTileEntity attacks(Class<? extends Entity> type, double range, int cooldown) {
        this.attacks = true;
        this.typeToAttack = type;
        this.attackRange = range;
        this.ticksBetweenAttacks = cooldown;
        return this;
    }

    public Class<? extends Entity> entityTypeToAttack() {
        return this.typeToAttack;
    }

    public double getAttackRange() {
        return this.attackRange;
    }

    public int getTicksBetweenAttacks() {
        return this.ticksBetweenAttacks;
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void setAttackCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    public void attackNextTick() {
        this.attackCooldown = this.ticksBetweenAttacks;
    }

    public boolean shouldRefreshAttackCooldown() {
        return true;
    }

    public boolean shouldSyncToClient() {
        return true;
    }

    public boolean doesAttack() {
        return this.attacks;
    }

    public SecurityCraftTileEntity nameable() {
        this.canBeNamed = true;
        return this;
    }

    @Override
    public ITextComponent getCustomSCName() {
        return this.customName;
    }

    @Override
    public void setCustomSCName(ITextComponent customName) {
        this.customName = customName;
        this.sync();
    }

    @Override
    public boolean hasCustomSCName() {
        return this.customName != null && !this.customName.func_150254_d().equals("name");
    }

    @Override
    public boolean canBeNamed() {
        return this.canBeNamed;
    }
}

