/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.tileentity.AlarmTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class AlarmBlock
extends OwnableBlock {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    private static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0);
    private static final VoxelShape SHAPE_UP = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final VoxelShape SHAPE_DOWN = Block.func_208617_a((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public AlarmBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.UP)).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public int func_149750_m(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        Direction facing = (Direction)state.func_177229_b((IProperty)FACING);
        return facing == Direction.UP && BlockUtils.isSideSolid(world, pos.func_177977_b(), Direction.UP) ? true : BlockUtils.isSideSolid(world, pos.func_177972_a(facing.func_176734_d()), facing);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            world.func_175655_b(pos, true);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx.func_195999_j());
    }

    public BlockState getStateForPlacement(World world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, PlayerEntity placer) {
        return BlockUtils.isSideSolid((IWorldReader)world, pos.func_177972_a(facing.func_176734_d()), facing) ? (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)facing) : null;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean flag) {
        if (world.field_72995_K) {
            return;
        }
        world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 5);
    }

    public void func_196267_b(BlockState state, World world, BlockPos pos, Random random) {
        if (!world.field_72995_K) {
            this.playSoundAndUpdate(world, pos);
            world.func_205220_G_().func_205360_a(pos, (Object)state.func_177230_c(), 5);
        }
    }

    public void onNeighborChange(BlockState state, IWorldReader w, BlockPos pos, BlockPos neighbor) {
        if (w.func_201670_d() || !(w instanceof World)) {
            return;
        }
        World world = (World)w;
        this.playSoundAndUpdate(world, pos);
        Direction facing = (Direction)world.func_180495_p(pos).func_177229_b((IProperty)FACING);
        if (!BlockUtils.isSideSolid((IWorldReader)world, pos.func_177972_a(facing.func_176734_d()), facing)) {
            world.func_175655_b(pos, true);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext ctx) {
        Direction facing = (Direction)state.func_177229_b((IProperty)FACING);
        switch (facing) {
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case UP: {
                return SHAPE_UP;
            }
            case DOWN: {
                return SHAPE_DOWN;
            }
        }
        return VoxelShapes.func_197868_b();
    }

    private void playSoundAndUpdate(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() != SCContent.ALARM.get() || !(world.func_175625_s(pos) instanceof AlarmTileEntity)) {
            return;
        }
        if (world.func_175687_A(pos) > 0) {
            boolean isPowered = ((AlarmTileEntity)world.func_175625_s(pos)).isPowered();
            if (!isPowered) {
                Owner owner = ((AlarmTileEntity)world.func_175625_s(pos)).getOwner();
                BlockUtils.setBlockProperty(world, pos, LIT, true);
                ((AlarmTileEntity)world.func_175625_s(pos)).getOwner().set(owner);
                ((AlarmTileEntity)world.func_175625_s(pos)).setPowered(true);
            }
        } else {
            boolean isPowered = ((AlarmTileEntity)world.func_175625_s(pos)).isPowered();
            if (isPowered) {
                Owner owner = ((AlarmTileEntity)world.func_175625_s(pos)).getOwner();
                BlockUtils.setBlockProperty(world, pos, LIT, false);
                ((AlarmTileEntity)world.func_175625_s(pos)).getOwner().set(owner);
                ((AlarmTileEntity)world.func_175625_s(pos)).setPowered(false);
            }
        }
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)((Block)SCContent.ALARM.get()).func_199767_j());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
        builder.func_206894_a(new IProperty[]{LIT});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader reader) {
        return new AlarmTileEntity();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.func_177229_b((IProperty)FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.func_176740_k() != Direction.Axis.Z) break;
                return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)facing.func_176734_d());
            }
            case FRONT_BACK: {
                if (facing.func_176740_k() != Direction.Axis.X) break;
                return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)facing.func_176734_d());
            }
        }
        return state;
    }
}

