/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.Random;
import net.geforcemods.securitycraft.blocks.mines.BaseFullMineBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RedstoneOreMineBlock
extends BaseFullMineBlock {
    public static final BooleanProperty LIT = RedstoneTorchBlock.field_196528_a;

    public RedstoneOreMineBlock(Block.Properties properties, Block disguisedBlock) {
        super(properties, disguisedBlock);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public int func_149750_m(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? super.func_149750_m(state) : 0;
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        RedstoneOreMineBlock.activate(state, world, pos);
        super.func_196270_a(state, world, pos, player);
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        RedstoneOreMineBlock.activate(world.func_180495_p(pos), world, pos);
        super.func_176199_a(world, pos, entity);
    }

    @Override
    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        RedstoneOreMineBlock.activate(state, world, pos);
        return super.func_220051_a(state, world, pos, player, hand, rayTraceResult);
    }

    private static void activate(BlockState state, World world, BlockPos pos) {
        RedstoneOreMineBlock.spawnParticles(world, pos);
        if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void func_196267_b(BlockState state, World world, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            RedstoneOreMineBlock.spawnParticles(world, pos);
        }
    }

    private static void spawnParticles(World world, BlockPos pos) {
        Random random = world.field_73012_v;
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = pos.func_177972_a(direction);
            if (world.func_180495_p(offsetPos).func_200015_d((IBlockReader)world, offsetPos)) continue;
            Direction.Axis axis = direction.func_176740_k();
            double d1 = axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.func_82601_c() : (double)random.nextFloat();
            double d2 = axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.func_96559_d() : (double)random.nextFloat();
            double d3 = axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.func_82599_e() : (double)random.nextFloat();
            world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + d1, (double)pos.func_177956_o() + d2, (double)pos.func_177952_p() + d3, 0.0, 0.0, 0.0);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{LIT});
    }
}

