/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.List;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCTags;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class BaseReinforcedBlock
extends OwnableBlock
implements IReinforcedBlock {
    private final Supplier<Block> vanillaBlockSupplier;

    public BaseReinforcedBlock(Block.Properties properties, Block vB) {
        this(properties, () -> vB);
    }

    public BaseReinforcedBlock(Block.Properties properties, Supplier<Block> vB) {
        super(properties);
        this.vanillaBlockSupplier = vB;
    }

    public boolean isBeaconBase(BlockState state, IWorldReader world, BlockPos pos, BlockPos beacon) {
        return this == SCContent.REINFORCED_IRON_BLOCK.get() || this == SCContent.REINFORCED_GOLD_BLOCK.get() || this == SCContent.REINFORCED_DIAMOND_BLOCK.get() || this == SCContent.REINFORCED_EMERALD_BLOCK.get();
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos.func_177972_a(facing));
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        if (plant.func_177230_c() == Blocks.field_150434_aF) {
            return this == SCContent.REINFORCED_SAND.get() || this == SCContent.REINFORCED_RED_SAND.get();
        }
        switch (type) {
            case Desert: {
                return this == SCContent.REINFORCED_SAND.get() || this == SCContent.REINFORCED_RED_SAND.get();
            }
            case Cave: {
                return Block.func_220056_d((BlockState)state, (IBlockReader)world, (BlockPos)pos, (Direction)Direction.UP);
            }
            case Plains: {
                return SCTags.Blocks.REINFORCED_DIRT.func_199685_a_((Object)this);
            }
            case Beach: {
                boolean isBeach = SCTags.Blocks.REINFORCED_DIRT.func_199685_a_((Object)this) || this == SCContent.REINFORCED_SAND.get() || this == SCContent.REINFORCED_RED_SAND.get();
                boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
                return isBeach && hasWater;
            }
        }
        return false;
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (this.getVanillaBlock() instanceof BreakableBlock) {
            return adjacentBlockState.func_177230_c() == this ? true : super.func_200122_a(state, adjacentBlockState, side);
        }
        return false;
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlockSupplier.get();
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return this.func_176223_P();
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)this)});
    }
}

