/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.List;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.WhitelistOnlyTileEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedButtonBlock
extends AbstractButtonBlock
implements IReinforcedBlock {
    private final Block vanillaBlock;
    public boolean isWoodenButton;

    public ReinforcedButtonBlock(boolean isWooden, Block.Properties properties, Block vb) {
        super(isWooden, properties);
        this.isWoodenButton = isWooden;
        this.vanillaBlock = vb;
    }

    public SoundEvent func_196369_b(boolean powered) {
        if (this.isWoodenButton) {
            return powered ? SoundEvents.field_187885_gS : SoundEvents.field_187883_gR;
        }
        return powered ? SoundEvents.field_187839_fV : SoundEvents.field_187837_fU;
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        if (this.isAllowedToPress(world, pos, (WhitelistOnlyTileEntity)world.func_175625_s(pos), player)) {
            return super.func_220051_a(state, world, pos, player, hand, rayTrace);
        }
        return false;
    }

    public boolean isAllowedToPress(World world, BlockPos pos, WhitelistOnlyTileEntity te, PlayerEntity entity) {
        return te.getOwner().isOwner(entity) || ModuleUtils.getPlayersFromModule(world, pos, ModuleType.WHITELIST).contains(entity.func_200200_C_().func_150261_e().toLowerCase());
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlock;
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_196366_M, vanillaState.func_177229_b((IProperty)field_196366_M))).func_206870_a((IProperty)field_185512_D, vanillaState.func_177229_b((IProperty)field_185512_D))).func_206870_a((IProperty)field_176584_b, vanillaState.func_177229_b((IProperty)field_176584_b));
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)this)});
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (PlayerEntity)placer));
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WhitelistOnlyTileEntity();
    }
}

