/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.jei;

import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.IPasswordConvertible;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.compat.jei.ReinforcerRecipe;
import net.geforcemods.securitycraft.compat.jei.SecurityCraftToVanillaCategory;
import net.geforcemods.securitycraft.compat.jei.SlotMover;
import net.geforcemods.securitycraft.compat.jei.VanillaToSecurityCraftCategory;
import net.geforcemods.securitycraft.screen.CustomizeBlockScreen;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class SCJEIPlugin
implements IModPlugin {
    public static final ResourceLocation VTS_ID = new ResourceLocation("securitycraft", "vanilla_to_securitycraft");
    public static final ResourceLocation STV_ID = new ResourceLocation("securitycraft", "securitycraft_to_vanilla");

    public void registerRecipes(IRecipeRegistration registration) {
        List recipes = IReinforcedBlock.BLOCKS.stream().map(block -> new ReinforcerRecipe(((IReinforcedBlock)block).getVanillaBlock(), (Block)block)).collect(Collectors.toList());
        registration.addIngredientInfo((Object)new ItemStack((IItemProvider)SCContent.ADMIN_TOOL.get()), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe.admin_tool"});
        IPasswordConvertible.BLOCKS.forEach(pc -> registration.addIngredientInfo((Object)new ItemStack((IItemProvider)pc), VanillaTypes.ITEM, new String[]{"gui.securitycraft:scManual.recipe." + pc.getRegistryName().func_110623_a()}));
        registration.addRecipes(recipes, VTS_ID);
        registration.addRecipes(recipes, STV_ID);
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new VanillaToSecurityCraftCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SecurityCraftToVanillaCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get()), new ResourceLocation[]{VTS_ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_2.get()), new ResourceLocation[]{VTS_ID, STV_ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_3.get()), new ResourceLocation[]{VTS_ID, STV_ID});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(CustomizeBlockScreen.class, (IGuiContainerHandler)new SlotMover());
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("securitycraft", "securitycraft");
    }
}

