/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractFireballEntity;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class IMSBombEntity
extends AbstractFireballEntity {
    private String playerName = null;
    private LivingEntity targetMob = null;
    public int ticksFlying = 0;
    private int launchHeight;
    public boolean launching = true;

    public IMSBombEntity(EntityType<IMSBombEntity> type, World world) {
        super(SCContent.eTypeImsBomb, world);
    }

    public IMSBombEntity(World world, PlayerEntity targetEntity, double x, double y, double z, double targetX, double targetY, double targetZ, int height) {
        super(SCContent.eTypeImsBomb, x, y, z, targetX, targetY, targetZ, world);
        this.playerName = targetEntity.func_200200_C_().func_150254_d();
        this.launchHeight = height;
    }

    public IMSBombEntity(World world, LivingEntity targetEntity, double x, double y, double z, double targetX, double targetY, double targetZ, int height) {
        super(SCContent.eTypeImsBomb, x, y, z, targetX, targetY, targetZ, world);
        this.targetMob = targetEntity;
        this.launchHeight = height;
    }

    public void func_70071_h_() {
        if (!this.launching) {
            super.func_70071_h_();
            return;
        }
        if (this.ticksFlying < this.launchHeight) {
            this.func_213293_j(this.func_213322_ci().field_72450_a, 0.35f, this.func_213322_ci().field_72449_c);
            ++this.ticksFlying;
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else {
            this.setTarget();
        }
    }

    public void setTarget() {
        if (this.playerName != null && PlayerUtils.isPlayerOnline(this.playerName)) {
            PlayerEntity target = PlayerUtils.getPlayerFromName(this.playerName);
            double targetX = target.field_70165_t - this.field_70165_t;
            double targetY = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 2.0f) - (this.field_70163_u + 1.25);
            double targetZ = target.field_70161_v - this.field_70161_v;
            IMSBombEntity imsBomb = new IMSBombEntity(this.field_70170_p, target, this.field_70165_t, this.field_70163_u, this.field_70161_v, targetX, targetY, targetZ, 0);
            imsBomb.launching = false;
            WorldUtils.addScheduledTask((IWorld)this.field_70170_p, () -> this.field_70170_p.func_217376_c((Entity)imsBomb));
            this.func_70106_y();
        } else if (this.targetMob != null && !this.targetMob.field_70128_L) {
            double targetX = this.targetMob.field_70165_t - this.field_70165_t;
            double targetY = this.targetMob.func_174813_aQ().field_72338_b + (double)(this.targetMob.func_213302_cg() / 2.0f) - (this.field_70163_u + 1.25);
            double targetZ = this.targetMob.field_70161_v - this.field_70161_v;
            IMSBombEntity imsBomb = new IMSBombEntity(this.field_70170_p, this.targetMob, this.field_70165_t, this.field_70163_u, this.field_70161_v, targetX, targetY, targetZ, 0);
            imsBomb.launching = false;
            WorldUtils.addScheduledTask((IWorld)this.field_70170_p, () -> this.field_70170_p.func_217376_c((Entity)imsBomb));
            this.func_70106_y();
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && result.func_216346_c() == RayTraceResult.Type.BLOCK && BlockUtils.getBlock((IBlockReader)this.field_70170_p, ((BlockRayTraceResult)result).func_216350_a()) != SCContent.IMS.get()) {
            this.field_70170_p.func_217398_a((Entity)this, (double)((BlockRayTraceResult)result).func_216350_a().func_177958_n(), (double)((BlockRayTraceResult)result).func_216350_a().func_177956_o() + 1.0, (double)((BlockRayTraceResult)result).func_216350_a().func_177952_p(), 7.0f, ((Boolean)ConfigHandler.CONFIG.shouldSpawnFire.get()).booleanValue(), Explosion.Mode.BREAK);
            this.func_70106_y();
        }
    }

    protected float func_82341_c() {
        return 1.0f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public float func_70111_Y() {
        return 0.3f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

