/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateTEOwnable {
    private BlockPos pos;
    private String name;
    private String uuid;
    private boolean customizable;
    private CompoundNBT tag;

    public UpdateTEOwnable() {
    }

    public UpdateTEOwnable(BlockPos pos, String name, String uuid, boolean customizable, CompoundNBT tag) {
        this.pos = pos;
        this.name = name;
        this.uuid = uuid;
        this.customizable = customizable;
        this.tag = tag;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeLong(this.pos.func_218275_a());
        buf.func_180714_a(this.name);
        buf.func_180714_a(this.uuid);
        buf.writeBoolean(this.customizable);
        if (this.customizable) {
            buf.func_150786_a(this.tag);
        }
    }

    public void fromBytes(PacketBuffer buf) {
        this.pos = BlockPos.func_218283_e((long)buf.readLong());
        this.name = buf.func_150789_c(0x1FFFFFFF);
        this.uuid = buf.func_150789_c(0x1FFFFFFF);
        this.customizable = buf.readBoolean();
        if (this.customizable) {
            this.tag = buf.func_150793_b();
        }
    }

    public static void encode(UpdateTEOwnable message, PacketBuffer packet) {
        message.toBytes(packet);
    }

    public static UpdateTEOwnable decode(PacketBuffer packet) {
        UpdateTEOwnable message = new UpdateTEOwnable();
        message.fromBytes(packet);
        return message;
    }

    public static void onMessage(UpdateTEOwnable message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(message.pos);
            if (!(te instanceof IOwnable)) {
                return;
            }
            ((IOwnable)te).setOwner(message.uuid, message.name);
            if (message.customizable) {
                ((CustomizableTileEntity)te).func_145839_a(message.tag);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

