/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetExplosiveState {
    private int x;
    private int y;
    private int z;
    private String state;

    public SetExplosiveState() {
    }

    public SetExplosiveState(int x, int y, int z, String state) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.state = state;
    }

    public void fromBytes(PacketBuffer buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.state = buf.func_150789_c(0x1FFFFFFF);
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.func_180714_a(this.state);
    }

    public static void encode(SetExplosiveState message, PacketBuffer packet) {
        message.toBytes(packet);
    }

    public static SetExplosiveState decode(PacketBuffer packet) {
        SetExplosiveState message = new SetExplosiveState();
        message.fromBytes(packet);
        return message;
    }

    public static void onMessage(SetExplosiveState message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (BlockUtils.getBlock(player.field_70170_p, message.x, message.y, message.z) instanceof IExplosive) {
                if (message.state.equalsIgnoreCase("activate")) {
                    ((IExplosive)BlockUtils.getBlock(player.field_70170_p, message.x, message.y, message.z)).activateMine(player.field_70170_p, BlockUtils.toPos(message.x, message.y, message.z));
                } else if (message.state.equalsIgnoreCase("defuse")) {
                    ((IExplosive)BlockUtils.getBlock(player.field_70170_p, message.x, message.y, message.z)).defuseMine(player.field_70170_p, BlockUtils.toPos(message.x, message.y, message.z));
                } else if (message.state.equalsIgnoreCase("detonate")) {
                    ((IExplosive)BlockUtils.getBlock(player.field_70170_p, message.x, message.y, message.z)).explode(player.field_70170_p, BlockUtils.toPos(message.x, message.y, message.z));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

