/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.Option;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateSliderValue {
    private BlockPos pos;
    private int id;
    private double value;

    public UpdateSliderValue() {
    }

    public UpdateSliderValue(BlockPos pos, int id, double v) {
        this.pos = pos;
        this.id = id;
        this.value = v;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_218275_a());
        buf.writeInt(this.id);
        buf.writeDouble(this.value);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_218283_e((long)buf.readLong());
        this.id = buf.readInt();
        this.value = buf.readDouble();
    }

    public static void encode(UpdateSliderValue message, PacketBuffer packet) {
        message.toBytes((ByteBuf)packet);
    }

    public static UpdateSliderValue decode(PacketBuffer packet) {
        UpdateSliderValue message = new UpdateSliderValue();
        message.fromBytes((ByteBuf)packet);
        return message;
    }

    public static void onMessage(UpdateSliderValue message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockPos pos = message.pos;
            int id = message.id;
            double value = message.value;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            TileEntity te = player.field_70170_p.func_175625_s(pos);
            if (te instanceof ICustomizable) {
                Option<?> o = ((ICustomizable)te).customOptions()[id];
                if (o instanceof Option.DoubleOption) {
                    ((Option.DoubleOption)o).setValue(value);
                } else if (o instanceof Option.IntOption) {
                    ((Option.IntOption)o).setValue((int)value);
                }
                ((ICustomizable)te).onOptionChanged(((ICustomizable)te).customOptions()[id]);
                if (te instanceof CustomizableTileEntity) {
                    ((CustomizableTileEntity)te).sync();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

