/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.platform.GlStateManager;
import net.geforcemods.securitycraft.blocks.BlockPocketManagerBlock;
import net.geforcemods.securitycraft.tileentity.BlockPocketManagerTileEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlockPocketManagerTileEntityRenderer
extends TileEntityRenderer<BlockPocketManagerTileEntity> {
    public void render(BlockPocketManagerTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        int backZ;
        if (!te.showOutline) {
            return;
        }
        Direction facing = (Direction)te.func_195044_w().func_177229_b((IProperty)BlockPocketManagerBlock.FACING);
        int size = te.size;
        int half = (size - 1) / 2;
        int leftX = -half;
        int rightX = half + 1;
        int frontZ = facing == Direction.NORTH || facing == Direction.WEST ? 0 : 1;
        int n = backZ = facing == Direction.NORTH || facing == Direction.WEST ? size : 1 - size;
        if (facing == Direction.EAST || facing == Direction.WEST) {
            leftX = frontZ;
            rightX = backZ;
            frontZ = -half;
            backZ = half + 1;
        }
        BufferBuilder builder = Tessellator.func_178181_a().func_178180_c();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.lineWidth((float)2.0f);
        GlStateManager.disableTexture();
        GlStateManager.disableLighting();
        builder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        builder.func_181662_b((double)leftX, 0.0, (double)frontZ).func_181669_b(0, 0, 255, 255).func_181675_d();
        builder.func_181662_b((double)rightX, 0.0, (double)frontZ).func_181669_b(0, 0, 255, 255).func_181675_d();
        builder.func_181662_b((double)rightX, 0.0, (double)backZ).func_181669_b(0, 0, 255, 255).func_181675_d();
        builder.func_181662_b((double)leftX, 0.0, (double)backZ).func_181669_b(0, 0, 255, 255).func_181675_d();
        builder.func_181662_b((double)leftX, 0.0, (double)frontZ).func_181669_b(0, 0, 255, 255).func_181675_d();
        builder.func_181662_b((double)leftX, (double)size, (double)frontZ).func_181669_b(0, 0, 255, 255).func_181675_d();
        builder.func_181662_b((double)leftX, (double)size, (double)backZ).func_181669_b(0, 0, 255, 255).func_181675_d();
        builder.func_181662_b((double)leftX, 0.0, (double)backZ).func_181669_b(0, 0, 255, 255).func_181675_d();
        builder.func_181662_b((double)leftX, (double)size, (double)backZ).func_181669_b(0, 0, 0, 0).func_181675_d();
        builder.func_181662_b((double)rightX, (double)size, (double)backZ).func_181669_b(0, 0, 255, 255).func_181675_d();
        builder.func_181662_b((double)rightX, 0.0, (double)backZ).func_181669_b(0, 0, 255, 255).func_181675_d();
        builder.func_181662_b((double)rightX, (double)size, (double)backZ).func_181669_b(0, 0, 0, 0).func_181675_d();
        builder.func_181662_b((double)rightX, (double)size, (double)frontZ).func_181669_b(0, 0, 255, 255).func_181675_d();
        builder.func_181662_b((double)rightX, 0.0, (double)frontZ).func_181669_b(0, 0, 255, 255).func_181675_d();
        builder.func_181662_b((double)rightX, (double)size, (double)frontZ).func_181669_b(0, 0, 0, 0).func_181675_d();
        builder.func_181662_b((double)leftX, (double)size, (double)frontZ).func_181669_b(0, 0, 255, 255).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.enableLighting();
        GlStateManager.enableTexture();
        GlStateManager.popMatrix();
    }

    public boolean isGlobalRenderer(BlockPocketManagerTileEntity te) {
        return te.showOutline;
    }
}

