/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Calendar;
import net.geforcemods.securitycraft.tileentity.KeypadChestTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.model.ChestModel;
import net.minecraft.client.renderer.tileentity.model.LargeChestModel;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KeypadChestTileEntityRenderer
extends TileEntityRenderer<KeypadChestTileEntity> {
    private static final ResourceLocation CHRISTMAS_DOUBLE = new ResourceLocation("securitycraft:textures/entity/chest/christmas_double.png");
    private static final ResourceLocation NORMAL_DOUBLE_INACTIVE = new ResourceLocation("securitycraft:textures/entity/chest/double_chest_unactive.png");
    private static final ResourceLocation NORMAL_DOUBLE_ACTIVE = new ResourceLocation("securitycraft:textures/entity/chest/double_chest_active.png");
    private static final ResourceLocation CHRISTMAS_SINGLE = new ResourceLocation("securitycraft:textures/entity/chest/christmas.png");
    private static final ResourceLocation NORMAL_SINGLE_INACTIVE = new ResourceLocation("securitycraft:textures/entity/chest/chest_unactive.png");
    private static final ResourceLocation NORMAL_SINGLE_ACTIVE = new ResourceLocation("securitycraft:textures/entity/chest/chest_active.png");
    private static final ChestModel SMALL_MODEL = new ChestModel();
    private static final ChestModel LARGE_MODEL = new LargeChestModel();
    private boolean isChristmas;

    public KeypadChestTileEntityRenderer() {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
    }

    public void render(KeypadChestTileEntity tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        ChestType chesttype;
        GlStateManager.enableDepthTest();
        GlStateManager.depthFunc((int)515);
        GlStateManager.depthMask((boolean)true);
        BlockState BlockState2 = tileEntityIn.func_145830_o() ? tileEntityIn.func_195044_w() : (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)Direction.SOUTH);
        ChestType chestType = chesttype = BlockState2.func_196959_b((IProperty)ChestBlock.field_196314_b) ? (ChestType)BlockState2.func_177229_b((IProperty)ChestBlock.field_196314_b) : ChestType.SINGLE;
        if (chesttype != ChestType.LEFT) {
            boolean flag = chesttype != ChestType.SINGLE;
            ChestModel modelchest = this.getChestModel(tileEntityIn, destroyStage, flag);
            if (destroyStage >= 0) {
                GlStateManager.matrixMode((int)5890);
                GlStateManager.pushMatrix();
                GlStateManager.scalef((float)(flag ? 8.0f : 4.0f), (float)4.0f, (float)1.0f);
                GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
                GlStateManager.matrixMode((int)5888);
            } else {
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GlStateManager.pushMatrix();
            GlStateManager.enableRescaleNormal();
            GlStateManager.translatef((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
            float f = ((Direction)BlockState2.func_177229_b((IProperty)ChestBlock.field_176459_a)).func_185119_l();
            if ((double)Math.abs(f) > 1.0E-5) {
                GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.rotatef((float)f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            }
            this.rotateLid(tileEntityIn, partialTicks, modelchest);
            modelchest.func_78231_a();
            GlStateManager.disableRescaleNormal();
            GlStateManager.popMatrix();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (destroyStage >= 0) {
                GlStateManager.matrixMode((int)5890);
                GlStateManager.popMatrix();
                GlStateManager.matrixMode((int)5888);
            }
        }
    }

    private ChestModel getChestModel(KeypadChestTileEntity te, int partialTicks, boolean flag) {
        ResourceLocation resourcelocation = partialTicks >= 0 ? field_178460_a[partialTicks] : (this.isChristmas ? (flag ? CHRISTMAS_DOUBLE : CHRISTMAS_SINGLE) : (te.func_195480_a(partialTicks) >= 0.9f ? (flag ? NORMAL_DOUBLE_ACTIVE : NORMAL_SINGLE_ACTIVE) : (flag ? NORMAL_DOUBLE_INACTIVE : NORMAL_SINGLE_INACTIVE)));
        this.func_147499_a(resourcelocation);
        return flag ? LARGE_MODEL : SMALL_MODEL;
    }

    private void rotateLid(KeypadChestTileEntity te, float partialTicks, ChestModel chestModel) {
        float f = te.func_195480_a(partialTicks);
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        chestModel.func_205058_b().field_78795_f = -(f * 1.5707964f);
    }
}

