/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.platform.GlStateManager;
import net.geforcemods.securitycraft.blocks.ProjectorBlock;
import net.geforcemods.securitycraft.tileentity.ProjectorTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ProjectorTileEntityRenderer
extends TileEntityRenderer<ProjectorTileEntity> {
    public void render(ProjectorTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!te.isActive()) {
            return;
        }
        if (!te.func_191420_l()) {
            Direction direction = (Direction)te.func_195044_w().func_177229_b((IProperty)ProjectorBlock.FACING);
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)x, (double)y, (double)(z + 1.0));
            Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
            for (int i = 0; i < te.getProjectionWidth(); ++i) {
                for (int j = 0; j < te.getProjectionWidth(); ++j) {
                    GlStateManager.pushMatrix();
                    BlockPos pos = this.translateProjection(te, direction, i, j, te.getProjectionRange(), te.getProjectionOffset());
                    if (pos != null && !te.func_145831_w().func_175623_d(pos)) {
                        GlStateManager.popMatrix();
                        continue;
                    }
                    BlockRendererDispatcher blockRendererDispatcher = Minecraft.func_71410_x().func_175602_ab();
                    BlockState state = te.getProjectedBlock().func_176223_P();
                    GlStateManager.disableCull();
                    GlStateManager.scaled((double)0.9999, (double)0.9999, (double)0.9999);
                    blockRendererDispatcher.func_175016_a(state, te.func_145831_w().func_205052_D(pos));
                    GlStateManager.enableCull();
                    GlStateManager.popMatrix();
                }
            }
            GlStateManager.popMatrix();
        }
    }

    private BlockPos translateProjection(ProjectorTileEntity te, Direction direction, int x, int y, double distance, double offset) {
        BlockPos pos;
        if (direction == Direction.NORTH) {
            pos = new BlockPos((double)(te.func_174877_v().func_177958_n() + x) + offset, (double)(te.func_174877_v().func_177956_o() + y), (double)te.func_174877_v().func_177952_p() + distance);
            GlStateManager.translated((double)(0.0 + (double)x + offset), (double)(0.0 + (double)y), (double)distance);
        } else if (direction == Direction.SOUTH) {
            pos = new BlockPos((double)(te.func_174877_v().func_177958_n() + x) + offset, (double)(te.func_174877_v().func_177956_o() + y), (double)te.func_174877_v().func_177952_p() + -distance);
            GlStateManager.translated((double)(0.0 + (double)x + offset), (double)(0.0 + (double)y), (double)(-distance));
        } else if (direction == Direction.WEST) {
            pos = new BlockPos((double)te.func_174877_v().func_177958_n() + distance, (double)(te.func_174877_v().func_177956_o() + y), (double)(te.func_174877_v().func_177952_p() + x) + offset);
            GlStateManager.translated((double)distance, (double)(0.0 + (double)y), (double)(0.0 + (double)x + offset));
        } else if (direction == Direction.EAST) {
            pos = new BlockPos((double)te.func_174877_v().func_177958_n() + -distance, (double)(te.func_174877_v().func_177956_o() + y), (double)(te.func_174877_v().func_177952_p() + x) + offset);
            GlStateManager.translated((double)(-distance), (double)(0.0 + (double)y), (double)(0.0 + (double)x + offset));
        } else {
            return te.func_174877_v();
        }
        return pos;
    }

    public boolean isGlobalRenderer(ProjectorTileEntity te) {
        return true;
    }
}

