/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.blocks.RetinalScannerBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.RetinalScannerTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RetinalScannerTileEntityRenderer
extends TileEntityRenderer<RetinalScannerTileEntity> {
    private static final float CORRECT_FACTOR = 0.0018181818f;

    public void render(RetinalScannerTileEntity tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        Direction direction = (Direction)tileEntityIn.func_195044_w().func_177229_b((IProperty)RetinalScannerBlock.FACING);
        if (!tileEntityIn.hasModule(ModuleType.DISGUISE)) {
            this.render((float)x, (float)y, (float)z, direction, tileEntityIn.getPlayerProfile(), destroyStage);
        }
    }

    public void render(float x, float y, float z, @Nullable Direction facing, @Nullable GameProfile playerProfile, int destroyStage) {
        if (facing != null) {
            this.func_147499_a(this.getSkinTexture(playerProfile));
            GlStateManager.pushMatrix();
            switch (facing) {
                case NORTH: {
                    GlStateManager.translatef((float)(x + 0.25f), (float)(y + 0.0625f), (float)z);
                    break;
                }
                case SOUTH: {
                    GlStateManager.translatef((float)(x + 0.75f), (float)(y + 0.0625f), (float)(z + 1.0f));
                    GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case WEST: {
                    GlStateManager.translatef((float)x, (float)(y + 0.0625f), (float)(z + 0.75f));
                    GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case EAST: {
                    GlStateManager.translatef((float)(x + 1.0f), (float)(y + 0.0625f), (float)(z + 0.25f));
                    GlStateManager.rotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
            }
            GlStateManager.enableRescaleNormal();
            GlStateManager.scalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            GlStateManager.enableAlphaTest();
            RenderHelper.func_74518_a();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)1, (int)0);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(0.001818181830458343, 0.0027272727456875145, 0.0).func_187315_a(0.125, 0.25).func_181675_d();
            bufferbuilder.func_181662_b(0.001818181830458343, -0.5009090909152292, 0.0).func_187315_a(0.125, 0.125).func_181675_d();
            bufferbuilder.func_181662_b(-0.5018181818304583, -0.5009090909152292, 0.0).func_187315_a(0.25, 0.125).func_181675_d();
            bufferbuilder.func_181662_b(-0.5018181818304583, 0.0027272727456875145, 0.0).func_187315_a(0.25, 0.25).func_181675_d();
            tessellator.func_78381_a();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            bufferbuilder.func_181662_b(0.001818181830458343, 0.0027272727456875145, 0.0).func_187315_a(0.625, 0.25).func_181675_d();
            bufferbuilder.func_181662_b(0.001818181830458343, -0.5009090909152292, 0.0).func_187315_a(0.625, 0.125).func_181675_d();
            bufferbuilder.func_181662_b(-0.5018181818304583, -0.5009090909152292, 0.0).func_187315_a(0.75, 0.125).func_181675_d();
            bufferbuilder.func_181662_b(-0.5018181818304583, 0.0027272727456875145, 0.0).func_187315_a(0.75, 0.25).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.disableBlend();
            GlStateManager.popMatrix();
        }
    }

    private ResourceLocation getSkinTexture(@Nullable GameProfile profile) {
        ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
        if (((Boolean)ConfigHandler.CONFIG.retinalScannerFace.get()).booleanValue() && profile != null) {
            Minecraft minecraft = Minecraft.func_71410_x();
            Map map = minecraft.func_152342_ad().func_152788_a(profile);
            resourcelocation = map.containsKey(MinecraftProfileTexture.Type.SKIN) ? minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN) : DefaultPlayerSkin.func_177334_a((UUID)PlayerEntity.func_146094_a((GameProfile)profile));
        }
        return resourcelocation;
    }
}

