/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.tileentity.SecretSignTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.StandingSignBlock;
import net.minecraft.block.WallSignBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.RenderComponentsUtil;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.model.SignModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SecretSignTileEntityRenderer
extends TileEntityRenderer<SecretSignTileEntity> {
    private static final ResourceLocation OAK_TEXTURE = new ResourceLocation("textures/entity/signs/oak.png");
    private static final ResourceLocation SPRUCE_TEXTURE = new ResourceLocation("textures/entity/signs/spruce.png");
    private static final ResourceLocation BIRCH_TEXTURE = new ResourceLocation("textures/entity/signs/birch.png");
    private static final ResourceLocation ACACIA_TEXTURE = new ResourceLocation("textures/entity/signs/acacia.png");
    private static final ResourceLocation JUNGLE_TEXTURE = new ResourceLocation("textures/entity/signs/jungle.png");
    private static final ResourceLocation DARK_OAK_TEXTURE = new ResourceLocation("textures/entity/signs/dark_oak.png");
    private final SignModel model = new SignModel();

    public void render(SecretSignTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        BlockState state = te.func_195044_w();
        FontRenderer font = this.func_147498_b();
        GlStateManager.pushMatrix();
        if (state.func_177230_c() instanceof StandingSignBlock) {
            GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            GlStateManager.rotatef((float)(-((float)((Integer)state.func_177229_b((IProperty)StandingSignBlock.field_176413_a) * 360) / 16.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
            this.model.func_205064_b().field_78806_j = true;
        } else {
            GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            GlStateManager.rotatef((float)(-((Direction)state.func_177229_b((IProperty)WallSignBlock.field_176412_a)).func_185119_l()), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)0.0f, (float)-0.3125f, (float)-0.4375f);
            this.model.func_205064_b().field_78806_j = false;
        }
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)4.0f, (float)2.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.matrixMode((int)5888);
        } else {
            this.func_147499_a(this.getTextureForSign(state.func_177230_c()));
        }
        GlStateManager.enableRescaleNormal();
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)0.6666667f, (float)-0.6666667f, (float)-0.6666667f);
        this.model.func_78164_a();
        GlStateManager.popMatrix();
        GlStateManager.translatef((float)0.0f, (float)0.33333334f, (float)0.046666667f);
        GlStateManager.scalef((float)0.010416667f, (float)-0.010416667f, (float)0.010416667f);
        GlStateManager.normal3f((float)0.0f, (float)0.0f, (float)-0.010416667f);
        GlStateManager.depthMask((boolean)false);
        int i = te.func_214066_f().func_218388_g();
        if (te.isPlayerAllowedToSeeText((PlayerEntity)Minecraft.func_71410_x().field_71439_g) && destroyStage < 0) {
            for (int j = 0; j < 4; ++j) {
                String s = te.func_212364_a(j, textComponent -> {
                    List list = RenderComponentsUtil.func_178908_a((ITextComponent)textComponent, (int)90, (FontRenderer)font, (boolean)false, (boolean)true);
                    return list.isEmpty() ? "" : ((ITextComponent)list.get(0)).func_150254_d();
                });
                if (s == null) continue;
                font.func_211126_b(s, (float)(-font.func_78256_a(s) / 2), (float)(j * 10 - te.field_145915_a.length * 5), i);
                if (j != te.func_214064_s() || te.func_214065_t() < 0) continue;
                int k = font.func_78256_a(s.substring(0, Math.max(Math.min(te.func_214065_t(), s.length()), 0)));
                int l = font.func_78260_a() ? -1 : 1;
                int i1 = (k - font.func_78256_a(s) / 2) * l;
                int j1 = j * 10 - te.field_145915_a.length * 5;
                if (te.func_214069_r()) {
                    if (te.func_214065_t() < s.length()) {
                        AbstractGui.fill((int)i1, (int)(j1 - 1), (int)(i1 + 1), (int)(j1 + 9), (int)(0xFF000000 | i));
                    } else {
                        font.func_211126_b("_", (float)i1, (float)j1, i);
                    }
                }
                if (te.func_214067_u() == te.func_214065_t()) continue;
                int k1 = Math.min(te.func_214065_t(), te.func_214067_u());
                int l1 = Math.max(te.func_214065_t(), te.func_214067_u());
                int i2 = (font.func_78256_a(s.substring(0, k1)) - font.func_78256_a(s) / 2) * l;
                int j2 = (font.func_78256_a(s.substring(0, l1)) - font.func_78256_a(s) / 2) * l;
                this.func_217657_a(Math.min(i2, j2), j1, Math.max(i2, j2), j1 + 9);
            }
        }
        GlStateManager.depthMask((boolean)true);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
    }

    private ResourceLocation getTextureForSign(Block sign) {
        if (sign != SCContent.SECRET_OAK_SIGN.get() && sign != SCContent.SECRET_OAK_WALL_SIGN.get()) {
            if (sign != SCContent.SECRET_SPRUCE_SIGN.get() && sign != SCContent.SECRET_SPRUCE_WALL_SIGN.get()) {
                if (sign != SCContent.SECRET_BIRCH_SIGN.get() && sign != SCContent.SECRET_BIRCH_WALL_SIGN.get()) {
                    if (sign != SCContent.SECRET_ACACIA_SIGN.get() && sign != SCContent.SECRET_ACACIA_WALL_SIGN.get()) {
                        if (sign != SCContent.SECRET_JUNGLE_SIGN.get() && sign != SCContent.SECRET_JUNGLE_WALL_SIGN.get()) {
                            return sign != SCContent.SECRET_DARK_OAK_SIGN.get() && sign != SCContent.SECRET_DARK_OAK_WALL_SIGN.get() ? OAK_TEXTURE : DARK_OAK_TEXTURE;
                        }
                        return JUNGLE_TEXTURE;
                    }
                    return ACACIA_TEXTURE;
                }
                return BIRCH_TEXTURE;
            }
            return SPRUCE_TEXTURE;
        }
        return OAK_TEXTURE;
    }

    private void func_217657_a(int p_217657_1_, int p_217657_2_, int p_217657_3_, int p_217657_4_) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.color4f((float)0.0f, (float)0.0f, (float)255.0f, (float)255.0f);
        GlStateManager.disableTexture();
        GlStateManager.enableColorLogicOp();
        GlStateManager.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)p_217657_1_, (double)p_217657_4_, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)p_217657_3_, (double)p_217657_4_, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)p_217657_3_, (double)p_217657_2_, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)p_217657_1_, (double)p_217657_2_, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.disableColorLogicOp();
        GlStateManager.enableTexture();
    }
}

