/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.models.SecurityCameraModel;
import net.geforcemods.securitycraft.tileentity.SecurityCameraTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SecurityCameraTileEntityRenderer
extends TileEntityRenderer<SecurityCameraTileEntity> {
    private static final SecurityCameraModel modelSecurityCamera = new SecurityCameraModel();
    private static final ResourceLocation cameraTexture = new ResourceLocation("securitycraft:textures/block/security_camera1.png");

    public void render(SecurityCameraTileEntity te, double x, double y, double z, float par5, int par6) {
        if (te.down || Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71439_g.func_184187_bx().func_180425_c().equals((Object)te.func_174877_v())) {
            return;
        }
        float rotation = 0.0f;
        if (te.func_145830_o()) {
            Tessellator tessellator = Tessellator.func_178181_a();
            float brightness = te.func_145831_w().func_205052_D(te.func_174877_v());
            int skyBrightness = te.func_145831_w().func_217338_b(te.func_174877_v(), 0);
            int lightmapX = skyBrightness % 65536;
            int lightmapY = skyBrightness / 65536;
            tessellator.func_178180_c().putColorRGBA(0, (int)(brightness * 255.0f), (int)(brightness * 255.0f), (int)(brightness * 255.0f), 255);
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lightmapX, (float)lightmapY);
        }
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        Minecraft.func_71410_x().field_71446_o.func_110577_a(cameraTexture);
        GlStateManager.pushMatrix();
        if (te.func_145830_o() && BlockUtils.getBlock((IBlockReader)te.func_145831_w(), te.func_174877_v()) == SCContent.SECURITY_CAMERA.get()) {
            Direction side = (Direction)BlockUtils.getBlockProperty(this.func_178459_a(), te.func_174877_v(), SecurityCameraBlock.FACING);
            if (side == Direction.EAST) {
                rotation = -1.0f;
            } else if (side == Direction.SOUTH) {
                rotation = -10000.0f;
            } else if (side == Direction.WEST) {
                rotation = 1.0f;
            } else if (side == Direction.NORTH) {
                rotation = 0.0f;
            }
        } else {
            rotation = -10000.0f;
        }
        GlStateManager.rotatef((float)180.0f, (float)rotation, (float)0.0f, (float)1.0f);
        SecurityCameraTileEntityRenderer.modelSecurityCamera.cameraRotationPoint.field_78796_g = (float)te.cameraRotation;
        modelSecurityCamera.render(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.popMatrix();
        GlStateManager.popMatrix();
    }
}

