/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.SecurityCraftTileEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.items.CameraMonitorItem;
import net.geforcemods.securitycraft.misc.CameraView;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.MountCamera;
import net.geforcemods.securitycraft.network.server.RemoveCameraTag;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.tileentity.SecurityCameraTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.config.HoverChecker;

@OnlyIn(value=Dist.CLIENT)
public class CameraMonitorScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private PlayerInventory playerInventory;
    private CameraMonitorItem cameraMonitor;
    private CompoundNBT nbtTag;
    private Button prevPageButton;
    private Button nextPageButton;
    private ClickButton[] cameraButtons = new ClickButton[10];
    private ClickButton[] unbindButtons = new ClickButton[10];
    private HoverChecker[] hoverCheckers = new HoverChecker[10];
    private SecurityCraftTileEntity[] cameraTEs = new SecurityCraftTileEntity[10];
    private int[] cameraViewDim = new int[10];
    private int xSize = 176;
    private int ySize = 166;
    private int page = 1;

    public CameraMonitorScreen(PlayerInventory inventory, CameraMonitorItem item, CompoundNBT itemNBTTag) {
        super((ITextComponent)new TranslationTextComponent(((Item)SCContent.CAMERA_MONITOR.get()).func_77658_a(), new Object[0]));
        this.playerInventory = inventory;
        this.cameraMonitor = item;
        this.nbtTag = itemNBTTag;
    }

    public CameraMonitorScreen(PlayerInventory inventory, CameraMonitorItem item, CompoundNBT itemNBTTag, int page) {
        this(inventory, item, itemNBTTag);
        this.page = page;
    }

    public void init() {
        int i;
        super.init();
        this.prevPageButton = new ClickButton(-1, this.width / 2 - 68, this.height / 2 + 40, 20, 20, "<", this::actionPerformed);
        this.nextPageButton = new ClickButton(0, this.width / 2 + 52, this.height / 2 + 40, 20, 20, ">", this::actionPerformed);
        this.addButton((Widget)this.prevPageButton);
        this.addButton((Widget)this.nextPageButton);
        this.cameraButtons[0] = new ClickButton(1, this.width / 2 - 38, this.height / 2 - 60 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[1] = new ClickButton(2, this.width / 2 - 8, this.height / 2 - 60 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[2] = new ClickButton(3, this.width / 2 + 22, this.height / 2 - 60 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[3] = new ClickButton(4, this.width / 2 - 38, this.height / 2 - 30 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[4] = new ClickButton(5, this.width / 2 - 8, this.height / 2 - 30 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[5] = new ClickButton(6, this.width / 2 + 22, this.height / 2 - 30 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[6] = new ClickButton(7, this.width / 2 - 38, this.height / 2 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[7] = new ClickButton(8, this.width / 2 - 8, this.height / 2 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[8] = new ClickButton(9, this.width / 2 + 22, this.height / 2 + 10, 20, 20, "", this::actionPerformed);
        this.cameraButtons[9] = new ClickButton(10, this.width / 2 - 38, this.height / 2 + 40, 80, 20, "", this::actionPerformed);
        this.unbindButtons[0] = new ClickButton(11, this.width / 2 - 19, this.height / 2 - 68 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[1] = new ClickButton(12, this.width / 2 + 11, this.height / 2 - 68 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[2] = new ClickButton(13, this.width / 2 + 41, this.height / 2 - 68 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[3] = new ClickButton(14, this.width / 2 - 19, this.height / 2 - 38 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[4] = new ClickButton(15, this.width / 2 + 11, this.height / 2 - 38 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[5] = new ClickButton(16, this.width / 2 + 41, this.height / 2 - 38 + 10, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[6] = new ClickButton(17, this.width / 2 - 19, this.height / 2 + 2, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[7] = new ClickButton(18, this.width / 2 + 11, this.height / 2 + 2, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[8] = new ClickButton(19, this.width / 2 + 41, this.height / 2 + 2, 8, 8, "x", this::actionPerformed);
        this.unbindButtons[9] = new ClickButton(20, this.width / 2 + 41, this.height / 2 + 32, 8, 8, "x", this::actionPerformed);
        for (i = 0; i < 10; ++i) {
            ClickButton button = this.cameraButtons[i];
            int camID = button.id + (this.page - 1) * 10;
            ArrayList<CameraView> views = this.cameraMonitor.getCameraPositions(this.nbtTag);
            button.setMessage(button.getMessage() + camID);
            this.addButton((Widget)button);
            CameraView view = views.get(camID - 1);
            if (view != null) {
                if (view.dimension != Minecraft.func_71410_x().field_71439_g.field_71093_bK.func_186068_a()) {
                    this.hoverCheckers[button.id - 1] = new HoverChecker((Button)button, 20);
                    this.cameraViewDim[button.id - 1] = view.dimension;
                }
                TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(view.getLocation());
                if (BlockUtils.getBlock((IBlockReader)Minecraft.func_71410_x().field_71441_e, view.getLocation()) != SCContent.SECURITY_CAMERA.get() || te instanceof SecurityCameraTileEntity && !((SecurityCameraTileEntity)te).getOwner().isOwner((PlayerEntity)Minecraft.func_71410_x().field_71439_g) && !((SecurityCameraTileEntity)te).hasModule(ModuleType.SMART)) {
                    button.active = false;
                    this.cameraTEs[button.id - 1] = null;
                    continue;
                }
                this.cameraTEs[button.id - 1] = (SecurityCraftTileEntity)Minecraft.func_71410_x().field_71441_e.func_175625_s(view.getLocation());
                this.hoverCheckers[button.id - 1] = new HoverChecker((Button)button, 20);
                continue;
            }
            button.active = false;
            this.unbindButtons[button.id - 1].active = false;
            this.cameraTEs[button.id - 1] = null;
        }
        for (i = 0; i < 10; ++i) {
            this.addButton((Widget)this.unbindButtons[i]);
        }
        if (this.page == 1) {
            this.prevPageButton.active = false;
        }
        if (this.page == 3 || this.cameraMonitor.getCameraPositions(this.nbtTag).size() < this.page * 10 + 1) {
            this.nextPageButton.active = false;
        }
        for (i = this.cameraMonitor.getCameraPositions(this.nbtTag).size() + 1; i <= this.page * 10; ++i) {
            this.cameraButtons[i - 1 - (this.page - 1) * 10].active = false;
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.width - this.xSize) / 2;
        int startY = (this.height - this.ySize) / 2;
        this.blit(startX, startY, 0, 0, this.xSize, this.ySize);
        super.render(mouseX, mouseY, partialTicks);
        this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:monitor.selectCameras", new Object[0]), (float)(startX + this.xSize / 2 - this.font.func_78256_a(ClientUtils.localize("gui.securitycraft:monitor.selectCameras", new Object[0])) / 2), (float)(startY + 6), 0x404040);
        for (int i = 0; i < this.hoverCheckers.length; ++i) {
            if (this.hoverCheckers[i] == null || !this.hoverCheckers[i].checkHover(mouseX, mouseY)) continue;
            if (this.cameraTEs[i] == null) {
                this.renderTooltip(this.font.func_78271_c(ClientUtils.localize("gui.securitycraft:monitor.cameraInDifferentDim", new Object[0]).replace("#", this.cameraViewDim[i] + ""), 150), mouseX, mouseY, this.font);
            }
            if (this.cameraTEs[i] == null || !this.cameraTEs[i].hasCustomSCName()) continue;
            this.renderTooltip(this.font.func_78271_c(ClientUtils.localize("gui.securitycraft:monitor.cameraName", new Object[0]).replace("#", this.cameraTEs[i].getCustomSCName().func_150254_d()), 150), mouseX, mouseY, this.font);
        }
    }

    protected void actionPerformed(ClickButton button) {
        if (button.id == -1) {
            this.minecraft.func_147108_a((Screen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.nbtTag, this.page - 1));
        } else if (button.id == 0) {
            this.minecraft.func_147108_a((Screen)new CameraMonitorScreen(this.playerInventory, this.cameraMonitor, this.nbtTag, this.page + 1));
        } else if (button.id < 11) {
            int camID = button.id + (this.page - 1) * 10;
            CameraView view = this.cameraMonitor.getCameraPositions(this.nbtTag).get(camID - 1);
            if (BlockUtils.getBlock((IBlockReader)Minecraft.func_71410_x().field_71441_e, view.getLocation()) == SCContent.SECURITY_CAMERA.get()) {
                ((SecurityCameraBlock)BlockUtils.getBlock((IBlockReader)Minecraft.func_71410_x().field_71441_e, view.getLocation())).mountCamera((World)Minecraft.func_71410_x().field_71441_e, view.x, view.y, view.z, camID, (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                SecurityCraft.channel.sendToServer((Object)new MountCamera(view.x, view.y, view.z, camID));
                Minecraft.func_71410_x().field_71439_g.func_71053_j();
            } else {
                button.active = false;
            }
        } else {
            int camID = button.id - 10 + (this.page - 1) * 10;
            SecurityCraft.channel.sendToServer((Object)new RemoveCameraTag(this.playerInventory.func_70448_g(), camID));
            this.nbtTag.func_82580_o(CameraMonitorItem.getTagNameFromPosition(this.nbtTag, this.cameraMonitor.getCameraPositions(this.nbtTag).get(camID - 1)));
            button.active = false;
            this.cameraButtons[(camID - 1) % 10].active = false;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

