/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.containers.CustomizeBlockContainer;
import net.geforcemods.securitycraft.network.server.ToggleOption;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.NamedSlider;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.client.config.HoverChecker;

@OnlyIn(value=Dist.CLIENT)
public class CustomizeBlockScreen
extends ContainerScreen<CustomizeBlockContainer> {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("securitycraft:textures/gui/container/customize0.png"), new ResourceLocation("securitycraft:textures/gui/container/customize1.png"), new ResourceLocation("securitycraft:textures/gui/container/customize2.png"), new ResourceLocation("securitycraft:textures/gui/container/customize3.png"), new ResourceLocation("securitycraft:textures/gui/container/customize4.png"), new ResourceLocation("securitycraft:textures/gui/container/customize5.png")};
    private final List<Rectangle2d> extraAreas = new ArrayList<Rectangle2d>();
    private IModuleInventory moduleInv;
    private PictureButton[] descriptionButtons = new PictureButton[5];
    private Button[] optionButtons = new Button[5];
    private HoverChecker[] hoverCheckers = new HoverChecker[10];
    private final String blockName;

    public CustomizeBlockScreen(CustomizeBlockContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.moduleInv = container.moduleInv;
        this.blockName = BlockUtils.getBlock((IBlockReader)Minecraft.func_71410_x().field_71441_e, this.moduleInv.getTileEntity().func_174877_v()).func_149739_a().substring(5);
    }

    public void init() {
        super.init();
        int numberOfColumns = 2;
        for (int i = 0; i < this.moduleInv.getMaxNumberOfModules(); ++i) {
            int column = i % 2;
            this.descriptionButtons[i] = new PictureButton(i, this.field_147003_i + 127 + column * 22, this.field_147009_r + 16 + Math.floorDiv(i, 2) * 22, 20, 20, this.itemRenderer, new ItemStack((IItemProvider)this.moduleInv.acceptedModules()[i].getItem()));
            this.addButton((Widget)this.descriptionButtons[i]);
            this.hoverCheckers[i] = new HoverChecker((Button)this.descriptionButtons[i], 20);
        }
        TileEntity te = this.moduleInv.getTileEntity();
        if (te instanceof ICustomizable && ((ICustomizable)te).customOptions() != null) {
            ICustomizable customizableTe = (ICustomizable)te;
            for (int i = 0; i < customizableTe.customOptions().length; ++i) {
                Option<?> option = customizableTe.customOptions()[i];
                if (option instanceof GuiSlider.ISlider && option.isSlider()) {
                    if (option instanceof Option.DoubleOption) {
                        this.optionButtons[i] = new NamedSlider((ClientUtils.localize("option" + this.blockName + "." + option.getName(), new Object[0]) + " ").replace("#", option.toString()), this.blockName, i, this.field_147003_i + 178, this.field_147009_r + 10 + i * 25, 120, 20, "", "", (Double)((Option.DoubleOption)option).getMin(), (Double)((Option.DoubleOption)option).getMax(), (Double)((Option.DoubleOption)option).get(), true, false, (GuiSlider.ISlider)option);
                    } else if (option instanceof Option.IntOption) {
                        this.optionButtons[i] = new NamedSlider((ClientUtils.localize("option" + this.blockName + "." + option.getName(), new Object[0]) + " ").replace("#", option.toString()), this.blockName, i, this.field_147003_i + 178, this.field_147009_r + 10 + i * 25, 120, 20, "", "", (Integer)((Option.IntOption)option).getMin(), (Integer)((Option.IntOption)option).getMax(), (Integer)((Option.IntOption)option).get(), true, false, (GuiSlider.ISlider)option);
                    }
                    this.optionButtons[i].setFGColor(0xE0E0E0);
                } else {
                    this.optionButtons[i] = new ClickButton(i, this.field_147003_i + 178, this.field_147009_r + 10 + i * 25, 120, 20, this.getOptionButtonTitle(option), this::actionPerformed);
                    this.optionButtons[i].setFGColor(option.toString().equals(option.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0);
                }
                this.addButton((Widget)this.optionButtons[i]);
                this.hoverCheckers[i + this.moduleInv.getMaxNumberOfModules()] = new HoverChecker(this.optionButtons[i], 20);
            }
        }
        for (Button button : this.optionButtons) {
            if (button == null) continue;
            this.extraAreas.add(new Rectangle2d(button.x, button.y, button.getWidth(), button.getHeight()));
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        for (Button b : this.optionButtons) {
            if (!(b instanceof GuiSlider) || !((GuiSlider)b).dragging) continue;
            ((GuiSlider)b).mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().func_75211_c().func_190926_b()) {
            this.renderTooltip(this.getSlotUnderMouse().func_75211_c(), mouseX, mouseY);
        }
        for (int i = 0; i < this.hoverCheckers.length; ++i) {
            if (this.hoverCheckers[i] == null || !this.hoverCheckers[i].checkHover(mouseX, mouseY)) continue;
            if (i < this.moduleInv.getMaxNumberOfModules()) {
                this.renderTooltip(this.minecraft.field_71466_p.func_78271_c(this.getModuleDescription(i), 150), mouseX, mouseY, this.font);
                continue;
            }
            this.renderTooltip(this.minecraft.field_71466_p.func_78271_c(this.getOptionDescription(i), 150), mouseX, mouseY, this.font);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = ClientUtils.localize(this.moduleInv.getTileEntity().func_195044_w().func_177230_c().func_149739_a(), new Object[0]);
        this.font.func_211126_b(s, (float)(this.field_146999_f / 2 - this.font.func_78256_a(s) / 2), 6.0f, 0x404040);
        this.font.func_211126_b(ClientUtils.localize("container.inventory", new Object[0]), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURES[this.moduleInv.getMaxNumberOfModules()]);
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        this.blit(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void actionPerformed(ClickButton button) {
        Option<?> tempOption = ((ICustomizable)this.moduleInv.getTileEntity()).customOptions()[button.id];
        tempOption.toggle();
        button.setFGColor(tempOption.toString().equals(tempOption.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0);
        button.setMessage(this.getOptionButtonTitle(tempOption));
        SecurityCraft.channel.sendToServer((Object)new ToggleOption(this.moduleInv.getTileEntity().func_174877_v().func_177958_n(), this.moduleInv.getTileEntity().func_174877_v().func_177956_o(), this.moduleInv.getTileEntity().func_174877_v().func_177952_p(), button.id));
    }

    private String getModuleDescription(int buttonID) {
        String moduleDescription = "module" + this.blockName + "." + this.descriptionButtons[buttonID].getItemStack().func_77658_a().substring(5).replace("securitycraft.", "") + ".description";
        return ClientUtils.localize(this.descriptionButtons[buttonID].getItemStack().func_77658_a(), new Object[0]) + ":" + TextFormatting.RESET + "\n\n" + ClientUtils.localize(moduleDescription, new Object[0]);
    }

    private String getOptionDescription(int buttonID) {
        String optionDescription = "option" + this.blockName + "." + ((ICustomizable)this.moduleInv.getTileEntity()).customOptions()[buttonID - this.moduleInv.getSlots()].getName() + ".description";
        return ClientUtils.localize(optionDescription, new Object[0]);
    }

    private String getOptionButtonTitle(Option<?> option) {
        return (ClientUtils.localize("option" + this.blockName + "." + option.getName(), new Object[0]) + " ").replace("#", option.toString());
    }

    public List<Rectangle2d> getGuiExtraAreas() {
        return this.extraAreas;
    }
}

