/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.tileentity.IMSTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IMSScreen
extends ContainerScreen<GenericTEContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private IMSTileEntity tileEntity;
    private ClickButton targetButton;
    private int targetingOptionIndex = 0;

    public IMSScreen(GenericTEContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tileEntity = (IMSTileEntity)container.te;
        this.targetingOptionIndex = this.tileEntity.getTargetingOption().modeIndex;
    }

    public void init() {
        super.init();
        this.targetButton = new ClickButton(0, this.width / 2 - 38, this.height / 2 - 58, 120, 20, this.tileEntity.getTargetingOption() == IMSTileEntity.IMSTargetingMode.PLAYERS_AND_MOBS ? ClientUtils.localize("gui.securitycraft:ims.hostileAndPlayers", new Object[0]) : ClientUtils.localize("tooltip.securitycraft:module.players", new Object[0]), this::actionPerformed);
        this.addButton((Widget)this.targetButton);
        this.updateButtonText();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String imsName = ClientUtils.localize(((Block)SCContent.IMS.get()).func_149739_a(), new Object[0]);
        this.font.func_211126_b(imsName, (float)(this.field_146999_f / 2 - this.font.func_78256_a(imsName) / 2), 6.0f, 0x404040);
        this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:ims.target", new Object[0]), (float)(this.field_146999_f / 2 - 78), 30.0f, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        this.blit(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void actionPerformed(ClickButton button) {
        if (button.id == 0) {
            ++this.targetingOptionIndex;
            if (this.targetingOptionIndex > IMSTileEntity.IMSTargetingMode.values().length - 1) {
                this.targetingOptionIndex = 0;
            }
            this.tileEntity.setTargetingOption(IMSTileEntity.IMSTargetingMode.values()[this.targetingOptionIndex]);
            ClientUtils.syncTileEntity(this.tileEntity);
            this.updateButtonText();
        }
    }

    private void updateButtonText() {
        if (IMSTileEntity.IMSTargetingMode.values()[this.targetingOptionIndex] == IMSTileEntity.IMSTargetingMode.PLAYERS) {
            this.targetButton.setMessage(ClientUtils.localize("tooltip.securitycraft:module.playerCustomization.players", new Object[0]));
        } else if (IMSTileEntity.IMSTargetingMode.values()[this.targetingOptionIndex] == IMSTileEntity.IMSTargetingMode.PLAYERS_AND_MOBS) {
            this.targetButton.setMessage(ClientUtils.localize("gui.securitycraft:ims.hostileAndPlayers", new Object[0]));
        } else if (IMSTileEntity.IMSTargetingMode.values()[this.targetingOptionIndex] == IMSTileEntity.IMSTargetingMode.MOBS) {
            this.targetButton.setMessage(ClientUtils.localize("gui.securitycraft:ims.hostile", new Object[0]));
        }
    }
}

