/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.network.server.SetPassword;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class KeyChangerScreen
extends ContainerScreen<GenericTEContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private char[] allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\b', '\u001b'};
    private TextFieldWidget textboxNewPasscode;
    private TextFieldWidget textboxConfirmPasscode;
    private ClickButton confirmButton;
    private TileEntity tileEntity;

    public KeyChangerScreen(GenericTEContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tileEntity = container.te;
    }

    public void init() {
        super.init();
        this.minecraft.field_195559_v.func_197967_a(true);
        this.confirmButton = new ClickButton(0, this.width / 2 - 52, this.height / 2 + 52, 100, 20, ClientUtils.localize("gui.securitycraft:universalKeyChanger.confirm", new Object[0]), this::actionPerformed);
        this.addButton((Widget)this.confirmButton);
        this.confirmButton.active = false;
        this.textboxNewPasscode = new TextFieldWidget(this.font, this.width / 2 - 57, this.height / 2 - 47, 110, 12, "");
        this.textboxNewPasscode.func_146193_g(-1);
        this.textboxNewPasscode.func_146204_h(-1);
        this.textboxNewPasscode.func_146185_a(true);
        this.textboxNewPasscode.func_146203_f(20);
        this.textboxNewPasscode.func_146195_b(true);
        this.textboxConfirmPasscode = new TextFieldWidget(this.font, this.width / 2 - 57, this.height / 2 - 7, 110, 12, "");
        this.textboxConfirmPasscode.func_146193_g(-1);
        this.textboxConfirmPasscode.func_146204_h(-1);
        this.textboxConfirmPasscode.func_146185_a(true);
        this.textboxConfirmPasscode.func_146203_f(20);
    }

    public void onClose() {
        super.onClose();
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        GlStateManager.disableLighting();
        this.textboxNewPasscode.render(mouseX, mouseY, partialTicks);
        this.textboxConfirmPasscode.render(mouseX, mouseY, partialTicks);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String ukcName = ClientUtils.localize(((Item)SCContent.UNIVERSAL_KEY_CHANGER.get()).func_77658_a(), new Object[0]);
        this.font.func_211126_b(ukcName, (float)(this.field_146999_f / 2 - this.font.func_78256_a(ukcName) / 2), 6.0f, 0x404040);
        this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:universalKeyChanger.enterNewPasscode", new Object[0]), (float)(this.field_146999_f / 2 - this.font.func_78256_a(ClientUtils.localize("gui.securitycraft:universalKeyChanger.enterNewPasscode", new Object[0])) / 2), 25.0f, 0x404040);
        this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:universalKeyChanger.confirmNewPasscode", new Object[0]), (float)(this.field_146999_f / 2 - this.font.func_78256_a(ClientUtils.localize("gui.securitycraft:universalKeyChanger.confirmNewPasscode", new Object[0])) / 2), 65.0f, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        this.blit(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259) {
            TextFieldWidget focusedTextField;
            Object object = this.textboxNewPasscode.isFocused() ? this.textboxNewPasscode : (focusedTextField = this.textboxConfirmPasscode.isFocused() ? this.textboxConfirmPasscode : null);
            if (focusedTextField != null && focusedTextField.func_146179_b().length() > 0) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("random.click")), 0.15f, 1.0f);
                focusedTextField.func_146180_a(Utils.removeLastChar(focusedTextField.func_146179_b()));
                this.setConfirmButtonState();
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!this.isValidChar(typedChar)) {
            return false;
        }
        if (this.textboxNewPasscode.isFocused()) {
            this.textboxNewPasscode.charTyped(typedChar, keyCode);
        } else if (this.textboxConfirmPasscode.isFocused()) {
            this.textboxConfirmPasscode.charTyped(typedChar, keyCode);
        } else {
            return super.charTyped(typedChar, keyCode);
        }
        this.setConfirmButtonState();
        return true;
    }

    private boolean isValidChar(char c) {
        for (int x = 1; x <= this.allowedChars.length; ++x) {
            if (c != this.allowedChars[x - 1]) continue;
            return true;
        }
        return false;
    }

    private void setConfirmButtonState() {
        String newPasscode = this.textboxNewPasscode.func_146179_b();
        this.confirmButton.active = newPasscode != null && newPasscode.equals(this.textboxConfirmPasscode.func_146179_b());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.textboxNewPasscode.mouseClicked(mouseX, mouseY, mouseButton);
        this.textboxConfirmPasscode.mouseClicked(mouseX, mouseY, mouseButton);
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void actionPerformed(ClickButton button) {
        if (button.id == 0) {
            ((IPasswordProtected)this.tileEntity).setPassword(this.textboxNewPasscode.func_146179_b());
            SecurityCraft.channel.sendToServer((Object)new SetPassword(this.tileEntity.func_174877_v().func_177958_n(), this.tileEntity.func_174877_v().func_177956_o(), this.tileEntity.func_174877_v().func_177952_p(), this.textboxNewPasscode.func_146179_b()));
            ClientUtils.closePlayerScreen();
            PlayerUtils.sendMessageToPlayer((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ClientUtils.localize(((Item)SCContent.UNIVERSAL_KEY_CHANGER.get()).func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:universalKeyChanger.passcodeChanged", new Object[0]), TextFormatting.GREEN);
        }
    }
}

