/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.network.server.SetKeycardLevel;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.tileentity.KeycardReaderTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class KeycardReaderSetupScreen
extends ContainerScreen<GenericTEContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private KeycardReaderTileEntity te;
    private ClickButton lvlOfSecurityButton;
    private ClickButton requiresExactCardButton;
    private boolean requiresExactCard = false;
    private int lvlOfSecurity = 0;

    public KeycardReaderSetupScreen(GenericTEContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.te = (KeycardReaderTileEntity)container.te;
    }

    public void init() {
        super.init();
        this.lvlOfSecurityButton = new ClickButton(0, this.width / 2 - 73, this.height / 2 + 20, 150, 20, "", this::actionPerformed);
        this.addButton((Widget)this.lvlOfSecurityButton);
        this.requiresExactCardButton = new ClickButton(1, this.width / 2 - 85, this.height / 2 - 28, 125, 20, this.requiresExactCard ? ClientUtils.localize("gui.securitycraft:keycardSetup.equal", new Object[0]) : ClientUtils.localize("gui.securitycraft:keycardSetup.equalOrHigher", new Object[0]), this::actionPerformed);
        this.addButton((Widget)this.requiresExactCardButton);
        this.addButton((Widget)new ClickButton(2, this.width / 2 - 48, this.height / 2 + 30 + 20, 100, 20, ClientUtils.localize("gui.securitycraft:keycardSetup.save", new Object[0]), this::actionPerformed));
        this.updateButtonText();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:keycardSetup.explanation.1", new Object[0]), (float)(this.field_146999_f / 2 - this.font.func_78256_a(ClientUtils.localize("gui.securitycraft:keycardSetup.explanation.1", new Object[0])) / 2), 6.0f, 0x404040);
        this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:keycardSetup.explanation.2", new Object[0]), (float)(this.field_146999_f / 2 - this.font.func_78256_a(ClientUtils.localize("gui.securitycraft:keycardSetup.explanation.2", new Object[0])) / 2 - 2), 20.0f, 0x404040);
        this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:keycardSetup.explanation.3", new Object[0]), (float)(this.field_146999_f / 2 - this.font.func_78256_a(ClientUtils.localize("gui.securitycraft:keycardSetup.explanation.3", new Object[0])) / 2 - 11), 32.0f, 0x404040);
        this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:keycardSetup.explanation.4", new Object[0]), (float)(this.field_146999_f / 2 - this.font.func_78256_a(ClientUtils.localize("gui.securitycraft:keycardSetup.explanation.4", new Object[0])) / 2 - 10), 44.0f, 0x404040);
        this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:keycardSetup.explanation.5", new Object[0]), (float)(this.field_146999_f / 2 + 45), 61.0f, 0x404040);
        this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:keycardSetup.explanation.6", new Object[0]), (float)(this.field_146999_f / 2 - this.font.func_78256_a(ClientUtils.localize("gui.securitycraft:keycardSetup.explanation.6", new Object[0])) / 2 - 6), 77.0f, 0x404040);
        this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:keycardSetup.explanation.7", new Object[0]), (float)(this.field_146999_f / 2 - this.font.func_78256_a(ClientUtils.localize("gui.securitycraft:keycardSetup.explanation.7", new Object[0])) / 2 - 20), 89.0f, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        this.blit(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    private void updateButtonText() {
        if (++this.lvlOfSecurity > 5) {
            this.lvlOfSecurity = 1;
        }
        this.lvlOfSecurityButton.setMessage(ClientUtils.localize("gui.securitycraft:keycardSetup.lvlNeeded", new Object[0]) + " " + this.lvlOfSecurity);
    }

    protected void actionPerformed(ClickButton button) {
        switch (button.id) {
            case 0: {
                this.updateButtonText();
                break;
            }
            case 1: {
                this.requiresExactCard = !this.requiresExactCard;
                this.requiresExactCardButton.setMessage(this.requiresExactCard ? ClientUtils.localize("gui.securitycraft:keycardSetup.equal", new Object[0]) : ClientUtils.localize("gui.securitycraft:keycardSetup.equalOrHigher", new Object[0]));
                break;
            }
            case 2: {
                this.saveLvls();
            }
        }
    }

    private void saveLvls() {
        this.te.setPassword(String.valueOf(this.lvlOfSecurity));
        this.te.setRequiresExactKeycard(this.requiresExactCard);
        SecurityCraft.channel.sendToServer((Object)new SetKeycardLevel(this.te.func_174877_v().func_177958_n(), this.te.func_174877_v().func_177956_o(), this.te.func_174877_v().func_177952_p(), this.lvlOfSecurity, this.requiresExactCard));
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
    }
}

