/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.network.server.SetExplosiveState;
import net.geforcemods.securitycraft.network.server.UpdateNBTTagOnServer;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.screen.components.StringHoverChecker;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.InputMappings;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MineRemoteAccessToolScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/mrat.png");
    private static final ResourceLocation INFO_BOOK_ICONS = new ResourceLocation("securitycraft:textures/gui/info_book_icons.png");
    private ItemStack mrat;
    private ClickButton[][] guiButtons = new ClickButton[6][4];
    private static final int DEFUSE = 0;
    private static final int ACTIVATE = 1;
    private static final int DETONATE = 2;
    private static final int UNBIND = 3;
    private int xSize = 256;
    private int ySize = 184;
    private List<StringHoverChecker> hoverCheckers = new ArrayList<StringHoverChecker>();

    public MineRemoteAccessToolScreen(ItemStack item) {
        super((ITextComponent)new TranslationTextComponent(item.func_77977_a(), new Object[0]));
        this.mrat = item;
    }

    public void init() {
        int padding;
        super.init();
        int y = padding = 25;
        int[] coords = null;
        int id = 0;
        this.hoverCheckers.clear();
        for (int i = 0; i < 6; ++i) {
            y += 30;
            coords = this.getMineCoordinates(i);
            int startX = (this.width - this.xSize) / 2;
            int startY = (this.height - this.ySize) / 2;
            for (int j = 0; j < 4; ++j) {
                int btnX = startX + j * padding + 154;
                int btnY = startY + y - 48;
                switch (j) {
                    case 0: {
                        this.guiButtons[i][j] = new PictureButton(id++, btnX, btnY, 20, 20, this.itemRenderer, new ItemStack((IItemProvider)SCContent.WIRE_CUTTERS.get()), this::actionPerformed);
                        this.guiButtons[i][j].active = false;
                        break;
                    }
                    case 1: {
                        this.guiButtons[i][j] = new PictureButton(id++, btnX, btnY, 20, 20, this.itemRenderer, new ItemStack((IItemProvider)Items.field_151033_d), this::actionPerformed);
                        this.guiButtons[i][j].active = false;
                        break;
                    }
                    case 2: {
                        this.guiButtons[i][j] = new PictureButton(id++, btnX, btnY, 20, 20, INFO_BOOK_ICONS, 54, 1, 18, 18, this::actionPerformed);
                        this.guiButtons[i][j].active = false;
                        break;
                    }
                    case 3: {
                        this.guiButtons[i][j] = new ClickButton(id++, btnX, btnY, 20, 20, "X", this::actionPerformed);
                        this.guiButtons[i][j].active = false;
                    }
                }
                this.addButton((Widget)this.guiButtons[i][j]);
            }
            BlockPos minePos = new BlockPos(coords[0], coords[1], coords[2]);
            if (coords[0] == 0 && coords[1] == 0 && coords[2] == 0) continue;
            this.guiButtons[i][3].active = true;
            if (Minecraft.func_71410_x().field_71439_g.field_70170_p.func_195588_v(minePos)) {
                Block block = this.minecraft.field_71441_e.func_180495_p(minePos).func_177230_c();
                if (block instanceof IExplosive) {
                    boolean active = ((IExplosive)block).isActive((World)this.minecraft.field_71441_e, minePos);
                    boolean defusable = ((IExplosive)block).isDefusable();
                    this.guiButtons[i][0].active = active && defusable;
                    this.guiButtons[i][1].active = !active && defusable;
                    this.guiButtons[i][2].active = active;
                    this.hoverCheckers.add(new StringHoverChecker((Button)this.guiButtons[i][0], 20, ClientUtils.localize("gui.securitycraft:mrat.defuse", new Object[0])));
                    this.hoverCheckers.add(new StringHoverChecker((Button)this.guiButtons[i][1], 20, ClientUtils.localize("gui.securitycraft:mrat.activate", new Object[0])));
                    this.hoverCheckers.add(new StringHoverChecker((Button)this.guiButtons[i][2], 20, ClientUtils.localize("gui.securitycraft:mrat.detonate", new Object[0])));
                    this.hoverCheckers.add(new StringHoverChecker((Button)this.guiButtons[i][3], 20, ClientUtils.localize("gui.securitycraft:mrat.unbind", new Object[0])));
                    continue;
                }
                this.removeTagFromToolAndUpdate(this.mrat, coords[0], coords[1], coords[2]);
                for (int j = 0; j < 4; ++j) {
                    this.guiButtons[i][j].active = false;
                }
                continue;
            }
            for (int j = 0; j < 3; ++j) {
                this.hoverCheckers.add(new StringHoverChecker((Button)this.guiButtons[i][j], 20, ClientUtils.localize("gui.securitycraft:mrat.outOfRange", new Object[0])));
            }
            this.hoverCheckers.add(new StringHoverChecker((Button)this.guiButtons[i][3], 20, ClientUtils.localize("gui.securitycraft:mrat.unbind", new Object[0])));
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.width - this.xSize) / 2;
        int startY = (this.height - this.ySize) / 2;
        this.blit(startX, startY, 0, 0, this.xSize, this.ySize);
        super.render(mouseX, mouseY, partialTicks);
        String mratName = ClientUtils.localize(((Item)SCContent.REMOTE_ACCESS_MINE.get()).func_77658_a(), new Object[0]);
        this.font.func_211126_b(mratName, (float)(startX + this.xSize / 2 - this.font.func_78256_a(mratName)), (float)(startY + -25 + 13), 0xFF0000);
        for (int i = 0; i < 6; ++i) {
            int[] coords = this.getMineCoordinates(i);
            String line = coords[0] == 0 && coords[1] == 0 && coords[2] == 0 ? ClientUtils.localize("gui.securitycraft:mrat.notBound", new Object[0]) : ClientUtils.localize("gui.securitycraft:mrat.mineLocations", new Object[0]).replace("#location", Utils.getFormattedCoordinates(new BlockPos(coords[0], coords[1], coords[2])));
            this.font.func_211126_b(line, (float)(startX + this.xSize / 2 - this.font.func_78256_a(line) + 25), (float)(startY + i * 30 + 13), 0x404040);
        }
        for (StringHoverChecker chc : this.hoverCheckers) {
            if (chc == null || !chc.checkHover(mouseX, mouseY) || chc.getName() == null) continue;
            this.renderTooltip(chc.getLines(), mouseX, mouseY);
        }
    }

    protected void actionPerformed(ClickButton button) {
        int mine = button.id / 4;
        int action = button.id % 4;
        int[] coords = this.getMineCoordinates(mine);
        switch (action) {
            case 0: {
                ((IExplosive)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_180495_p(new BlockPos(coords[0], coords[1], coords[2])).func_177230_c()).defuseMine(Minecraft.func_71410_x().field_71439_g.field_70170_p, new BlockPos(coords[0], coords[1], coords[2]));
                SecurityCraft.channel.sendToServer((Object)new SetExplosiveState(coords[0], coords[1], coords[2], "defuse"));
                this.guiButtons[mine][0].active = false;
                this.guiButtons[mine][1].active = true;
                this.guiButtons[mine][2].active = false;
                break;
            }
            case 1: {
                ((IExplosive)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_180495_p(new BlockPos(coords[0], coords[1], coords[2])).func_177230_c()).activateMine(Minecraft.func_71410_x().field_71439_g.field_70170_p, new BlockPos(coords[0], coords[1], coords[2]));
                SecurityCraft.channel.sendToServer((Object)new SetExplosiveState(coords[0], coords[1], coords[2], "activate"));
                this.guiButtons[mine][0].active = true;
                this.guiButtons[mine][1].active = false;
                this.guiButtons[mine][2].active = true;
                break;
            }
            case 2: {
                SecurityCraft.channel.sendToServer((Object)new SetExplosiveState(coords[0], coords[1], coords[2], "detonate"));
                this.removeTagFromToolAndUpdate(this.mrat, coords[0], coords[1], coords[2]);
                for (int i = 0; i < 4; ++i) {
                    this.guiButtons[mine][i].active = false;
                }
                break;
            }
            case 3: {
                this.removeTagFromToolAndUpdate(this.mrat, coords[0], coords[1], coords[2]);
                for (int i = 0; i < 4; ++i) {
                    this.guiButtons[mine][i].active = false;
                }
                break;
            }
        }
    }

    private int[] getMineCoordinates(int mine) {
        if (this.mrat.func_77973_b() != null && this.mrat.func_77973_b() == SCContent.REMOTE_ACCESS_MINE.get() && this.mrat.func_77978_p() != null && this.mrat.func_77978_p().func_74759_k("mine" + ++mine) != null && this.mrat.func_77978_p().func_74759_k("mine" + mine).length > 0) {
            return this.mrat.func_77978_p().func_74759_k("mine" + mine);
        }
        return new int[]{0, 0, 0};
    }

    private void removeTagFromToolAndUpdate(ItemStack stack, int x, int y, int z) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("mine" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("mine" + i))[0] != x || coords[1] != y || coords[2] != z || coords[0] == 0 && coords[1] == 0 && coords[2] == 0) continue;
            stack.func_77978_p().func_74783_a("mine" + i, new int[]{0, 0, 0});
            SecurityCraft.channel.sendToServer((Object)new UpdateNBTTagOnServer(stack));
            return;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.minecraft.field_71474_y.field_151445_Q.isActiveAndMatches(InputMappings.func_197954_a((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }
}

