/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.SecurityCraftTileEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.screen.components.IngredientDisplay;
import net.geforcemods.securitycraft.screen.components.StringHoverChecker;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.GuiUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.config.HoverChecker;

@OnlyIn(value=Dist.CLIENT)
public class SCManualScreen
extends Screen {
    private ResourceLocation infoBookTexture = new ResourceLocation("securitycraft:textures/gui/info_book_texture.png");
    private ResourceLocation infoBookTextureSpecial = new ResourceLocation("securitycraft:textures/gui/info_book_texture_special.png");
    private ResourceLocation infoBookTitlePage = new ResourceLocation("securitycraft:textures/gui/info_book_title_page.png");
    private ResourceLocation infoBookIcons = new ResourceLocation("securitycraft:textures/gui/info_book_icons.png");
    private static ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    private List<HoverChecker> hoverCheckers = new ArrayList<HoverChecker>();
    private static int lastPage = -1;
    private int currentPage = lastPage;
    private NonNullList<Ingredient> recipe;
    private IngredientDisplay[] displays = new IngredientDisplay[9];
    private int startX = -1;
    private boolean update = false;
    private List<String> subpages = new ArrayList<String>();
    private int currentSubpage = 0;
    private final int subpageLength = 1285;

    public SCManualScreen() {
        super((ITextComponent)new TranslationTextComponent(((Item)SCContent.SC_MANUAL.get()).func_77658_a(), new Object[0]));
    }

    public void init() {
        int startY = 2;
        if ((this.width - 256) / 2 != this.startX && this.startX != -1) {
            this.update = true;
        }
        this.startX = (this.width - 256) / 2;
        this.minecraft.field_195559_v.func_197967_a(true);
        this.addButton((Widget)new ChangePageButton(1, this.startX + 210, startY + 158, true, this::actionPerformed));
        this.addButton((Widget)new ChangePageButton(2, this.startX + 16, startY + 158, false, this::actionPerformed));
        this.addButton((Widget)new ChangePageButton(3, this.startX + 180, startY + 97, true, this::actionPerformed));
        this.addButton((Widget)new ChangePageButton(4, this.startX + 155, startY + 97, false, this::actionPerformed));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.displays[i * 3 + j] = new IngredientDisplay(this.startX + 100 + j * 20, 144 + i * 20);
            }
        }
        this.updateRecipeAndIcons();
        SecurityCraft.instance.manualPages.sort((page1, page2) -> {
            String key1 = ClientUtils.localize(page1.getItem().func_77658_a(), new Object[0]);
            String key2 = ClientUtils.localize(page2.getItem().func_77658_a(), new Object[0]);
            return key1.compareTo(key2);
        });
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.update) {
            this.updateRecipeAndIcons();
            this.update = false;
        }
        if (this.currentPage == -1) {
            this.minecraft.func_110434_K().func_110577_a(this.infoBookTitlePage);
        } else if (this.recipe != null || SecurityCraft.instance.manualPages.get(this.currentPage).isRecipeDisabled()) {
            this.minecraft.func_110434_K().func_110577_a(this.infoBookTexture);
        } else {
            this.minecraft.func_110434_K().func_110577_a(this.infoBookTextureSpecial);
        }
        this.blit(this.startX, 5, 0, 0, 256, 250);
        if (this.currentPage > -1) {
            if (SecurityCraft.instance.manualPages.get(this.currentPage).getHelpInfo().equals("help.securitycraft:reinforced.info")) {
                this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:scManual.reinforced", new Object[0]), (float)(this.startX + 39), 27.0f, 0);
            } else {
                this.font.func_211126_b(ClientUtils.localize(SecurityCraft.instance.manualPages.get(this.currentPage).getItem().func_77658_a(), new Object[0]), (float)(this.startX + 39), 27.0f, 0);
            }
            this.font.func_78279_b(this.subpages.get(this.currentSubpage), this.startX + 18, 45, 225, 0);
            String designedBy = SecurityCraft.instance.manualPages.get(this.currentPage).getDesignedBy();
            if (designedBy != null && !designedBy.isEmpty()) {
                this.font.func_78279_b(ClientUtils.localize("gui.securitycraft:scManual.designedBy", designedBy), this.startX + 18, 180, 75, 0);
            }
        } else {
            this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:scManual.intro.1", new Object[0]), (float)(this.startX + 39), 27.0f, 0);
            this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:scManual.intro.2", new Object[0]), (float)(this.startX + 60), 159.0f, 0);
            if (I18n.func_188566_a((String)"gui.securitycraft:scManual.author")) {
                this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:scManual.author", new Object[0]), (float)(this.startX + 65), 170.0f, 0);
            }
        }
        for (int i = 0; i < this.buttons.size(); ++i) {
            ((Widget)this.buttons.get(i)).render(mouseX, mouseY, partialTicks);
        }
        if (this.currentPage != -1) {
            if (this.subpages.size() > 1) {
                this.font.func_211126_b(this.currentSubpage + 1 + "/" + this.subpages.size(), (float)(this.startX + 205), 102.0f, 9339504);
            }
            this.font.func_211126_b(this.currentPage + 1 + "/" + SecurityCraft.instance.manualPages.size(), (float)(this.startX + 195), 192.0f, 9339504);
        }
        if (this.currentPage > -1) {
            Item item = SecurityCraft.instance.manualPages.get(this.currentPage).getItem();
            GuiUtils.drawItemToGui(item, this.startX + 19, 22, !(SecurityCraft.instance.manualPages.get(this.currentPage).getItem() instanceof BlockItem));
            this.minecraft.func_110434_K().func_110577_a(this.infoBookIcons);
            if (item instanceof BlockItem) {
                TileEntity te;
                Block block = ((BlockItem)item).func_179223_d();
                TileEntity tileEntity = te = block.hasTileEntity(block.func_176223_P()) ? block.createTileEntity(block.func_176223_P(), (IBlockReader)Minecraft.func_71410_x().field_71441_e) : null;
                if (block instanceof IExplosive) {
                    this.blit(this.startX + 107, 117, 54, 1, 18, 18);
                }
                if (te != null) {
                    if (te instanceof IOwnable) {
                        this.blit(this.startX + 29, 118, 1, 1, 16, 16);
                    }
                    if (te instanceof IPasswordProtected) {
                        this.blit(this.startX + 55, 118, 18, 1, 17, 16);
                    }
                    if (te instanceof SecurityCraftTileEntity && ((SecurityCraftTileEntity)te).isActivatedByView()) {
                        this.blit(this.startX + 81, 118, 36, 1, 17, 16);
                    }
                    if (te instanceof ICustomizable) {
                        ICustomizable scte = (ICustomizable)te;
                        this.blit(this.startX + 213, 118, 72, 1, 16, 16);
                        if (scte.customOptions() != null && scte.customOptions().length > 0) {
                            this.blit(this.startX + 136, 118, 88, 1, 16, 16);
                        }
                    }
                    if (te instanceof IModuleInventory && ((IModuleInventory)te).acceptedModules() != null && ((IModuleInventory)te).acceptedModules().length > 0) {
                        this.blit(this.startX + 163, 118, 105, 1, 16, 16);
                    }
                }
                for (IngredientDisplay display : this.displays) {
                    display.render(partialTicks);
                }
                for (int i = 0; i < this.hoverCheckers.size(); ++i) {
                    HoverChecker chc = this.hoverCheckers.get(i);
                    if (chc == null || !chc.checkHover(mouseX, mouseY)) continue;
                    if (chc instanceof StringHoverChecker && ((StringHoverChecker)chc).getName() != null) {
                        this.renderTooltip(((StringHoverChecker)chc).getLines(), mouseX, mouseY);
                        continue;
                    }
                    if (i >= this.displays.length || this.displays[i].getCurrentStack().func_190926_b()) continue;
                    this.renderTooltip(this.displays[i].getCurrentStack(), mouseX, mouseY);
                }
            }
        }
    }

    public void onClose() {
        super.onClose();
        lastPage = this.currentPage;
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (keyCode == 263) {
            this.previousSubpage();
        } else if (keyCode == 262) {
            this.nextSubpage();
        }
        return super.charTyped(typedChar, keyCode);
    }

    protected void actionPerformed(ClickButton button) {
        if (button.id == 1) {
            this.nextPage();
        } else if (button.id == 2) {
            this.previousPage();
        } else if (button.id == 3) {
            this.nextSubpage();
        } else if (button.id == 4) {
            this.previousSubpage();
        }
        ((Widget)this.buttons.get((int)2)).visible = this.currentPage != -1 && this.subpages.size() > 1;
        ((Widget)this.buttons.get((int)3)).visible = this.currentPage != -1 && this.subpages.size() > 1;
    }

    public boolean mouseScrolled(double aDouble, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        super.mouseScrolled(aDouble, p_mouseScrolled_3_, p_mouseScrolled_5_);
        switch ((int)Math.signum(p_mouseScrolled_5_)) {
            case -1: {
                this.nextPage();
                break;
            }
            case 1: {
                this.previousPage();
            }
        }
        ((Widget)this.buttons.get((int)2)).visible = this.currentPage != -1 && this.subpages.size() > 1;
        ((Widget)this.buttons.get((int)3)).visible = this.currentPage != -1 && this.subpages.size() > 1;
        return true;
    }

    private void nextPage() {
        ++this.currentPage;
        if (this.currentPage > SecurityCraft.instance.manualPages.size() - 1) {
            this.currentPage = -1;
        }
        this.updateRecipeAndIcons();
    }

    private void previousPage() {
        --this.currentPage;
        if (this.currentPage < -1) {
            this.currentPage = SecurityCraft.instance.manualPages.size() - 1;
        }
        this.updateRecipeAndIcons();
    }

    private void nextSubpage() {
        ++this.currentSubpage;
        if (this.currentSubpage == this.subpages.size()) {
            this.currentSubpage = 0;
        }
    }

    private void previousSubpage() {
        --this.currentSubpage;
        if (this.currentSubpage == -1) {
            this.currentSubpage = this.subpages.size() - 1;
        }
    }

    private void updateRecipeAndIcons() {
        String helpInfo;
        boolean reinforcedPage;
        this.currentSubpage = 0;
        this.hoverCheckers.clear();
        if (this.currentPage < 0) {
            this.recipe = null;
            ((Widget)this.buttons.get((int)2)).visible = false;
            ((Widget)this.buttons.get((int)3)).visible = false;
            return;
        }
        SCManualPage page = SecurityCraft.instance.manualPages.get(this.currentPage);
        for (IRecipe object : Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b()) {
            int i;
            NonNullList recipeItems;
            ShapedRecipe recipe;
            if (object instanceof ShapedRecipe) {
                recipe = (ShapedRecipe)object;
                if (!recipe.func_77571_b().func_190926_b() && recipe.func_77571_b().func_77973_b() == page.getItem()) {
                    recipeItems = NonNullList.func_191197_a((int)recipe.func_192400_c().size(), (Object)Ingredient.field_193370_a);
                    for (i = 0; i < recipeItems.size(); ++i) {
                        recipeItems.set(i, recipe.func_192400_c().get(i));
                    }
                    this.recipe = recipeItems;
                    break;
                }
            } else if (object instanceof ShapelessRecipe && !(recipe = (ShapelessRecipe)object).func_77571_b().func_190926_b() && recipe.func_77571_b().func_77973_b() == page.getItem()) {
                recipeItems = NonNullList.func_191197_a((int)recipe.func_192400_c().size(), (Object)Ingredient.field_193370_a);
                for (i = 0; i < recipeItems.size(); ++i) {
                    recipeItems.set(i, recipe.func_192400_c().get(i));
                }
                this.recipe = recipeItems;
                break;
            }
            this.recipe = null;
        }
        boolean bl = reinforcedPage = (helpInfo = page.getHelpInfo()).equals("help.securitycraft:reinforced.info") || helpInfo.contains("reinforced_hopper");
        if (this.recipe != null && !reinforcedPage) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.hoverCheckers.add(new HoverChecker(144 + i * 20, 144 + i * 20 + 16, this.startX + 100 + j * 20, this.startX + 100 + j * 20 + 16, 20));
                }
            }
        } else if (page.isRecipeDisabled()) {
            this.hoverCheckers.add(new StringHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.disabled", new Object[0])));
        } else if (reinforcedPage) {
            this.recipe = null;
            this.hoverCheckers.add(new StringHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.recipe.reinforced", new Object[0])));
        } else {
            String name = page.getItem().getRegistryName().func_110623_a();
            this.hoverCheckers.add(new StringHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.recipe." + name, new Object[0])));
        }
        Item item = page.getItem();
        if (item instanceof BlockItem) {
            TileEntity te;
            Block block = ((BlockItem)item).func_179223_d();
            TileEntity tileEntity = te = block.hasTileEntity(block.func_176223_P()) ? block.createTileEntity(block.func_176223_P(), (IBlockReader)Minecraft.func_71410_x().field_71441_e) : null;
            if (block instanceof IExplosive) {
                this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 107, this.startX + 107 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.explosiveBlock", new Object[0])));
            }
            if (te != null) {
                IModuleInventory moduleInv;
                if (te instanceof IOwnable) {
                    this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 29, this.startX + 29 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.ownableBlock", new Object[0])));
                }
                if (te instanceof IPasswordProtected) {
                    this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 55, this.startX + 55 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.passwordProtectedBlock", new Object[0])));
                }
                if (te instanceof SecurityCraftTileEntity && ((SecurityCraftTileEntity)te).isActivatedByView()) {
                    this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 81, this.startX + 81 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.viewActivatedBlock", new Object[0])));
                }
                if (te instanceof ICustomizable) {
                    ICustomizable scte = (ICustomizable)te;
                    this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 213, this.startX + 213 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.customizableBlock", new Object[0])));
                    if (scte.customOptions() != null && scte.customOptions().length > 0) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(ClientUtils.localize("gui.securitycraft:scManual.options", new Object[0]));
                        arrayList.add("---");
                        for (Option<?> option : scte.customOptions()) {
                            arrayList.add("- " + ClientUtils.localize("option" + block.func_149739_a().substring(5) + "." + option.getName() + ".description", new Object[0]));
                            arrayList.add("");
                        }
                        arrayList.remove(arrayList.size() - 1);
                        this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 136, this.startX + 136 + 16, 20, arrayList));
                    }
                }
                if (te instanceof IModuleInventory && (moduleInv = (IModuleInventory)te).acceptedModules() != null && moduleInv.acceptedModules().length > 0) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(ClientUtils.localize("gui.securitycraft:scManual.modules", new Object[0]));
                    arrayList.add("---");
                    for (ModuleType moduleType : moduleInv.acceptedModules()) {
                        arrayList.add("- " + ClientUtils.localize("module" + block.func_149739_a().substring(5) + "." + moduleType.getItem().func_77658_a().substring(5).replace("securitycraft.", "") + ".description", new Object[0]));
                        arrayList.add("");
                    }
                    arrayList.remove(arrayList.size() - 1);
                    this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 163, this.startX + 163 + 16, 20, arrayList));
                }
            }
        }
        if (this.recipe != null && this.recipe.size() > 0) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int index = i * 3 + j;
                    if (index >= this.recipe.size()) {
                        this.displays[index].setIngredient(Ingredient.field_193370_a);
                        continue;
                    }
                    this.displays[index].setIngredient((Ingredient)this.recipe.get(index));
                }
            }
        } else {
            for (IngredientDisplay ingredientDisplay : this.displays) {
                ingredientDisplay.setIngredient(Ingredient.field_193370_a);
            }
        }
        helpInfo = ClientUtils.localize(page.getHelpInfo(), new Object[0]);
        this.subpages.clear();
        while (this.font.func_78256_a(helpInfo) > 1285) {
            String trimmed = this.font.func_78269_a(helpInfo, 1285);
            int lastIndex = trimmed.lastIndexOf(32);
            if (lastIndex > 0) {
                trimmed = trimmed.trim().substring(0, lastIndex);
            }
            trimmed = trimmed.trim();
            this.subpages.add(trimmed);
            helpInfo = helpInfo.replace(trimmed, "").trim();
        }
        this.subpages.add(helpInfo);
        ((Widget)this.buttons.get((int)2)).visible = this.currentPage != -1 && this.subpages.size() > 1;
        ((Widget)this.buttons.get((int)3)).visible = this.currentPage != -1 && this.subpages.size() > 1;
    }

    static class ChangePageButton
    extends ClickButton {
        private final boolean isForward;

        public ChangePageButton(int index, int xPos, int yPos, boolean forward, Consumer<ClickButton> onClick) {
            super(index, xPos, yPos, 23, 13, "", onClick);
            this.isForward = forward;
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                boolean isHovering = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
                GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(bookGuiTextures);
                int textureX = 0;
                int textureY = 192;
                if (isHovering) {
                    textureX += 23;
                }
                if (!this.isForward) {
                    textureY += 13;
                }
                this.blit(this.x, this.y, textureX, textureY, 23, 13);
            }
        }
    }
}

