/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.mines.IMSBlock;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.entity.IMSBombEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;

public class IMSTileEntity
extends CustomizableTileEntity
implements INamedContainerProvider {
    private int bombsRemaining = 4;
    private IMSTargetingMode targetingOption = IMSTargetingMode.PLAYERS_AND_MOBS;
    private boolean updateBombCount = false;

    public IMSTileEntity() {
        super(SCContent.teTypeIms);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.updateBombCount) {
            int mineCount = (Integer)BlockUtils.getBlockProperty(this.field_145850_b, this.field_174879_c, IMSBlock.MINES);
            if (mineCount - 1 >= 0 && mineCount <= 4) {
                BlockUtils.setBlockProperty(this.field_145850_b, this.field_174879_c, IMSBlock.MINES, (Integer)BlockUtils.getBlockProperty(this.field_145850_b, this.field_174879_c, IMSBlock.MINES) - 1);
            }
            this.updateBombCount = false;
        }
        if (this.field_145850_b.func_82737_E() % 80L == 0L) {
            this.launchMine();
        }
    }

    private void launchMine() {
        boolean launchedMine = false;
        if (this.bombsRemaining > 0) {
            double targetZ;
            double targetY;
            double targetX;
            int launchHeight;
            LivingEntity entity;
            double range = ((Integer)ConfigHandler.CONFIG.imsRange.get()).intValue();
            AxisAlignedBB area = BlockUtils.fromBounds(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 1).func_72314_b(range, range, range);
            List players = this.field_145850_b.func_175647_a(PlayerEntity.class, area, e -> !EntityUtils.isInvisible((LivingEntity)e));
            List mobs = this.field_145850_b.func_175647_a(MonsterEntity.class, area, e -> !EntityUtils.isInvisible((LivingEntity)e));
            Iterator playerIterator = players.iterator();
            Iterator mobIterator = mobs.iterator();
            while (this.targetingOption == IMSTargetingMode.PLAYERS_AND_MOBS && mobIterator.hasNext()) {
                entity = (LivingEntity)mobIterator.next();
                launchHeight = this.getLaunchHeight();
                if (PlayerUtils.isPlayerMountedOnCamera(entity) || this.hasModule(ModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(this.field_145850_b, this.field_174879_c, ModuleType.WHITELIST).contains(entity.func_200200_C_().func_150254_d().toLowerCase())) continue;
                targetX = entity.field_70165_t - ((double)this.field_174879_c.func_177958_n() + 0.5);
                targetY = entity.func_174813_aQ().field_72338_b + (double)(entity.func_213302_cg() / 2.0f) - ((double)this.field_174879_c.func_177956_o() + 1.25);
                targetZ = entity.field_70161_v - ((double)this.field_174879_c.func_177952_p() + 0.5);
                this.spawnMine(entity, targetX, targetY, targetZ, launchHeight);
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_184148_a((PlayerEntity)null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                --this.bombsRemaining;
                launchedMine = true;
                this.updateBombCount = true;
                break;
            }
            while (!launchedMine && this.targetingOption == IMSTargetingMode.MOBS && mobIterator.hasNext()) {
                entity = (MonsterEntity)mobIterator.next();
                launchHeight = this.getLaunchHeight();
                if (this.hasModule(ModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(this.field_145850_b, this.field_174879_c, ModuleType.WHITELIST).contains(entity.func_200200_C_().func_150254_d().toLowerCase())) continue;
                targetX = entity.field_70165_t - ((double)this.field_174879_c.func_177958_n() + 0.5);
                targetY = entity.func_174813_aQ().field_72338_b + (double)(entity.func_213302_cg() / 2.0f) - ((double)this.field_174879_c.func_177956_o() + 1.25);
                targetZ = entity.field_70161_v - ((double)this.field_174879_c.func_177952_p() + 0.5);
                this.spawnMine(entity, targetX, targetY, targetZ, launchHeight);
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_184148_a((PlayerEntity)null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                --this.bombsRemaining;
                launchedMine = true;
                this.updateBombCount = true;
                break;
            }
            while (!launchedMine && this.targetingOption == IMSTargetingMode.PLAYERS && playerIterator.hasNext()) {
                entity = (PlayerEntity)playerIterator.next();
                launchHeight = this.getLaunchHeight();
                if (entity != null && this.getOwner().isOwner((PlayerEntity)entity) || PlayerUtils.isPlayerMountedOnCamera(entity) || WorldUtils.isPathObstructed((Entity)entity, this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + ((double)((launchHeight - 1) / 3) + 0.5), (double)this.field_174879_c.func_177952_p() + 0.5, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v) || this.hasModule(ModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(this.field_145850_b, this.field_174879_c, ModuleType.WHITELIST).contains(entity.func_200200_C_().func_150254_d())) continue;
                targetX = entity.field_70165_t - ((double)this.field_174879_c.func_177958_n() + 0.5);
                targetY = entity.func_174813_aQ().field_72338_b + (double)(entity.func_213302_cg() / 2.0f) - ((double)this.field_174879_c.func_177956_o() + 1.25);
                targetZ = entity.field_70161_v - ((double)this.field_174879_c.func_177952_p() + 0.5);
                this.spawnMine((PlayerEntity)entity, targetX, targetY, targetZ, launchHeight);
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_184148_a((PlayerEntity)null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                --this.bombsRemaining;
                this.updateBombCount = true;
                break;
            }
        }
    }

    private void spawnMine(PlayerEntity target, double x, double y, double z, int launchHeight) {
        double addToX = this.bombsRemaining == 4 || this.bombsRemaining == 3 ? 1.2 : 0.55;
        double addToZ = this.bombsRemaining == 4 || this.bombsRemaining == 2 ? 1.2 : 0.6;
        this.field_145850_b.func_217376_c((Entity)new IMSBombEntity(this.field_145850_b, target, (double)this.field_174879_c.func_177958_n() + addToX, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + addToZ, x, y, z, launchHeight));
    }

    private void spawnMine(LivingEntity target, double x, double y, double z, int launchHeight) {
        double addToX = this.bombsRemaining == 4 || this.bombsRemaining == 3 ? 1.2 : 0.55;
        double addToZ = this.bombsRemaining == 4 || this.bombsRemaining == 2 ? 1.2 : 0.6;
        this.field_145850_b.func_217376_c((Entity)new IMSBombEntity(this.field_145850_b, target, (double)this.field_174879_c.func_177958_n() + addToX, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + addToZ, x, y, z, launchHeight));
    }

    private int getLaunchHeight() {
        BlockState state;
        int height;
        for (height = 1; height <= 9 && ((state = this.func_145831_w().func_180495_p(this.func_174877_v().func_177981_b(height))) == null || state.isAir((IBlockReader)this.func_145831_w(), this.func_174877_v())); ++height) {
        }
        return height * 3;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("bombsRemaining", this.bombsRemaining);
        tag.func_74768_a("targetingOption", this.targetingOption.modeIndex);
        tag.func_74757_a("updateBombCount", this.updateBombCount);
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("bombsRemaining")) {
            this.bombsRemaining = tag.func_74762_e("bombsRemaining");
        }
        if (tag.func_74764_b("targetingOption")) {
            this.targetingOption = IMSTargetingMode.values()[tag.func_74762_e("targetingOption")];
        }
        if (tag.func_74764_b("updateBombCount")) {
            this.updateBombCount = tag.func_74767_n("updateBombCount");
        }
    }

    public void setBombsRemaining(int bombsRemaining) {
        this.bombsRemaining = bombsRemaining;
    }

    public IMSTargetingMode getTargetingOption() {
        return this.targetingOption;
    }

    public void setTargetingOption(IMSTargetingMode targetingOption) {
        this.targetingOption = targetingOption;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.WHITELIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new GenericTEContainer(SCContent.cTypeIMS, windowId, this.field_145850_b, this.field_174879_c);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((Block)SCContent.IMS.get()).func_149739_a(), new Object[0]);
    }

    public static enum IMSTargetingMode {
        PLAYERS(0),
        PLAYERS_AND_MOBS(1),
        MOBS(2);

        public final int modeIndex;

        private IMSTargetingMode(int index) {
            this.modeIndex = index;
        }
    }
}

