/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.KeypadBlock;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.DisguisableTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.NetworkHooks;

public class KeypadTileEntity
extends DisguisableTileEntity
implements IPasswordProtected {
    private String passcode;
    private Option.BooleanOption isAlwaysActive = new Option.BooleanOption("isAlwaysActive", false){

        @Override
        public void toggle() {
            super.toggle();
            BlockUtils.setBlockProperty(KeypadTileEntity.this.field_145850_b, KeypadTileEntity.this.field_174879_c, KeypadBlock.POWERED, (Boolean)this.get());
            KeypadTileEntity.this.field_145850_b.func_195593_d(KeypadTileEntity.this.field_174879_c, (Block)SCContent.KEYPAD.get());
        }
    };
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.IntOption signalLength = new Option.IntOption(this, "signalLength", 60, 5, 400, 5, true);

    public KeypadTileEntity() {
        super(SCContent.teTypeKeypad);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("passcode", this.passcode);
        }
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("passcode")) {
            this.passcode = tag.func_74762_e("passcode") != 0 ? String.valueOf(tag.func_74762_e("passcode")) : tag.func_74779_i("passcode");
        }
    }

    @Override
    public void activate(PlayerEntity player) {
        if (!this.field_145850_b.field_72995_K && BlockUtils.getBlock((IBlockReader)this.func_145831_w(), this.func_174877_v()) instanceof KeypadBlock) {
            KeypadBlock.activate(this.field_145850_b, this.field_174879_c, (Integer)this.signalLength.get());
        }
    }

    @Override
    public void openPasswordGUI(PlayerEntity player) {
        if (this.getPassword() != null) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return new GenericTEContainer(SCContent.cTypeCheckPassword, windowId, KeypadTileEntity.this.field_145850_b, KeypadTileEntity.this.field_174879_c);
                    }

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent(((Block)SCContent.KEYPAD.get()).func_149739_a(), new Object[0]);
                    }
                }, (BlockPos)this.field_174879_c);
            }
        } else if (this.getOwner().isOwner(player)) {
            if (player instanceof ServerPlayerEntity) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                        return new GenericTEContainer(SCContent.cTypeSetPassword, windowId, KeypadTileEntity.this.field_145850_b, KeypadTileEntity.this.field_174879_c);
                    }

                    public ITextComponent func_145748_c_() {
                        return new TranslationTextComponent(((Block)SCContent.KEYPAD.get()).func_149739_a(), new Object[0]);
                    }
                }, (BlockPos)this.field_174879_c);
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, "SecurityCraft", ClientUtils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState blockState, PlayerEntity player, boolean isCodebreakerDisabled) {
        if (isCodebreakerDisabled) {
            PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(((Block)SCContent.KEYPAD.get()).func_149739_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), TextFormatting.RED);
        } else if (!((Boolean)BlockUtils.getBlockProperty(this.field_145850_b, this.field_174879_c, KeypadBlock.POWERED)).booleanValue()) {
            this.activate(player);
            return true;
        }
        return false;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.WHITELIST, ModuleType.BLACKLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.isAlwaysActive, this.sendMessage, this.signalLength};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }
}

