/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.util.List;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.entity.SecurityCameraEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PlayerUtils {
    public static PlayerEntity getPlayerFromName(String name) {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            List players = Minecraft.func_71410_x().field_71441_e.func_217369_A();
            for (PlayerEntity tempPlayer : players) {
                if (!tempPlayer.func_200200_C_().func_150254_d().equals(name)) continue;
                return tempPlayer;
            }
            return null;
        }
        List players = ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v();
        for (PlayerEntity tempPlayer : players) {
            if (!tempPlayer.func_200200_C_().func_150254_d().equals(name)) continue;
            return tempPlayer;
        }
        return null;
    }

    public static boolean isPlayerOnline(String name) {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            for (AbstractClientPlayerEntity player : Minecraft.func_71410_x().field_71441_e.func_217369_A()) {
                if (player == null || !player.func_200200_C_().func_150254_d().equals(name)) continue;
                return true;
            }
            return false;
        }
        return ServerLifecycleHooks.getCurrentServer().func_184103_al().func_152612_a(name) != null;
    }

    public static void sendMessageToPlayer(PlayerEntity player, String prefix, String text, TextFormatting color) {
        player.func_145747_a((ITextComponent)new StringTextComponent("[" + color + prefix + TextFormatting.WHITE + "] " + text));
    }

    public static void sendMessageEndingWithLink(ICommandSource sender, String prefix, String text, String link, TextFormatting color) {
        sender.func_145747_a(new StringTextComponent("[" + color + prefix + TextFormatting.WHITE + "] " + text + ": ").func_150257_a(ForgeHooks.newChatWithLinks((String)link)));
    }

    public static boolean isHoldingItem(PlayerEntity player, Supplier<Item> item) {
        return PlayerUtils.isHoldingItem(player, item.get());
    }

    public static boolean isHoldingItem(PlayerEntity player, Item item) {
        if (item == null && player.field_71071_by.func_70448_g().func_190926_b()) {
            return true;
        }
        return !player.field_71071_by.func_70448_g().func_190926_b() && player.field_71071_by.func_70448_g().func_77973_b() == item;
    }

    public static boolean isPlayerMountedOnCamera(LivingEntity entity) {
        return entity.func_184187_bx() instanceof SecurityCameraEntity;
    }
}

