/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.blocks.IPasswordConvertible;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.entity.SecurityCameraEntity;
import net.geforcemods.securitycraft.entity.SentryEntity;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.PlaySoundAtPos;
import net.geforcemods.securitycraft.tileentity.SecurityCameraTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDestroyBlockEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="securitycraft")
public class SCEventHandler {
    public static HashMap<String, String> tipsWithLink = new HashMap();

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!((Boolean)ConfigHandler.CONFIG.sayThanksMessage.get()).booleanValue()) {
            return;
        }
        String tipKey = SCEventHandler.getRandomTip();
        StringTextComponent message = new StringTextComponent("[" + TextFormatting.GOLD + "SecurityCraft" + TextFormatting.WHITE + "] " + ClientUtils.localize("messages.securitycraft:thanks", new Object[0]).replace("#", "v1.8.20") + " " + ClientUtils.localize("messages.securitycraft:tip", new Object[0]) + " " + ClientUtils.localize(tipKey, new Object[0]) + " ");
        if (tipsWithLink.containsKey(tipKey.split("\\.")[2])) {
            message.func_150257_a(ForgeHooks.newChatWithLinks((String)tipsWithLink.get(tipKey.split("\\.")[2])));
        }
        event.getPlayer().func_145747_a((ITextComponent)message);
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer()) && event.getPlayer().func_184187_bx() instanceof SecurityCameraEntity) {
            event.getPlayer().func_184187_bx().func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onDamageTaken(LivingHurtEvent event) {
        if (event.getEntity() != null && PlayerUtils.isPlayerMountedOnCamera(event.getEntityLiving())) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource() == CustomDamageSources.ELECTRICITY) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new PlaySoundAtPos(event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), SCSounds.ELECTRIFIED.path, 0.25, "blocks"));
        }
    }

    @SubscribeEvent
    public static void onBucketUsed(FillBucketEvent event) {
        if (event.getTarget() == null || event.getTarget().func_216346_c() == RayTraceResult.Type.BLOCK) {
            return;
        }
        ItemStack result = SCEventHandler.fillBucket(event.getWorld(), ((BlockRayTraceResult)event.getTarget()).func_216350_a());
        if (result.func_190926_b()) {
            return;
        }
        event.setFilledBucket(result);
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
            return;
        }
        if (event.getHand() == Hand.MAIN_HAND) {
            List sentries;
            World world = event.getWorld();
            if (!world.field_72995_K) {
                TileEntity tileEntity = world.func_175625_s(event.getPos());
                BlockState state = world.func_180495_p(event.getPos());
                Block block = state.func_177230_c();
                if (PlayerUtils.isHoldingItem(event.getPlayer(), SCContent.KEY_PANEL)) {
                    for (Block pc : IPasswordConvertible.BLOCKS) {
                        if (((IPasswordConvertible)pc).getOriginalBlock() != block) continue;
                        event.setUseBlock(Event.Result.DENY);
                        event.setUseItem(Event.Result.ALLOW);
                    }
                    return;
                }
                if (PlayerUtils.isHoldingItem(event.getPlayer(), SCContent.CODEBREAKER) && SCEventHandler.handleCodebreaking((PlayerInteractEvent)event)) {
                    event.setCanceled(true);
                    return;
                }
                if (tileEntity instanceof INameable && ((INameable)tileEntity).canBeNamed() && PlayerUtils.isHoldingItem(event.getPlayer(), Items.field_151057_cb) && event.getPlayer().field_71071_by.func_70448_g().func_82837_s()) {
                    event.setCanceled(true);
                    for (String character : new String[]{"(", ")"}) {
                        if (!event.getPlayer().field_71071_by.func_70448_g().func_200301_q().func_150254_d().contains(character)) continue;
                        PlayerUtils.sendMessageToPlayer(event.getPlayer(), "Naming", ClientUtils.localize("messages.securitycraft:naming.error", new Object[0]).replace("#n", event.getPlayer().field_71071_by.func_70448_g().func_200301_q().func_150254_d()).replace("#c", character), TextFormatting.RED);
                        return;
                    }
                    if (((INameable)tileEntity).getCustomSCName().equals(event.getPlayer().field_71071_by.func_70448_g().func_200301_q())) {
                        PlayerUtils.sendMessageToPlayer(event.getPlayer(), "Naming", ClientUtils.localize("messages.securitycraft:naming.alreadyMatches", new Object[0]).replace("#n", ((INameable)tileEntity).getCustomSCName().func_150254_d()), TextFormatting.RED);
                        return;
                    }
                    if (!event.getPlayer().func_184812_l_()) {
                        event.getPlayer().field_71071_by.func_70448_g().func_190918_g(1);
                    }
                    ((INameable)tileEntity).setCustomSCName(event.getPlayer().field_71071_by.func_70448_g().func_200301_q());
                    return;
                }
            }
            if (!(sentries = world.func_217357_a(SentryEntity.class, new AxisAlignedBB(event.getPos()))).isEmpty()) {
                event.setCanceled(((SentryEntity)((Object)sentries.get(0))).func_184645_a(event.getPlayer(), event.getHand()));
            }
        }
    }

    @SubscribeEvent
    public static void onBlockEventBreak(BlockEvent.BreakEvent event) {
        if (!(event.getWorld() instanceof World)) {
            return;
        }
        List sentries = ((World)event.getWorld()).func_217357_a(SentryEntity.class, new AxisAlignedBB(event.getPos()));
        if (!sentries.isEmpty()) {
            ItemStack disguiseModule;
            ArrayList<Block> blocks;
            BlockPos pos = event.getPos();
            if (!((SentryEntity)((Object)sentries.get(0))).getDisguiseModule().func_190926_b() && (blocks = ((ModuleItem)(disguiseModule = ((SentryEntity)((Object)sentries.get(0))).getDisguiseModule()).func_77973_b()).getBlockAddons(disguiseModule.func_77978_p())).size() > 0 && blocks.get(0) == event.getWorld().func_180495_p(pos).func_177230_c()) {
                event.setCanceled(true);
            }
            return;
        }
        sentries = ((World)event.getWorld()).func_217357_a(SentryEntity.class, new AxisAlignedBB(event.getPos().func_177984_a()));
        if (!sentries.isEmpty()) {
            ((SentryEntity)((Object)sentries.get(0))).func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onOwnership(OwnershipEvent event) {
        SCEventHandler.handleOwnableTEs(event);
    }

    @SubscribeEvent
    public static void onBlockBroken(BlockEvent.BreakEvent event) {
        if (event.getWorld() instanceof World && !event.getWorld().func_201670_d()) {
            List sentries;
            if (event.getWorld().func_175625_s(event.getPos()) instanceof IModuleInventory) {
                IModuleInventory te = (IModuleInventory)event.getWorld().func_175625_s(event.getPos());
                for (int i = 0; i < te.getMaxNumberOfModules(); ++i) {
                    if (((ItemStack)te.getInventory().get(i)).func_190926_b()) continue;
                    ItemStack stack = (ItemStack)te.getInventory().get(i);
                    ItemEntity item = new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), stack);
                    WorldUtils.addScheduledTask(event.getWorld(), () -> event.getWorld().func_217376_c((Entity)item));
                    te.onModuleRemoved(stack, ((ModuleItem)stack.func_77973_b()).getModuleType());
                    if (te instanceof CustomizableTileEntity) {
                        ((CustomizableTileEntity)te).createLinkedBlockAction(LinkedAction.MODULE_REMOVED, new Object[]{stack, ((ModuleItem)stack.func_77973_b()).getModuleType()}, (CustomizableTileEntity)te);
                    }
                    if (!(te instanceof SecurityCameraTileEntity)) continue;
                    SecurityCameraTileEntity cam = (SecurityCameraTileEntity)te;
                    cam.func_145831_w().func_195593_d(cam.func_174877_v().func_177967_a((Direction)cam.func_145831_w().func_180495_p(cam.func_174877_v()).func_177229_b((IProperty)SecurityCameraBlock.FACING), -1), cam.func_145831_w().func_180495_p(cam.func_174877_v()).func_177230_c());
                }
            }
            if (!(sentries = ((World)event.getWorld()).func_217357_a(SentryEntity.class, new AxisAlignedBB(event.getPos()))).isEmpty()) {
                ItemStack disguiseModule;
                ArrayList<Block> blocks;
                BlockPos pos = event.getPos();
                if (!((SentryEntity)((Object)sentries.get(0))).getDisguiseModule().func_190926_b() && (blocks = ((ModuleItem)(disguiseModule = ((SentryEntity)((Object)sentries.get(0))).getDisguiseModule()).func_77973_b()).getBlockAddons(disguiseModule.func_77978_p())).size() > 0) {
                    BlockState state = ((Block)blocks.get(0)).func_176223_P();
                    ((World)event.getWorld()).func_175656_a(pos, state.func_196954_c((IBlockReader)event.getWorld(), pos) == VoxelShapes.func_197868_b() ? state : Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof PlayerEntity && PlayerUtils.isPlayerMountedOnCamera(event.getTarget()) || event.getTarget() instanceof SentryEntity) {
            ((MobEntity)event.getEntity()).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        Block block;
        Item held;
        if (event.getPlayer() != null && ((held = event.getPlayer().func_184614_ca().func_77973_b()) == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get() || held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_2.get() || held == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_3.get()) && (block = IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.get(event.getState().func_177230_c())) != null) {
            event.setNewSpeed(10000.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingDestroyEvent(LivingDestroyBlockEvent event) {
        event.setCanceled(event.getEntity() instanceof WitherEntity && event.getState().func_177230_c() instanceof IReinforcedBlock);
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        if (event.isDismounting() && event.getEntityBeingMounted() instanceof SecurityCameraEntity && event.getEntityMounting() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityMounting();
            TileEntity te = event.getWorldObj().func_175625_s(event.getEntityBeingMounted().func_180425_c());
            if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player) && te instanceof SecurityCameraTileEntity && ((SecurityCameraTileEntity)te).hasModule(ModuleType.SMART)) {
                ((SecurityCameraTileEntity)te).lastPitch = player.field_70125_A;
                ((SecurityCameraTileEntity)te).lastYaw = player.field_70177_z;
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)event.getPlayer()) && event.getItemStack().func_77973_b() != SCContent.CAMERA_MONITOR.get()) {
            event.setCanceled(true);
        }
    }

    private static ItemStack fillBucket(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == SCContent.FAKE_WATER_BLOCK.get() && state.func_204520_s().func_206886_c() == SCContent.FAKE_WATER.get()) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return new ItemStack((IItemProvider)SCContent.FAKE_WATER_BUCKET.get(), 1);
        }
        if (block == SCContent.FAKE_LAVA_BLOCK.get() && state.func_204520_s().func_206886_c() == SCContent.FAKE_LAVA.get()) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return new ItemStack((IItemProvider)SCContent.FAKE_LAVA_BUCKET.get(), 1);
        }
        return ItemStack.field_190927_a;
    }

    private static void handleOwnableTEs(OwnershipEvent event) {
        if (event.getWorld().func_175625_s(event.getPos()) instanceof IOwnable) {
            String name = event.getPlayer().func_200200_C_().func_150254_d();
            String uuid = event.getPlayer().func_146103_bH().getId().toString();
            ((IOwnable)event.getWorld().func_175625_s(event.getPos())).getOwner().set(uuid, name);
        }
    }

    private static boolean handleCodebreaking(PlayerInteractEvent event) {
        if (((Boolean)ConfigHandler.CONFIG.allowCodebreakerItem.get()).booleanValue()) {
            World world = event.getPlayer().field_70170_p;
            TileEntity tileEntity = event.getPlayer().field_70170_p.func_175625_s(event.getPos());
            if (tileEntity instanceof IPasswordProtected) {
                if (event.getPlayer().func_184586_b(event.getHand()).func_77973_b() == SCContent.CODEBREAKER.get()) {
                    event.getPlayer().func_184586_b(event.getHand()).func_222118_a(1, (LivingEntity)event.getPlayer(), p -> p.func_213334_d(event.getHand()));
                }
                if (event.getPlayer().func_184812_l_() || new Random().nextInt(3) == 1) {
                    return ((IPasswordProtected)tileEntity).onCodebreakerUsed(world.func_180495_p(event.getPos()), event.getPlayer(), (Boolean)ConfigHandler.CONFIG.allowCodebreakerItem.get() == false);
                }
                return true;
            }
        }
        return false;
    }

    private static String getRandomTip() {
        String[] tips = new String[]{"messages.securitycraft:tip.scHelp", "messages.securitycraft:tip.trello", "messages.securitycraft:tip.patreon", "messages.securitycraft:tip.discord", "messages.securitycraft:tip.scserver"};
        return tips[new Random().nextInt(tips.length)];
    }

    static {
        tipsWithLink.put("trello", "https://trello.com/b/dbCNZwx0/securitycraft");
        tipsWithLink.put("patreon", "https://www.patreon.com/Geforce");
        tipsWithLink.put("discord", "https://discord.gg/U8DvBAW");
    }
}

