/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.tileentity.ClaymoreTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ClaymoreBlock
extends OwnableBlock
implements IExplosive {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty DEACTIVATED = BooleanProperty.func_177716_a((String)"deactivated");
    private static final VoxelShape NORTH_OFF = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)4.0, (double)7.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)5.0, (double)12.0, (double)5.0, (double)6.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)4.0, (double)4.0, (double)6.0, (double)5.0, (double)5.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)10.0, (double)4.0, (double)4.0, (double)11.0, (double)5.0, (double)5.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)3.0, (double)5.0, (double)5.0, (double)4.0), (VoxelShape)Block.func_208617_a((double)11.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)4.0))))));
    private static final VoxelShape NORTH_ON = VoxelShapes.func_197872_a((VoxelShape)NORTH_OFF, (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)4.0, (double)2.0, (double)4.0, (double)5.0, (double)3.0), (VoxelShape)Block.func_208617_a((double)12.0, (double)4.0, (double)2.0, (double)13.0, (double)5.0, (double)3.0)));
    private static final VoxelShape EAST_OFF = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)9.0, (double)0.0, (double)4.0, (double)11.0, (double)4.0, (double)12.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)10.0, (double)4.0, (double)4.0, (double)11.0, (double)5.0, (double)12.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)11.0, (double)4.0, (double)5.0, (double)12.0, (double)5.0, (double)6.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)11.0, (double)4.0, (double)10.0, (double)12.0, (double)5.0, (double)11.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)12.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)5.0), (VoxelShape)Block.func_208617_a((double)12.0, (double)4.0, (double)11.0, (double)13.0, (double)5.0, (double)12.0))))));
    private static final VoxelShape EAST_ON = VoxelShapes.func_197872_a((VoxelShape)EAST_OFF, (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)13.0, (double)4.0, (double)3.0, (double)14.0, (double)5.0, (double)4.0), (VoxelShape)Block.func_208617_a((double)13.0, (double)4.0, (double)12.0, (double)14.0, (double)5.0, (double)13.0)));
    private static final VoxelShape SOUTH_OFF = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)0.0, (double)9.0, (double)12.0, (double)4.0, (double)11.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)5.0, (double)11.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)4.0, (double)11.0, (double)6.0, (double)5.0, (double)12.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)10.0, (double)4.0, (double)11.0, (double)11.0, (double)5.0, (double)12.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)12.0, (double)5.0, (double)5.0, (double)13.0), (VoxelShape)Block.func_208617_a((double)11.0, (double)4.0, (double)12.0, (double)12.0, (double)5.0, (double)13.0))))));
    private static final VoxelShape SOUTH_ON = VoxelShapes.func_197872_a((VoxelShape)SOUTH_OFF, (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)4.0, (double)13.0, (double)4.0, (double)5.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)12.0, (double)4.0, (double)13.0, (double)13.0, (double)5.0, (double)14.0)));
    private static final VoxelShape WEST_OFF = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)0.0, (double)4.0, (double)5.0, (double)4.0, (double)12.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)4.0, (double)4.0, (double)5.0, (double)5.0, (double)12.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)4.0, (double)5.0, (double)4.0, (double)5.0, (double)6.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)4.0, (double)10.0, (double)4.0, (double)5.0, (double)11.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)3.0, (double)5.0, (double)5.0), (VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)11.0, (double)3.0, (double)5.0, (double)12.0))))));
    private static final VoxelShape WEST_ON = VoxelShapes.func_197872_a((VoxelShape)WEST_OFF, (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)4.0, (double)3.0, (double)2.0, (double)5.0, (double)4.0), (VoxelShape)Block.func_208617_a((double)3.0, (double)4.0, (double)12.0, (double)2.0, (double)5.0, (double)13.0)));

    public ClaymoreBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    public float func_176195_g(BlockState blockState, IBlockReader world, BlockPos pos) {
        return (Boolean)ConfigHandler.CONFIG.ableToBreakMines.get() == false ? -1.0f : super.func_176195_g(blockState, world, pos);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        if (world.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151579_a) {
            return;
        }
        world.func_175655_b(pos, true);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return BlockUtils.isSideSolid(world, pos.func_177977_b(), Direction.UP);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            if (!player.field_71071_by.func_70448_g().func_190926_b() && player.field_71071_by.func_70448_g().func_77973_b() == SCContent.WIRE_CUTTERS.get()) {
                world.func_175656_a(pos, (BlockState)((BlockState)((Block)SCContent.CLAYMORE.get()).func_176223_P().func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING))).func_206870_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
                return ActionResultType.SUCCESS;
            }
            if (!player.field_71071_by.func_70448_g().func_190926_b() && player.field_71071_by.func_70448_g().func_77973_b() == Items.field_151033_d) {
                world.func_175656_a(pos, (BlockState)((BlockState)((Block)SCContent.CLAYMORE.get()).func_176223_P().func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING))).func_206870_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        if (!(player.func_184812_l_() || world.field_72995_K || ((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED)).booleanValue())) {
            world.func_175655_b(pos, false);
            if (!EntityUtils.doesPlayerOwn(player, world, pos)) {
                world.func_217398_a((Entity)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 3.5f, ((Boolean)ConfigHandler.CONFIG.shouldSpawnFire.get()).booleanValue(), Explosion.Mode.BREAK);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K && world.func_180495_p(pos).func_196959_b((IProperty)DEACTIVATED) && !((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
            if (pos.equals((Object)new BlockPos(explosion.getPosition()))) {
                return;
            }
            world.func_175655_b(pos, false);
            world.func_217398_a((Entity)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 3.5f, ((Boolean)ConfigHandler.CONFIG.shouldSpawnFire.get()).booleanValue(), Explosion.Mode.BREAK);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx.func_195999_j());
    }

    public BlockState getStateForPlacement(World world, BlockPos pos, Direction facing, double hitX, double hitY, double hitZ, PlayerEntity placer) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)placer.func_174811_aO())).func_206870_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void activateMine(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockUtils.setBlockProperty(world, pos, DEACTIVATED, false);
        }
    }

    @Override
    public void defuseMine(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockUtils.setBlockProperty(world, pos, DEACTIVATED, true);
        }
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            world.func_175655_b(pos, false);
            world.func_217398_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 3.5f, true, Explosion.Mode.BREAK);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext ctx) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
                    return NORTH_OFF;
                }
                return NORTH_ON;
            }
            case EAST: {
                if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
                    return EAST_OFF;
                }
                return EAST_ON;
            }
            case SOUTH: {
                if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
                    return SOUTH_OFF;
                }
                return SOUTH_ON;
            }
            case WEST: {
                if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
                    return WEST_OFF;
                }
                return WEST_ON;
            }
        }
        return VoxelShapes.func_197868_b();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
        builder.func_206894_a(new IProperty[]{DEACTIVATED});
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED) == false;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ClaymoreTileEntity();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }
}

