/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.reinforced.BaseReinforcedBlock;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;

public class ReinforcedSlabBlock
extends BaseReinforcedBlock
implements IWaterLoggable {
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.field_208145_at;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_SHAPE = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public ReinforcedSlabBlock(Block.Properties properties, Block vB) {
        this(properties, () -> vB);
    }

    public ReinforcedSlabBlock(Block.Properties properties, Supplier<Block> vB) {
        super(properties, vB);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(TYPE, (Comparable)SlabType.BOTTOM)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_220074_n(BlockState state) {
        return state.func_177229_b(TYPE) != SlabType.DOUBLE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TYPE, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        SlabType type = (SlabType)state.func_177229_b(TYPE);
        switch (type) {
            case DOUBLE: {
                return VoxelShapes.func_197868_b();
            }
            case TOP: {
                return TOP_SHAPE;
            }
        }
        return BOTTOM_SHAPE;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() == this) {
            if (te instanceof IOwnable && !((IOwnable)te).getOwner().isOwner(ctx.func_195999_j())) {
                if (world.field_72995_K) {
                    PlayerUtils.sendMessageToPlayer(ctx.func_195999_j(), ClientUtils.localize("messages.securitycraft:reinforcedSlab", new Object[0]), ClientUtils.localize("messages.securitycraft:reinforcedSlab.cannotDoubleSlab", new Object[0]), TextFormatting.RED);
                }
                return state;
            }
            return (BlockState)((BlockState)state.func_206870_a(TYPE, (Comparable)SlabType.DOUBLE)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        IFluidState fluidState = ctx.func_195991_k().func_204610_c(pos);
        BlockState stateToSet = (BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)SlabType.BOTTOM)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        Direction dir = ctx.func_196000_l();
        return !(dir == Direction.DOWN || dir != Direction.UP && ctx.func_221532_j().field_72448_b - (double)pos.func_177956_o() > 0.5) ? stateToSet : (BlockState)stateToSet.func_206870_a(TYPE, (Comparable)SlabType.TOP);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext ctx) {
        ItemStack stack = ctx.func_195996_i();
        SlabType type = (SlabType)state.func_177229_b(TYPE);
        if (type != SlabType.DOUBLE && stack.func_77973_b() == this.func_199767_j()) {
            if (ctx.func_196012_c()) {
                boolean clickedUpperHalf = ctx.func_221532_j().field_72448_b - (double)ctx.func_195995_a().func_177956_o() > 0.5;
                Direction dir = ctx.func_196000_l();
                if (type == SlabType.BOTTOM) {
                    return dir == Direction.UP || clickedUpperHalf && dir.func_176740_k().func_176722_c();
                }
                return dir == Direction.DOWN || !clickedUpperHalf && dir.func_176740_k().func_176722_c();
            }
            return true;
        }
        return false;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState state, IFluidState fluidState) {
        return state.func_177229_b(TYPE) != SlabType.DOUBLE ? super.func_204509_a(world, pos, state, fluidState) : false;
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        return state.func_177229_b(TYPE) != SlabType.DOUBLE ? super.func_204510_a(world, pos, state, fluid) : false;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return world.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        if (state.func_177229_b(TYPE) == SlabType.DOUBLE) {
            return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)this), new ItemStack((IItemProvider)this)});
        }
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)this)});
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE, vanillaState.func_177229_b(TYPE))).func_206870_a((IProperty)WATERLOGGED, vanillaState.func_177229_b((IProperty)WATERLOGGED));
    }
}

