/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.SecretSignTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class AdminToolItem
extends Item {
    public AdminToolItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType onItemUseFirst(ItemStack stack, ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        PlayerEntity player = ctx.func_195999_j();
        if (!world.field_72995_K && ((Boolean)ConfigHandler.CONFIG.allowAdminTool.get()).booleanValue()) {
            String adminToolName = ClientUtils.localize(((Item)SCContent.ADMIN_TOOL.get()).func_77658_a(), new Object[0]);
            if (!player.func_184812_l_()) {
                PlayerUtils.sendMessageToPlayer(player, adminToolName, ClientUtils.localize("messages.securitycraft:adminTool.needCreative", new Object[0]), TextFormatting.DARK_PURPLE);
                return ActionResultType.FAIL;
            }
            if (world.func_175625_s(pos) != null) {
                ArrayList<ModuleType> modules;
                TileEntity te = world.func_175625_s(pos);
                boolean hasInfo = false;
                if (te instanceof IOwnable) {
                    PlayerUtils.sendMessageToPlayer(player, adminToolName, ClientUtils.localize("messages.securitycraft:adminTool.owner.name", new Object[0]).replace("#", ((IOwnable)te).getOwner().getName() == null ? "????" : ((IOwnable)te).getOwner().getName()), TextFormatting.DARK_PURPLE);
                    PlayerUtils.sendMessageToPlayer(player, adminToolName, ClientUtils.localize("messages.securitycraft:adminTool.owner.uuid", new Object[0]).replace("#", ((IOwnable)te).getOwner().getUUID() == null ? "????" : ((IOwnable)te).getOwner().getUUID()), TextFormatting.DARK_PURPLE);
                    hasInfo = true;
                }
                if (te instanceof IPasswordProtected) {
                    PlayerUtils.sendMessageToPlayer(player, adminToolName, ClientUtils.localize("messages.securitycraft:adminTool.password", new Object[0]).replace("#", ((IPasswordProtected)te).getPassword() == null ? "????" : ((IPasswordProtected)te).getPassword()), TextFormatting.DARK_PURPLE);
                    hasInfo = true;
                }
                if (te instanceof IModuleInventory && !(modules = ((IModuleInventory)te).getInsertedModules()).isEmpty()) {
                    PlayerUtils.sendMessageToPlayer(player, adminToolName, ClientUtils.localize("messages.securitycraft:adminTool.equippedModules", new Object[0]), TextFormatting.DARK_PURPLE);
                    for (ModuleType module : modules) {
                        PlayerUtils.sendMessageToPlayer(player, adminToolName, "- " + new TranslationTextComponent(module.getTranslationKey(), new Object[0]).func_150254_d(), TextFormatting.DARK_PURPLE);
                    }
                    hasInfo = true;
                }
                if (te instanceof SecretSignTileEntity) {
                    PlayerUtils.sendMessageToPlayer(player, adminToolName, "", TextFormatting.DARK_PURPLE);
                    for (int i = 0; i < 4; ++i) {
                        PlayerUtils.sendMessageToPlayer(player, adminToolName, ((SecretSignTileEntity)te).field_145915_a[i].func_150261_e(), TextFormatting.DARK_PURPLE);
                    }
                    hasInfo = true;
                }
                if (!hasInfo) {
                    PlayerUtils.sendMessageToPlayer(player, adminToolName, ClientUtils.localize("messages.securitycraft:adminTool.noInfo", new Object[0]), TextFormatting.DARK_PURPLE);
                }
                return ActionResultType.FAIL;
            }
            PlayerUtils.sendMessageToPlayer(player, adminToolName, ClientUtils.localize("messages.securitycraft:adminTool.noInfo", new Object[0]), TextFormatting.DARK_PURPLE);
        }
        return ActionResultType.FAIL;
    }
}

