/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.misc.CameraView;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.tileentity.SecurityCameraTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class CameraMonitorItem
extends Item {
    public CameraMonitorItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        return this.onItemUse(ctx.func_195999_j(), ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_195996_i(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c);
    }

    public ActionResultType onItemUse(PlayerEntity player, World world, BlockPos pos, ItemStack stack, Direction facing, double hitX, double hitY, double hitZ) {
        if (!world.field_72995_K) {
            if (BlockUtils.getBlock((IBlockReader)world, pos) == SCContent.SECURITY_CAMERA.get() && !PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
                if (!((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(player) && !((SecurityCameraTileEntity)world.func_175625_s(pos)).hasModule(ModuleType.SMART)) {
                    PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(((Item)SCContent.CAMERA_MONITOR.get()).func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:cameraMonitor.cannotView", new Object[0]), TextFormatting.RED);
                    return ActionResultType.SUCCESS;
                }
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new CompoundNBT());
                }
                CameraView view = new CameraView(pos, player.field_71093_bK.func_186068_a());
                if (this.isCameraAdded(stack.func_77978_p(), view)) {
                    stack.func_77978_p().func_82580_o(CameraMonitorItem.getTagNameFromPosition(stack.func_77978_p(), view));
                    PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(((Item)SCContent.CAMERA_MONITOR.get()).func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:cameraMonitor.unbound", new Object[0]).replace("#", Utils.getFormattedCoordinates(pos)), TextFormatting.RED);
                    return ActionResultType.SUCCESS;
                }
                for (int i = 1; i <= 30; ++i) {
                    if (stack.func_77978_p().func_74764_b("Camera" + i)) continue;
                    stack.func_77978_p().func_74778_a("Camera" + i, view.toNBTString());
                    PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(((Item)SCContent.CAMERA_MONITOR.get()).func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:cameraMonitor.bound", new Object[0]).replace("#", Utils.getFormattedCoordinates(pos)), TextFormatting.GREEN);
                    break;
                }
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new UpdateNBTTagOnClient(stack));
                return ActionResultType.SUCCESS;
            }
        } else if (world.field_72995_K && (BlockUtils.getBlock((IBlockReader)world, pos) != SCContent.SECURITY_CAMERA.get() || PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player))) {
            if (stack.func_77978_p() == null || stack.func_77978_p().isEmpty()) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(((Item)SCContent.CAMERA_MONITOR.get()).func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:cameraMonitor.rightclickToView", new Object[0]), TextFormatting.RED);
                return ActionResultType.SUCCESS;
            }
            SecurityCraft.proxy.displayCameraMonitorGui(player.field_71071_by, (CameraMonitorItem)stack.func_77973_b(), stack.func_77978_p());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            if (!stack.func_77942_o() || !this.hasCameraAdded(stack.func_77978_p())) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(((Item)SCContent.CAMERA_MONITOR.get()).func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:cameraMonitor.rightclickToView", new Object[0]), TextFormatting.RED);
                return ActionResult.func_226250_c_((Object)stack);
            }
            if (stack.func_77973_b() == SCContent.CAMERA_MONITOR.get()) {
                SecurityCraft.proxy.displayCameraMonitorGui(player.field_71071_by, (CameraMonitorItem)stack.func_77973_b(), stack.func_77978_p());
            }
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (stack.func_77978_p() == null) {
            return;
        }
        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + ClientUtils.localize("tooltip.securitycraft:cameraMonitor", new Object[0]) + " " + this.getNumberOfCamerasBound(stack.func_77978_p()) + "/30"));
    }

    public static String getTagNameFromPosition(CompoundNBT tag, CameraView view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!tag.func_74764_b("Camera" + i) || !view.checkCoordinates(coords = tag.func_74779_i("Camera" + i).split(" "))) continue;
            return "Camera" + i;
        }
        return "";
    }

    public boolean hasCameraAdded(CompoundNBT tag) {
        if (tag == null) {
            return false;
        }
        for (int i = 1; i <= 30; ++i) {
            if (!tag.func_74764_b("Camera" + i)) continue;
            return true;
        }
        return false;
    }

    public boolean isCameraAdded(CompoundNBT tag, CameraView view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!tag.func_74764_b("Camera" + i) || !view.checkCoordinates(coords = tag.func_74779_i("Camera" + i).split(" "))) continue;
            return true;
        }
        return false;
    }

    public ArrayList<CameraView> getCameraPositions(CompoundNBT tag) {
        ArrayList<CameraView> list = new ArrayList<CameraView>();
        for (int i = 1; i <= 30; ++i) {
            if (tag != null && tag.func_74764_b("Camera" + i)) {
                String[] coords = tag.func_74779_i("Camera" + i).split(" ");
                list.add(new CameraView(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]), coords.length == 4 ? Integer.parseInt(coords[3]) : 0));
                continue;
            }
            list.add(null);
        }
        return list;
    }

    public int getNumberOfCamerasBound(CompoundNBT tag) {
        if (tag == null) {
            return 0;
        }
        int amount = 0;
        for (int i = 1; i <= 31; ++i) {
            if (!tag.func_74764_b("Camera" + i)) continue;
            ++amount;
        }
        return amount;
    }
}

