/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.models;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.tileentity.DisguisableTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;

public class DisguisableDynamicBakedModel
implements IDynamicBakedModel {
    public static final ModelProperty<ResourceLocation> DISGUISED_BLOCK_RL = new ModelProperty();
    private final ResourceLocation defaultStateRl;
    private final IBakedModel oldModel;

    public DisguisableDynamicBakedModel(ResourceLocation defaultStateRl, IBakedModel oldModel) {
        this.defaultStateRl = defaultStateRl;
        this.oldModel = oldModel;
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, Random rand, IModelData modelData) {
        IBakedModel model;
        Block block;
        ResourceLocation rl = (ResourceLocation)modelData.getData(DISGUISED_BLOCK_RL);
        if (rl != this.defaultStateRl && (block = (Block)ForgeRegistries.BLOCKS.getValue(rl)) != null && (model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(block.func_176223_P())) != null && model != this) {
            return model.getQuads(block.func_176223_P(), side, rand, modelData);
        }
        return this.oldModel.getQuads(state, side, rand, modelData);
    }

    public TextureAtlasSprite getParticleTexture(IModelData modelData) {
        Block block;
        ResourceLocation rl = (ResourceLocation)modelData.getData(DISGUISED_BLOCK_RL);
        if (rl != this.defaultStateRl && (block = (Block)ForgeRegistries.BLOCKS.getValue(rl)) != null && !(block instanceof DisguisableBlock)) {
            return Minecraft.func_71410_x().func_175602_ab().func_184389_a(block.func_176223_P()).getParticleTexture(modelData);
        }
        return this.oldModel.getParticleTexture(modelData);
    }

    @Nonnull
    public IModelData getModelData(ILightReader world, BlockPos pos, BlockState state, IModelData tileData) {
        BlockState disguisedState;
        Block block;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof DisguisableTileEntity && (block = ((DisguisableTileEntity)te).func_195044_w().func_177230_c()) instanceof DisguisableBlock && (disguisedState = ((DisguisableBlock)block).getDisguisedBlockState((IBlockReader)world, pos)) != null) {
            tileData.setData(DISGUISED_BLOCK_RL, (Object)disguisedState.func_177230_c().getRegistryName());
            return tileData;
        }
        tileData.setData(DISGUISED_BLOCK_RL, (Object)this.defaultStateRl);
        return tileData;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.oldModel.func_177554_e();
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public boolean func_177555_b() {
        return true;
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }

    public boolean func_230044_c_() {
        return false;
    }
}

