/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.tileentity.KeycardReaderTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetKeycardLevel {
    private int x;
    private int y;
    private int z;
    private int level;
    private boolean exactCard;

    public SetKeycardLevel() {
    }

    public SetKeycardLevel(int x, int y, int z, int level, boolean exactCard) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.level = level;
        this.exactCard = exactCard;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.level);
        buf.writeBoolean(this.exactCard);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.level = buf.readInt();
        this.exactCard = buf.readBoolean();
    }

    public static void encode(SetKeycardLevel message, PacketBuffer packet) {
        message.toBytes((ByteBuf)packet);
    }

    public static SetKeycardLevel decode(PacketBuffer packet) {
        SetKeycardLevel message = new SetKeycardLevel();
        message.fromBytes((ByteBuf)packet);
        return message;
    }

    public static void onMessage(SetKeycardLevel message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockPos pos = BlockUtils.toPos(message.x, message.y, message.z);
            int level = message.level;
            boolean exactCard = message.exactCard;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.field_70170_p;
            ((KeycardReaderTileEntity)world.func_175625_s(pos)).setPassword(String.valueOf(level));
            ((KeycardReaderTileEntity)world.func_175625_s(pos)).setRequiresExactKeycard(exactCard);
        });
        ctx.get().setPacketHandled(true);
    }
}

