/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.tileentity.KeypadChestTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetPassword {
    private String password;
    private int x;
    private int y;
    private int z;

    public SetPassword() {
    }

    public SetPassword(int x, int y, int z, String code) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.password = code;
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.func_180714_a(this.password);
    }

    public void fromBytes(PacketBuffer buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.password = buf.func_150789_c(0x1FFFFFFF);
    }

    public static void encode(SetPassword message, PacketBuffer packet) {
        message.toBytes(packet);
    }

    public static SetPassword decode(PacketBuffer packet) {
        SetPassword message = new SetPassword();
        message.fromBytes(packet);
        return message;
    }

    public static void onMessage(SetPassword message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockPos pos = BlockUtils.toPos(message.x, message.y, message.z);
            String password = message.password;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (SetPassword.getWorld((PlayerEntity)player).func_175625_s(pos) instanceof IPasswordProtected) {
                ((IPasswordProtected)SetPassword.getWorld((PlayerEntity)player).func_175625_s(pos)).setPassword(password);
                SetPassword.checkForAdjacentChest(pos, password, (PlayerEntity)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void checkForAdjacentChest(BlockPos pos, String codeToSet, PlayerEntity player) {
        if (SetPassword.getWorld(player).func_175625_s(pos) instanceof KeypadChestTileEntity) {
            if (SetPassword.getWorld(player).func_175625_s(pos.func_177974_f()) instanceof KeypadChestTileEntity) {
                ((IPasswordProtected)SetPassword.getWorld(player).func_175625_s(pos.func_177974_f())).setPassword(codeToSet);
            } else if (SetPassword.getWorld(player).func_175625_s(pos.func_177976_e()) instanceof KeypadChestTileEntity) {
                ((IPasswordProtected)SetPassword.getWorld(player).func_175625_s(pos.func_177976_e())).setPassword(codeToSet);
            } else if (SetPassword.getWorld(player).func_175625_s(pos.func_177968_d()) instanceof KeypadChestTileEntity) {
                ((IPasswordProtected)SetPassword.getWorld(player).func_175625_s(pos.func_177968_d())).setPassword(codeToSet);
            } else if (SetPassword.getWorld(player).func_175625_s(pos.func_177978_c()) instanceof KeypadChestTileEntity) {
                ((IPasswordProtected)SetPassword.getWorld(player).func_175625_s(pos.func_177978_c())).setPassword(codeToSet);
            }
        }
    }

    private static World getWorld(PlayerEntity player) {
        return player.field_70170_p;
    }
}

