/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.blocks.ProjectorBlock;
import net.geforcemods.securitycraft.tileentity.ProjectorTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.LightType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ProjectorTileEntityRenderer
extends TileEntityRenderer<ProjectorTileEntity> {
    public ProjectorTileEntityRenderer(TileEntityRendererDispatcher terd) {
        super(terd);
    }

    public void render(ProjectorTileEntity te, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int packedLight, int arg5) {
        if (!te.isActive()) {
            return;
        }
        if (!te.func_191420_l()) {
            for (int i = 0; i < te.getProjectionWidth(); ++i) {
                for (int j = 0; j < te.getProjectionWidth(); ++j) {
                    stack.func_227860_a_();
                    BlockPos pos = this.translateProjection(te, stack, (Direction)te.func_195044_w().func_177229_b((IProperty)ProjectorBlock.FACING), i, j, te.getProjectionRange(), te.getProjectionOffset());
                    if (pos != null && !te.func_145831_w().func_175623_d(pos)) {
                        stack.func_227865_b_();
                        continue;
                    }
                    RenderSystem.disableCull();
                    Minecraft.func_71410_x().func_175602_ab().func_228791_a_(te.getProjectedBlock().func_176223_P(), stack, buffer, LightTexture.func_228451_a_((int)te.func_145831_w().func_226658_a_(LightType.BLOCK, pos), (int)te.func_145831_w().func_226658_a_(LightType.SKY, pos)), OverlayTexture.field_229196_a_);
                    RenderSystem.enableCull();
                    stack.func_227865_b_();
                }
            }
        }
    }

    private BlockPos translateProjection(ProjectorTileEntity te, MatrixStack stack, Direction direction, int x, int y, double distance, double offset) {
        BlockPos pos;
        if (direction == Direction.NORTH) {
            pos = new BlockPos((double)(te.func_174877_v().func_177958_n() + x) + offset, (double)(te.func_174877_v().func_177956_o() + y), (double)te.func_174877_v().func_177952_p() + distance);
            stack.func_227861_a_(0.0 + (double)x + offset, 0.0 + (double)y, distance);
        } else if (direction == Direction.SOUTH) {
            pos = new BlockPos((double)(te.func_174877_v().func_177958_n() + x) + offset, (double)(te.func_174877_v().func_177956_o() + y), (double)te.func_174877_v().func_177952_p() + -distance);
            stack.func_227861_a_(0.0 + (double)x + offset, 0.0 + (double)y, -distance);
        } else if (direction == Direction.WEST) {
            pos = new BlockPos((double)te.func_174877_v().func_177958_n() + distance, (double)(te.func_174877_v().func_177956_o() + y), (double)(te.func_174877_v().func_177952_p() + x) + offset);
            stack.func_227861_a_(distance, 0.0 + (double)y, 0.0 + (double)x + offset);
        } else if (direction == Direction.EAST) {
            pos = new BlockPos((double)te.func_174877_v().func_177958_n() + -distance, (double)(te.func_174877_v().func_177956_o() + y), (double)(te.func_174877_v().func_177952_p() + x) + offset);
            stack.func_227861_a_(-distance, 0.0 + (double)y, 0.0 + (double)x + offset);
        } else {
            return te.func_174877_v();
        }
        return pos;
    }

    public boolean isGlobalRenderer(ProjectorTileEntity te) {
        return true;
    }
}

