/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.tileentity.BlockPocketManagerTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class BlockPocketManagerScreen
extends ContainerScreen<GenericTEContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    public BlockPocketManagerTileEntity te;
    private int size = 5;
    private Button toggleButton;
    private Button sizeButton;
    private Button assembleButton;
    private Button outlineButton;
    private static final ItemStack BLOCK_POCKET_WALL = new ItemStack((IItemProvider)SCContent.BLOCK_POCKET_WALL.get());
    private static final ItemStack REINFORCED_CHISELED_CRYSTAL_QUARTZ = new ItemStack((IItemProvider)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get());
    private static final ItemStack REINFORCED_CRYSTAL_QUARTZ_PILLAR = new ItemStack((IItemProvider)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get());

    public BlockPocketManagerScreen(GenericTEContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.te = (BlockPocketManagerTileEntity)container.te;
        this.size = this.te.size;
    }

    public void init() {
        super.init();
        this.toggleButton = new ClickButton(0, this.field_147003_i + this.field_146999_f / 2 - 45, this.field_147009_r + this.field_147000_g / 2 - 30, 90, 20, ClientUtils.localize("gui.securitycraft:blockPocketManager." + (!this.te.enabled ? "activate" : "deactivate"), new Object[0]), this::toggleButtonClicked);
        this.addButton((Widget)this.toggleButton);
        this.sizeButton = new ClickButton(1, this.field_147003_i + this.field_146999_f / 2 - 60, this.field_147009_r + this.field_147000_g / 2 - 60, 120, 20, ClientUtils.localize("gui.securitycraft:blockPocketManager.size", this.size, this.size, this.size), this::sizeButtonClicked);
        this.addButton((Widget)this.sizeButton);
        this.assembleButton = new ClickButton(0, this.field_147003_i + this.field_146999_f / 2 - 45, this.field_147009_r + this.field_147000_g / 2 + 33, 90, 20, ClientUtils.localize("gui.securitycraft:blockPocketManager.assemble", new Object[0]), this::assembleButtonClicked);
        this.addButton((Widget)this.assembleButton);
        this.outlineButton = new ClickButton(0, this.field_147003_i + this.field_146999_f / 2 - 60, this.field_147009_r + this.field_147000_g / 2 + 57, 120, 20, ClientUtils.localize("gui.securitycraft:blockPocketManager.outline." + (!this.te.showOutline ? "show" : "hide"), new Object[0]), this::outlineButtonClicked);
        this.addButton((Widget)this.outlineButton);
        if (!this.te.getOwner().isOwner((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            this.outlineButton.active = false;
            this.assembleButton.active = false;
            this.toggleButton.active = false;
            this.sizeButton.active = false;
        } else {
            this.assembleButton.active = !this.te.enabled;
            this.sizeButton.active = this.assembleButton.active;
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String translation = ClientUtils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).func_149739_a(), new Object[0]);
        this.font.func_211126_b(translation, (float)(this.field_146999_f / 2 - this.font.func_78256_a(translation) / 2), 6.0f, 0x404040);
        if (!this.te.enabled) {
            this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:blockPocketManager.youNeed", new Object[0]), (float)(this.field_146999_f / 2 - this.font.func_78256_a(ClientUtils.localize("gui.securitycraft:blockPocketManager.youNeed", new Object[0])) / 2), 83.0f, 0x404040);
            this.font.func_211126_b((this.size - 2) * (this.size - 2) * 6 + "", 42.0f, 100.0f, 0x404040);
            this.minecraft.func_175599_af().func_180450_b(BLOCK_POCKET_WALL, 25, 96);
            this.font.func_211126_b((this.size - 2) * 12 - 1 + "", 94.0f, 100.0f, 0x404040);
            this.minecraft.func_175599_af().func_180450_b(REINFORCED_CRYSTAL_QUARTZ_PILLAR, 77, 96);
            this.font.func_211126_b("8", 147.0f, 100.0f, 0x404040);
            this.minecraft.func_175599_af().func_180450_b(REINFORCED_CHISELED_CRYSTAL_QUARTZ, 130, 96);
            if (mouseX >= this.field_147003_i + 23 && mouseX < this.field_147003_i + 48 && mouseY >= this.field_147009_r + 93 && mouseY < this.field_147009_r + 115) {
                this.renderTooltip(BLOCK_POCKET_WALL, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
            if (mouseX >= this.field_147003_i + 75 && mouseX < this.field_147003_i + 100 && mouseY >= this.field_147009_r + 93 && mouseY < this.field_147009_r + 115) {
                this.renderTooltip(REINFORCED_CRYSTAL_QUARTZ_PILLAR, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
            if (mouseX >= this.field_147003_i + 128 && mouseX < this.field_147003_i + 153 && mouseY >= this.field_147009_r + 93 && mouseY < this.field_147009_r + 115) {
                this.renderTooltip(REINFORCED_CHISELED_CRYSTAL_QUARTZ, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
            }
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        this.blit(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void toggleButtonClicked(ClickButton button) {
        if (this.te.enabled) {
            this.te.disableMultiblock();
        } else {
            this.te.size = this.size;
            TranslationTextComponent feedback = this.te.enableMultiblock();
            if (feedback != null) {
                PlayerUtils.sendMessageToPlayer((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ClientUtils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).func_149739_a(), new Object[0]), ClientUtils.localize(feedback.func_150268_i(), feedback.func_150271_j()), TextFormatting.DARK_AQUA);
            }
        }
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
    }

    public void sizeButtonClicked(ClickButton button) {
        this.size += 4;
        if (this.size > 25) {
            this.size = 5;
        }
        this.te.size = this.size;
        button.setMessage(ClientUtils.localize("gui.securitycraft:blockPocketManager.size", this.size, this.size, this.size));
    }

    public void assembleButtonClicked(ClickButton button) {
        this.te.size = this.size;
        TranslationTextComponent feedback = this.te.autoAssembleMultiblock((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        if (feedback != null) {
            PlayerUtils.sendMessageToPlayer((PlayerEntity)Minecraft.func_71410_x().field_71439_g, ClientUtils.localize(((Block)SCContent.BLOCK_POCKET_MANAGER.get()).func_149739_a(), new Object[0]), ClientUtils.localize(feedback.func_150268_i(), feedback.func_150271_j()), TextFormatting.DARK_AQUA);
        }
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
    }

    public void outlineButtonClicked(ClickButton button) {
        this.te.toggleOutline();
        this.outlineButton.setMessage(ClientUtils.localize("gui.securitycraft:blockPocketManager.outline." + (!this.te.showOutline ? "show" : "hide"), new Object[0]));
    }
}

