/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.GenericContainer;
import net.geforcemods.securitycraft.network.server.OpenGui;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BriefcasePasswordScreen
extends ContainerScreen<GenericContainer> {
    public static final String UP_ARROW = "\u2191";
    public static final String DOWN_ARROW = "\u2193";
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private Button[] keycodeTopButtons = new Button[4];
    private Button[] keycodeBottomButtons = new Button[4];
    private TextFieldWidget[] keycodeTextboxes = new TextFieldWidget[4];
    private Button continueButton;
    private int[] digits = new int[]{0, 0, 0, 0};

    public BriefcasePasswordScreen(GenericContainer container, PlayerInventory inv, ITextComponent text) {
        super((Container)container, inv, text);
    }

    public void init() {
        int i;
        super.init();
        for (i = 0; i < this.keycodeTopButtons.length; ++i) {
            this.keycodeTopButtons[i] = new ClickButton(i, this.width / 2 - 40 + i * 20, this.height / 2 - 52, 20, 20, UP_ARROW, this::actionPerformed);
            this.addButton((Widget)this.keycodeTopButtons[i]);
        }
        for (i = 0; i < this.keycodeBottomButtons.length; ++i) {
            this.keycodeBottomButtons[i] = new ClickButton(4 + i, this.width / 2 - 40 + i * 20, this.height / 2, 20, 20, DOWN_ARROW, this::actionPerformed);
            this.addButton((Widget)this.keycodeBottomButtons[i]);
        }
        this.continueButton = new ClickButton(8, this.width / 2 + 42, this.height / 2 - 26, 20, 20, ">", this::actionPerformed);
        this.addButton((Widget)this.continueButton);
        for (i = 0; i < this.keycodeTextboxes.length; ++i) {
            this.keycodeTextboxes[i] = new TextFieldWidget(this.font, this.width / 2 - 37 + i * 20, this.height / 2 - 22, 14, 12, "");
            this.keycodeTextboxes[i].func_146193_g(-1);
            this.keycodeTextboxes[i].func_146204_h(-1);
            this.keycodeTextboxes[i].func_146185_a(true);
            this.keycodeTextboxes[i].func_146203_f(1);
            this.keycodeTextboxes[i].func_146180_a("0");
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        RenderSystem.disableLighting();
        for (TextFieldWidget textfield : this.keycodeTextboxes) {
            textfield.render(mouseX, mouseY, partialTicks);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(ClientUtils.localize("gui.securitycraft:briefcase.enterPasscode", new Object[0]), (float)(this.field_146999_f / 2 - this.font.func_78256_a(ClientUtils.localize("gui.securitycraft:briefcase.enterPasscode", new Object[0])) / 2), 6.0f, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        this.blit(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void actionPerformed(ClickButton button) {
        if (button.id == 8) {
            if (PlayerUtils.isHoldingItem((PlayerEntity)Minecraft.func_71410_x().field_71439_g, SCContent.BRIEFCASE)) {
                CompoundNBT nbt = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70448_g().func_77978_p();
                String code = this.digits[0] + "" + this.digits[1] + "" + this.digits[2] + "" + this.digits[3];
                if (nbt.func_74779_i("passcode").equals(code)) {
                    if (!nbt.func_74764_b("owner")) {
                        nbt.func_74778_a("owner", Minecraft.func_71410_x().field_71439_g.func_200200_C_().getString());
                        nbt.func_74778_a("ownerUUID", Minecraft.func_71410_x().field_71439_g.func_110124_au().toString());
                    }
                    SecurityCraft.channel.sendToServer((Object)new OpenGui(SCContent.cTypeBriefcaseInventory.getRegistryName(), this.minecraft.field_71441_e.func_201675_m().func_186058_p().func_186068_a(), this.minecraft.field_71439_g.func_180425_c(), this.getTitle()));
                }
            }
        } else {
            int n;
            int index = button.id % 4;
            if (button.id > 3) {
                int n2 = index;
                n = this.digits[n2] = this.digits[n2] - 1;
            } else {
                int n3 = index;
                n = this.digits[n3] = this.digits[n3] + 1;
            }
            this.digits[index] = Math.floorMod(n, 10);
            this.keycodeTextboxes[index].func_146180_a(String.valueOf(this.digits[index]));
        }
    }
}

