/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.network.server.CheckPassword;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class CheckPasswordScreen
extends ContainerScreen<GenericTEContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private TileEntity tileEntity;
    private char[] allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\b', '\u001b'};
    private String blockName;
    private TextFieldWidget keycodeTextbox;
    private String currentString = "";
    private static final int MAX_CHARS = 11;

    public CheckPasswordScreen(GenericTEContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tileEntity = container.te;
        this.blockName = ClientUtils.localize(this.tileEntity.func_195044_w().func_177230_c().func_149739_a(), new Object[0]);
    }

    public void init() {
        super.init();
        this.minecraft.field_195559_v.func_197967_a(true);
        this.addButton((Widget)new ClickButton(0, this.width / 2 - 38, this.height / 2 + 30 + 10, 80, 20, "0", this::actionPerformed));
        this.addButton((Widget)new ClickButton(1, this.width / 2 - 38, this.height / 2 - 60 + 10, 20, 20, "1", this::actionPerformed));
        this.addButton((Widget)new ClickButton(2, this.width / 2 - 8, this.height / 2 - 60 + 10, 20, 20, "2", this::actionPerformed));
        this.addButton((Widget)new ClickButton(3, this.width / 2 + 22, this.height / 2 - 60 + 10, 20, 20, "3", this::actionPerformed));
        this.addButton((Widget)new ClickButton(4, this.width / 2 - 38, this.height / 2 - 30 + 10, 20, 20, "4", this::actionPerformed));
        this.addButton((Widget)new ClickButton(5, this.width / 2 - 8, this.height / 2 - 30 + 10, 20, 20, "5", this::actionPerformed));
        this.addButton((Widget)new ClickButton(6, this.width / 2 + 22, this.height / 2 - 30 + 10, 20, 20, "6", this::actionPerformed));
        this.addButton((Widget)new ClickButton(7, this.width / 2 - 38, this.height / 2 + 10, 20, 20, "7", this::actionPerformed));
        this.addButton((Widget)new ClickButton(8, this.width / 2 - 8, this.height / 2 + 10, 20, 20, "8", this::actionPerformed));
        this.addButton((Widget)new ClickButton(9, this.width / 2 + 22, this.height / 2 + 10, 20, 20, "9", this::actionPerformed));
        this.addButton((Widget)new ClickButton(10, this.width / 2 + 48, this.height / 2 + 30 + 10, 25, 20, "<-", this::actionPerformed));
        this.keycodeTextbox = new TextFieldWidget(this.font, this.width / 2 - 37, this.height / 2 - 67, 77, 12, "");
        this.keycodeTextbox.func_146193_g(-1);
        this.keycodeTextbox.func_146204_h(-1);
        this.keycodeTextbox.func_146185_a(true);
        this.keycodeTextbox.func_146203_f(11);
        this.keycodeTextbox.func_146195_b(true);
    }

    public void onClose() {
        super.onClose();
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        RenderSystem.disableLighting();
        this.keycodeTextbox.render(mouseX, mouseY, partialTicks);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.blockName, (float)(this.field_146999_f / 2 - this.font.func_78256_a(this.blockName) / 2), 6.0f, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        this.blit(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259 && this.currentString.length() > 0) {
            Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("random.click")), 0.15f, 1.0f);
            this.currentString = Utils.removeLastChar(this.currentString);
            this.setTextboxCensoredText(this.keycodeTextbox, this.currentString);
            this.checkCode(this.currentString);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (!this.isValidChar(typedChar) || this.currentString.length() >= 11) {
            return super.charTyped(typedChar, keyCode);
        }
        Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("random.click")), 0.15f, 1.0f);
        this.currentString = this.currentString + typedChar;
        this.setTextboxCensoredText(this.keycodeTextbox, this.currentString);
        this.checkCode(this.currentString);
        return true;
    }

    private boolean isValidChar(char c) {
        for (int i = 0; i < this.allowedChars.length; ++i) {
            if (c != this.allowedChars[i]) continue;
            return true;
        }
        return false;
    }

    protected void actionPerformed(ClickButton button) {
        if (this.currentString.length() < 11 && button.id >= 0 && button.id <= 9) {
            this.currentString = this.currentString + "" + button.id;
            this.setTextboxCensoredText(this.keycodeTextbox, this.currentString);
            this.checkCode(this.currentString);
        }
        if (button.id == 10 && this.currentString.length() > 0) {
            this.currentString = Utils.removeLastChar(this.currentString);
            this.setTextboxCensoredText(this.keycodeTextbox, this.currentString);
        }
    }

    private void setTextboxCensoredText(TextFieldWidget textField, String text) {
        String x = "";
        for (int i = 1; i <= text.length(); ++i) {
            x = x + "*";
        }
        textField.func_146180_a(x);
    }

    public void checkCode(String code) {
        SecurityCraft.channel.sendToServer((Object)new CheckPassword(this.tileEntity.func_174877_v().func_177958_n(), this.tileEntity.func_174877_v().func_177956_o(), this.tileEntity.func_174877_v().func_177952_p(), code));
    }
}

