/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.server.UpdateNBTTagOnServer;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EditModuleScreen
extends Screen {
    private static CompoundNBT savedModule;
    private static final ResourceLocation TEXTURE;
    private ItemStack module;
    private TextFieldWidget inputField;
    private ClickButton addButton;
    private ClickButton removeButton;
    private ClickButton copyButton;
    private ClickButton pasteButton;
    private ClickButton clearButton;
    private int xSize = 176;
    private int ySize = 166;

    public EditModuleScreen(ItemStack item) {
        super((ITextComponent)new TranslationTextComponent(item.func_77977_a(), new Object[0]));
        this.module = item;
    }

    public void init() {
        super.init();
        this.minecraft.field_195559_v.func_197967_a(true);
        this.inputField = new TextFieldWidget(this.font, this.width / 2 - 55, this.height / 2 - 65, 110, 15, "");
        this.addButton = new ClickButton(0, this.width / 2 - 38, this.height / 2 - 45, 76, 20, ClientUtils.localize("gui.securitycraft:editModule.add", new Object[0]), this::actionPerformed);
        this.addButton((Widget)this.addButton);
        this.removeButton = new ClickButton(1, this.width / 2 - 38, this.height / 2 - 20, 76, 20, ClientUtils.localize("gui.securitycraft:editModule.remove", new Object[0]), this::actionPerformed);
        this.addButton((Widget)this.removeButton);
        this.copyButton = new ClickButton(2, this.width / 2 - 38, this.height / 2 + 5, 76, 20, ClientUtils.localize("gui.securitycraft:editModule.copy", new Object[0]), this::actionPerformed);
        this.addButton((Widget)this.copyButton);
        this.pasteButton = new ClickButton(3, this.width / 2 - 38, this.height / 2 + 30, 76, 20, ClientUtils.localize("gui.securitycraft:editModule.paste", new Object[0]), this::actionPerformed);
        this.addButton((Widget)this.pasteButton);
        this.clearButton = new ClickButton(4, this.width / 2 - 38, this.height / 2 + 55, 76, 20, ClientUtils.localize("gui.securitycraft:editModule.clear", new Object[0]), this::actionPerformed);
        this.addButton((Widget)this.clearButton);
        this.addButton((Widget)this.clearButton);
        this.addButton.active = false;
        this.removeButton.active = false;
        if (this.module.func_77978_p() == null || this.module.func_77978_p().isEmpty() || this.module.func_77978_p() != null && this.module.func_77978_p().equals((Object)savedModule)) {
            this.copyButton.active = false;
        }
        if (savedModule == null || savedModule.isEmpty() || this.module.func_77978_p() != null && this.module.func_77978_p().equals((Object)savedModule)) {
            this.pasteButton.active = false;
        }
        if (this.module.func_77978_p() == null || this.module.func_77978_p().isEmpty()) {
            this.clearButton.active = false;
        }
        this.inputField.func_146193_g(-1);
        this.inputField.func_146204_h(-1);
        this.inputField.func_146185_a(true);
        this.inputField.func_146203_f(16);
        this.inputField.func_146195_b(true);
    }

    public void onClose() {
        super.onClose();
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.width - this.xSize) / 2;
        int startY = (this.height - this.ySize) / 2;
        this.blit(startX, startY, 0, 0, this.xSize, this.ySize);
        super.render(mouseX, mouseY, partialTicks);
        RenderSystem.disableLighting();
        this.inputField.render(mouseX, mouseY, partialTicks);
        this.font.func_78279_b(ClientUtils.localize("gui.securitycraft:editModule", new Object[0]), startX + this.xSize / 2 - this.font.func_78256_a(ClientUtils.localize("gui.securitycraft:editModule", new Object[0])) / 2, startY + 6, this.width, 0x404040);
    }

    public boolean keyPressed(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (this.inputField.isFocused()) {
            if (keyCode == 259) {
                for (int i = 1; i <= 50; ++i) {
                    if (!this.inputField.func_146179_b().isEmpty() && this.module.func_77978_p() != null && this.module.func_77978_p().func_74779_i("Player" + i).equals(this.inputField.func_146179_b().substring(0, this.inputField.func_146179_b().length() - 1))) {
                        this.addButton.active = false;
                        this.removeButton.active = this.inputField.func_146179_b().length() > 1;
                        break;
                    }
                    if (i != 50) continue;
                    this.addButton.active = this.inputField.func_146179_b().length() > 1;
                    this.removeButton.active = false;
                }
                if (this.inputField.func_146179_b().isEmpty()) {
                    return false;
                }
            }
            if (keyCode == Minecraft.func_71410_x().field_71474_y.field_151445_Q.getKey().func_197937_c()) {
                return false;
            }
            if (keyCode == 256) {
                return super.keyPressed(keyCode, scanCode, p_keyPressed_3_);
            }
            return this.inputField.keyPressed(keyCode, scanCode, p_keyPressed_3_);
        }
        return super.keyPressed(keyCode, scanCode, p_keyPressed_3_);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.inputField.isFocused()) {
            if (keyCode == 32) {
                return false;
            }
            this.inputField.charTyped(typedChar, keyCode);
            for (int i = 1; i <= 50; ++i) {
                if (this.module.func_77978_p() != null && this.module.func_77978_p().func_74779_i("Player" + i).equals(this.inputField.func_146179_b())) {
                    this.addButton.active = false;
                    this.removeButton.active = !this.inputField.func_146179_b().isEmpty();
                    break;
                }
                if (i != 50) continue;
                this.addButton.active = !this.inputField.func_146179_b().isEmpty();
                this.removeButton.active = false;
            }
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.inputField.mouseClicked(mouseX, mouseY, mouseButton);
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void actionPerformed(ClickButton button) {
        switch (button.id) {
            case 0: {
                if (this.inputField.func_146179_b().isEmpty()) {
                    return;
                }
                if (this.module.func_77978_p() == null) {
                    this.module.func_77982_d(new CompoundNBT());
                }
                for (int i = 1; i <= 50; ++i) {
                    if (!this.module.func_77978_p().func_74764_b("Player" + i) || !this.module.func_77978_p().func_74779_i("Player" + i).equals(this.inputField.func_146179_b())) continue;
                    if (i == 9) {
                        this.addButton.active = false;
                    }
                    return;
                }
                this.module.func_77978_p().func_74778_a("Player" + this.getNextSlot(this.module.func_77978_p()), this.inputField.func_146179_b());
                if (this.module.func_77978_p() != null && this.module.func_77978_p().func_74764_b("Player50")) {
                    this.addButton.active = false;
                }
                this.inputField.func_146180_a("");
                break;
            }
            case 1: {
                if (this.inputField.func_146179_b().isEmpty()) {
                    return;
                }
                if (this.module.func_77978_p() == null) {
                    this.module.func_77982_d(new CompoundNBT());
                }
                for (int i = 1; i <= 50; ++i) {
                    if (!this.module.func_77978_p().func_74764_b("Player" + i) || !this.module.func_77978_p().func_74779_i("Player" + i).equals(this.inputField.func_146179_b())) continue;
                    this.module.func_77978_p().func_82580_o("Player" + i);
                }
                this.inputField.func_146180_a("");
                break;
            }
            case 2: {
                savedModule = this.module.func_77978_p();
                this.copyButton.active = false;
                return;
            }
            case 3: {
                this.module.func_77982_d(savedModule);
                break;
            }
            case 4: {
                this.module.func_77982_d(new CompoundNBT());
                this.inputField.func_146180_a("");
                break;
            }
            default: {
                return;
            }
        }
        if (this.module.func_77978_p() != null) {
            SecurityCraft.channel.sendToServer((Object)new UpdateNBTTagOnServer(this.module));
        }
        this.addButton.active = this.module.func_77978_p() != null && !this.module.func_77978_p().func_74764_b("Player50") && !this.inputField.func_146179_b().isEmpty();
        this.removeButton.active = this.module.func_77978_p() != null && !this.module.func_77978_p().isEmpty() && !this.inputField.func_146179_b().isEmpty();
        this.copyButton.active = this.module.func_77978_p() != null && !this.module.func_77978_p().isEmpty() && (this.module.func_77978_p() == null || !this.module.func_77978_p().equals((Object)savedModule));
        this.pasteButton.active = savedModule != null && !savedModule.isEmpty() && (this.module.func_77978_p() == null || !this.module.func_77978_p().equals((Object)savedModule));
        this.clearButton.active = this.module.func_77978_p() != null && !this.module.func_77978_p().isEmpty();
    }

    private int getNextSlot(CompoundNBT tag) {
        for (int i = 1; i <= 50; ++i) {
            if (tag.func_74779_i("Player" + i) != null && !tag.func_74779_i("Player" + i).isEmpty()) continue;
            return i;
        }
        return 0;
    }

    static {
        TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    }
}

