/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.containers.InventoryScannerContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.InventoryScannerTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InventoryScannerScreen
extends ContainerScreen<InventoryScannerContainer> {
    private static final ResourceLocation REGULAR_INVENTORY = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_gui.png");
    private static final ResourceLocation ENHANCED_INVENTORY = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_enhanced_gui.png");
    private InventoryScannerTileEntity tileEntity;
    private boolean owns = false;
    private boolean hasStorageModule = false;
    private String storageString;
    private String redstoneString;

    public InventoryScannerScreen(InventoryScannerContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tileEntity = container.te;
        this.owns = this.tileEntity.getOwner().isOwner(inv.field_70458_d);
        this.hasStorageModule = this.tileEntity.hasModule(ModuleType.STORAGE);
        this.storageString = ClientUtils.localize("gui.securitycraft:invScan.check_inv", ClientUtils.localize("gui.securitycraft:invScan." + (this.hasStorageModule ? "yes" : "no"), new Object[0]));
        this.redstoneString = ClientUtils.localize("gui.securitycraft:invScan.emit_redstone", ClientUtils.localize("gui.securitycraft:invScan." + (this.tileEntity.hasModule(ModuleType.REDSTONE) ? "yes" : "no"), new Object[0]));
        this.field_146999_f = this.hasStorageModule ? 236 : 176;
        this.field_147000_g = 196;
    }

    public void init() {
        super.init();
        this.minecraft.field_195559_v.func_197967_a(true);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        RenderSystem.disableLighting();
        this.font.func_211126_b(this.redstoneString, (float)(this.field_147003_i + 5), (float)(this.field_147009_r + 40), 0x404040);
        this.font.func_211126_b(this.storageString, (float)(this.field_147003_i + 5), (float)(this.field_147009_r + 50), 0x404040);
        if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().func_75211_c().func_190926_b()) {
            this.renderTooltip(this.getSlotUnderMouse().func_75211_c(), mouseX, mouseY);
        }
    }

    public void onClose() {
        super.onClose();
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b("Prohibited Items", 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.tileEntity.getOwner().isOwner((PlayerEntity)this.minecraft.field_71439_g) ? TextFormatting.UNDERLINE + ClientUtils.localize("gui.securitycraft:invScan.mode.admin", new Object[0]) : TextFormatting.UNDERLINE + ClientUtils.localize("gui.securitycraft:invScan.mode.view", new Object[0]), 112.0f, 6.0f, 0x404040);
        if (this.hasStorageModule && this.owns) {
            this.font.func_211126_b("Storage", 183.0f, 6.0f, 0x404040);
        }
        this.font.func_211126_b(ClientUtils.localize("container.inventory", new Object[0]), 8.0f, (float)(this.field_147000_g - 93), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.hasStorageModule && this.owns) {
            this.minecraft.func_110434_K().func_110577_a(ENHANCED_INVENTORY);
        } else {
            this.minecraft.func_110434_K().func_110577_a(REGULAR_INVENTORY);
        }
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        this.blit(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g + 30);
    }
}

