/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.ProjectorContainer;
import net.geforcemods.securitycraft.network.server.SyncProjector;
import net.geforcemods.securitycraft.screen.components.NamedSlider;
import net.geforcemods.securitycraft.tileentity.ProjectorTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.HoverChecker;

@OnlyIn(value=Dist.CLIENT)
public class ProjectorScreen
extends ContainerScreen<ProjectorContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/projector.png");
    private ProjectorTileEntity tileEntity;
    private String blockName;
    private HoverChecker[] hoverCheckers = new HoverChecker[3];
    private NamedSlider projectionWidth;
    private NamedSlider projectionRange;
    private NamedSlider projectionOffset;
    private int sliderWidth = 120;

    public ProjectorScreen(ProjectorContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tileEntity = container.te;
        this.blockName = ClientUtils.localize(this.tileEntity.func_195044_w().func_177230_c().func_149739_a(), new Object[0]);
        this.field_147000_g = 225;
    }

    public void init() {
        super.init();
        this.projectionWidth = new NamedSlider(ClientUtils.localize("gui.securitycraft:projector.width", new Object[0]).replace("#", this.tileEntity.getProjectionWidth() + ""), this.blockName, 0, this.field_147003_i + (this.field_146999_f - this.sliderWidth) / 2, this.field_147009_r + 50, this.sliderWidth, 20, ClientUtils.localize("gui.securitycraft:projector.width", new Object[0]).replace("#", ""), "", 1, 10, this.tileEntity.getProjectionWidth(), false, true, null, this::sliderReleased);
        this.projectionWidth.setFGColor(0xE0E0E0);
        this.projectionRange = new NamedSlider(ClientUtils.localize("gui.securitycraft:projector.range", new Object[0]).replace("#", this.tileEntity.getProjectionRange() + ""), this.blockName, 1, this.field_147003_i + (this.field_146999_f - this.sliderWidth) / 2, this.field_147009_r + 80, this.sliderWidth, 20, ClientUtils.localize("gui.securitycraft:projector.range", new Object[0]).replace("#", ""), "", 1, 30, this.tileEntity.getProjectionRange(), false, true, null, this::sliderReleased);
        this.projectionRange.setFGColor(0xE0E0E0);
        this.projectionOffset = new NamedSlider(ClientUtils.localize("gui.securitycraft:projector.offset", new Object[0]).replace("#", this.tileEntity.getProjectionOffset() + ""), this.blockName, 2, this.field_147003_i + (this.field_146999_f - this.sliderWidth) / 2, this.field_147009_r + 110, this.sliderWidth, 20, ClientUtils.localize("gui.securitycraft:projector.offset", new Object[0]).replace("#", ""), "", -10, 10, this.tileEntity.getProjectionOffset(), false, true, null, this::sliderReleased);
        this.projectionOffset.setFGColor(0xE0E0E0);
        this.addButton((Widget)this.projectionWidth);
        this.addButton((Widget)this.projectionRange);
        this.addButton((Widget)this.projectionOffset);
        this.hoverCheckers[0] = new HoverChecker((Widget)this.projectionWidth, 20);
        this.hoverCheckers[1] = new HoverChecker((Widget)this.projectionRange, 20);
        this.hoverCheckers[2] = new HoverChecker((Widget)this.projectionOffset, 20);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        if (this.hoverCheckers[0] != null && this.hoverCheckers[0].checkHover(mouseX, mouseY)) {
            this.renderTooltip(this.minecraft.field_71466_p.func_78271_c(ClientUtils.localize("gui.securitycraft:projector.width.description", new Object[0]), 150), mouseX, mouseY, this.font);
        }
        if (this.hoverCheckers[1] != null && this.hoverCheckers[1].checkHover(mouseX, mouseY)) {
            this.renderTooltip(this.minecraft.field_71466_p.func_78271_c(ClientUtils.localize("gui.securitycraft:projector.range.description", new Object[0]), 150), mouseX, mouseY, this.font);
        }
        if (this.hoverCheckers[2] != null && this.hoverCheckers[2].checkHover(mouseX, mouseY)) {
            this.renderTooltip(this.minecraft.field_71466_p.func_78271_c(ClientUtils.localize("gui.securitycraft:projector.offset.description", new Object[0]), 150), mouseX, mouseY, this.font);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.blockName, (float)(this.field_146999_f / 2 - this.font.func_78256_a(this.blockName) / 2), 6.0f, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        this.blit(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.projectionWidth.dragging) {
            this.projectionWidth.mouseReleased(mouseX, mouseY, button);
        }
        if (this.projectionRange.dragging) {
            this.projectionRange.mouseReleased(mouseX, mouseY, button);
        }
        if (this.projectionOffset.dragging) {
            this.projectionOffset.mouseReleased(mouseX, mouseY, button);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void sliderReleased(NamedSlider slider) {
        if (slider.id == 0) {
            this.tileEntity.setProjectionWidth(slider.getValueInt());
        } else if (slider.id == 1) {
            this.tileEntity.setProjectionRange(slider.getValueInt());
        } else if (slider.id == 2) {
            this.tileEntity.setProjectionOffset(slider.getValueInt());
        }
        SecurityCraft.channel.sendToServer((Object)new SyncProjector(this.tileEntity.func_174877_v().func_177958_n(), this.tileEntity.func_174877_v().func_177956_o(), this.tileEntity.func_174877_v().func_177952_p(), this.projectionWidth.getValueInt(), this.projectionRange.getValueInt(), this.projectionOffset.getValueInt()));
    }
}

