/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.network.server.SetPassword;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class SetPasswordScreen
extends ContainerScreen<GenericTEContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private TileEntity tileEntity;
    private char[] allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private String blockName;
    private TextFieldWidget keycodeTextbox;
    private boolean isInvalid = false;
    private ClickButton saveAndContinueButton;

    public SetPasswordScreen(GenericTEContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tileEntity = container.te;
        this.blockName = ClientUtils.localize(this.tileEntity.func_195044_w().func_177230_c().func_149739_a(), new Object[0]);
    }

    public void init() {
        super.init();
        this.minecraft.field_195559_v.func_197967_a(true);
        this.saveAndContinueButton = new ClickButton(0, this.width / 2 - 48, this.height / 2 + 30 + 10, 100, 20, !this.isInvalid ? ClientUtils.localize("gui.securitycraft:keycardSetup.save", new Object[0]) : ClientUtils.localize("gui.securitycraft:password.invalidCode", new Object[0]), this::actionPerformed);
        this.addButton((Widget)this.saveAndContinueButton);
        this.keycodeTextbox = new TextFieldWidget(this.font, this.width / 2 - 37, this.height / 2 - 47, 77, 12, "");
        this.keycodeTextbox.func_146193_g(-1);
        this.keycodeTextbox.func_146204_h(-1);
        this.keycodeTextbox.func_146185_a(true);
        this.keycodeTextbox.func_146203_f(11);
        this.keycodeTextbox.func_146195_b(true);
        this.updateButtonText();
    }

    public void onClose() {
        super.onClose();
        this.isInvalid = false;
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        RenderSystem.disableLighting();
        this.keycodeTextbox.render(mouseX, mouseY, partialTicks);
        this.drawString(this.font, "CODE:", this.width / 2 - 67, this.height / 2 - 47 + 2, 0x404040);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String setup = ClientUtils.localize("gui.securitycraft:password.setup", new Object[0]);
        String combined = this.blockName + " " + setup;
        if (this.font.func_78256_a(combined) < this.field_146999_f - 10) {
            this.font.func_211126_b(combined, (float)(this.field_146999_f / 2 - this.font.func_78256_a(combined) / 2), 6.0f, 0x404040);
        } else {
            this.font.func_211126_b(this.blockName, (float)(this.field_146999_f / 2 - this.font.func_78256_a(this.blockName) / 2), 6.0f, 0x404040);
            this.font.func_211126_b(setup, (float)(this.field_146999_f / 2 - this.font.func_78256_a(setup) / 2), 16.0f, 0x404040);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.width - this.field_146999_f) / 2;
        int startY = (this.height - this.field_147000_g) / 2;
        this.blit(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259 && this.keycodeTextbox.func_146179_b().length() > 0) {
            Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("random.click")), 0.15f, 1.0f);
            this.keycodeTextbox.func_146180_a(this.keycodeTextbox.func_146179_b().substring(0, this.keycodeTextbox.func_146179_b().length() - 1));
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.keycodeTextbox.isFocused() && this.isValidChar(typedChar)) {
            this.keycodeTextbox.charTyped(typedChar, keyCode);
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    private boolean isValidChar(char c) {
        for (int i = 0; i < this.allowedChars.length; ++i) {
            if (c != this.allowedChars[i]) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.keycodeTextbox.mouseClicked(mouseX, mouseY, mouseButton);
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private void updateButtonText() {
        this.saveAndContinueButton.setMessage(!this.isInvalid ? ClientUtils.localize("gui.securitycraft:keycardSetup.save", new Object[0]) : ClientUtils.localize("gui.securitycraft:password.invalidCode", new Object[0]));
    }

    protected void actionPerformed(ClickButton button) {
        if (button.id == 0) {
            if (this.keycodeTextbox.func_146179_b().isEmpty()) {
                this.isInvalid = true;
                this.updateButtonText();
                return;
            }
            ((IPasswordProtected)this.tileEntity).setPassword(this.keycodeTextbox.func_146179_b());
            SecurityCraft.channel.sendToServer((Object)new SetPassword(this.tileEntity.func_174877_v().func_177958_n(), this.tileEntity.func_174877_v().func_177956_o(), this.tileEntity.func_174877_v().func_177952_p(), this.keycodeTextbox.func_146179_b()));
            ClientUtils.closePlayerScreen();
        }
    }
}

