/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.text.TextFormatting;

public class ScannerDoorTileEntity
extends CustomizableTileEntity {
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);

    public ScannerDoorTileEntity() {
        super(SCContent.teTypeScannerDoor);
    }

    @Override
    public void entityViewed(LivingEntity entity) {
        BlockState upperState = this.field_145850_b.func_180495_p(this.field_174879_c);
        BlockState lowerState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        if (!this.field_145850_b.field_72995_K && upperState.func_177229_b((IProperty)DoorBlock.field_176523_O) == DoubleBlockHalf.UPPER && !EntityUtils.isInvisible(entity)) {
            if (!(entity instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)entity;
            if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
                return;
            }
            if (!this.getOwner().isOwner(player)) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(((Item)SCContent.SCANNER_DOOR_ITEM.get()).func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:retinalScanner.notOwner", new Object[0]).replace("#", this.getOwner().getName()), TextFormatting.RED);
                return;
            }
            boolean open = (Boolean)BlockUtils.getBlockProperty(this.field_145850_b, this.field_174879_c.func_177977_b(), DoorBlock.field_176519_b) == false;
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)upperState.func_206870_a((IProperty)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf((Boolean)upperState.func_177229_b((IProperty)DoorBlock.field_176519_b) == false)), 3);
            this.field_145850_b.func_180501_a(this.field_174879_c.func_177977_b(), (BlockState)lowerState.func_206870_a((IProperty)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf((Boolean)lowerState.func_177229_b((IProperty)DoorBlock.field_176519_b) == false)), 3);
            this.field_145850_b.func_217378_a(null, open ? 1005 : 1011, this.field_174879_c, 0);
            if (open && ((Boolean)this.sendMessage.get()).booleanValue()) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(((Item)SCContent.SCANNER_DOOR_ITEM.get()).func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:retinalScanner.hello", new Object[0]).replace("#", player.func_200200_C_().func_150254_d()), TextFormatting.GREEN);
            }
        }
    }

    @Override
    protected void onLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<CustomizableTileEntity> excludedTEs) {
        if (action == LinkedAction.OPTION_CHANGED) {
            this.sendMessage.copy((Option)parameters[0]);
        }
    }

    @Override
    public int getViewCooldown() {
        return 30;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[0];
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage};
    }
}

