/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.RequestTEOwnableUpdate;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.NonNullList;

public class SecretSignTileEntity
extends SignTileEntity
implements IOwnable,
IModuleInventory,
ICustomizable {
    private Owner owner = new Owner();
    private Option.BooleanOption isSecret = new Option.BooleanOption("isSecret", true);
    private NonNullList<ItemStack> modules = NonNullList.func_191197_a((int)this.getMaxNumberOfModules(), (Object)ItemStack.field_190927_a);

    public TileEntityType<?> func_200662_C() {
        return SCContent.teTypeSecretSign;
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        this.writeModuleInventory(tag);
        this.writeOptions(tag);
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner.getName());
            tag.func_74778_a("ownerUUID", this.owner.getUUID());
        }
        return tag;
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.modules = this.readModuleInventory(tag);
        this.readOptions(tag);
        if (tag.func_74764_b("owner")) {
            this.owner.setOwnerName(tag.func_74779_i("owner"));
        }
        if (tag.func_74764_b("ownerUUID")) {
            this.owner.setOwnerUUID(tag.func_74779_i("ownerUUID"));
        }
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.WHITELIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.isSecret};
    }

    public boolean isSecret() {
        return (Boolean)this.isSecret.get();
    }

    public boolean isPlayerAllowedToSeeText(PlayerEntity player) {
        return !this.isSecret() || this.getOwner().isOwner(player) || ModuleUtils.checkForModule(this.func_145831_w(), this.func_174877_v(), player, ModuleType.WHITELIST);
    }

    @Override
    public void onOptionChanged(Option<?> option) {
        this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tag = new CompoundNBT();
        this.func_189515_b(tag);
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            SecurityCraft.channel.sendToServer((Object)new RequestTEOwnableUpdate(this.func_174877_v(), this.func_145831_w().func_201675_m().func_186058_p().func_186068_a()));
        }
    }
}

