/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.network.client.ClearLoggerClient;
import net.geforcemods.securitycraft.network.client.UpdateLogger;
import net.geforcemods.securitycraft.tileentity.DisguisableTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.PacketDistributor;

public class UsernameLoggerTileEntity
extends DisguisableTileEntity
implements INamedContainerProvider {
    public String[] players = new String[100];
    public String[] uuids = new String[100];
    public long[] timestamps = new long[100];

    public UsernameLoggerTileEntity() {
        super(SCContent.teTypeUsernameLogger);
    }

    @Override
    public boolean attackEntity(Entity entity) {
        if (!this.field_145850_b.field_72995_K && entity instanceof PlayerEntity) {
            this.addPlayer((PlayerEntity)entity);
            this.sendChangeToClient(false);
        }
        return true;
    }

    @Override
    public boolean canAttack() {
        return this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
    }

    public void logPlayers() {
        double range = ((Integer)ConfigHandler.CONFIG.usernameLoggerSearchRadius.get()).intValue();
        AxisAlignedBB area = BlockUtils.fromBounds(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 1).func_72314_b(range, range, range);
        List entities = this.field_145850_b.func_217357_a(PlayerEntity.class, area);
        Iterator iterator = entities.iterator();
        while (iterator.hasNext()) {
            this.addPlayer((PlayerEntity)iterator.next());
        }
        this.sendChangeToClient(false);
    }

    private void addPlayer(PlayerEntity player) {
        long timestamp = System.currentTimeMillis();
        if (!(this.getOwner().isOwner(player) || EntityUtils.isInvisible((LivingEntity)player) || this.hasPlayerName(player.func_200200_C_().func_150254_d(), timestamp))) {
            for (int i = 0; i < this.players.length; ++i) {
                if (this.players[i] != null && !this.players[i].equals("")) continue;
                this.players[i] = player.func_200200_C_().func_150254_d();
                this.uuids[i] = player.func_146103_bH().getId().toString();
                this.timestamps[i] = timestamp;
                break;
            }
        }
    }

    private boolean hasPlayerName(String username, long timestamp) {
        for (int i = 0; i < this.players.length; ++i) {
            if (this.players[i] == null || !this.players[i].equals(username) || this.timestamps[i] + 1000L <= timestamp) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        for (int i = 0; i < this.players.length; ++i) {
            tag.func_74778_a("player" + i, this.players[i] == null ? "" : this.players[i]);
            tag.func_74778_a("uuid" + i, this.uuids[i] == null ? "" : this.uuids[i]);
            tag.func_74772_a("timestamp" + i, this.timestamps[i]);
        }
        return tag;
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < this.players.length; ++i) {
            if (tag.func_74764_b("player" + i)) {
                this.players[i] = tag.func_74779_i("player" + i);
            }
            if (tag.func_74764_b("uuid" + i)) {
                this.uuids[i] = tag.func_74779_i("uuid" + i);
            }
            if (!tag.func_74764_b("timestamp" + i)) continue;
            this.timestamps[i] = tag.func_74763_f("timestamp" + i);
        }
    }

    public void sendChangeToClient(boolean clear) {
        if (!clear) {
            for (int i = 0; i < this.players.length; ++i) {
                if (this.players[i] == null) continue;
                SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new UpdateLogger(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), i, this.players[i], this.uuids[i], this.timestamps[i]));
            }
        } else {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new ClearLoggerClient(this.field_174879_c));
        }
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new GenericTEContainer(SCContent.cTypeUsernameLogger, windowId, this.field_145850_b, this.field_174879_c);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((Block)SCContent.USERNAME_LOGGER.get()).func_149739_a(), new Object[0]);
    }
}

