/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.util;

import java.io.File;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.network.server.SyncTENBTTag;
import net.geforcemods.securitycraft.network.server.UpdateNBTTagOnServer;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ClientUtils {
    @OnlyIn(value=Dist.CLIENT)
    public static void closePlayerScreen() {
        Minecraft.func_71410_x().field_71439_g.func_71053_j();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void takeScreenshot() {
        ScreenShotHelper.func_148260_a((File)Minecraft.func_71410_x().field_71412_D, (int)Minecraft.func_71410_x().func_228018_at_().func_198105_m(), (int)Minecraft.func_71410_x().func_228018_at_().func_198083_n(), (Framebuffer)Minecraft.func_71410_x().func_147110_a(), msg -> Minecraft.func_71410_x().execute(() -> Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a(msg)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getFormattedMinecraftTime() {
        Long time = Minecraft.func_71410_x().field_71441_e.func_72820_D();
        int hours24 = (int)((float)time.longValue() / 1000.0f + 6.0f) % 24;
        int hours = hours24 % 12;
        int minutes = (int)((float)time.longValue() / 16.666666f % 60.0f);
        return String.format("%02d:%02d %s", hours < 1 ? 12 : hours, minutes, hours24 < 12 ? "AM" : "PM");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void syncTileEntity(TileEntity tileEntity) {
        CompoundNBT tag = new CompoundNBT();
        tileEntity.func_189515_b(tag);
        SecurityCraft.channel.sendToServer((Object)new SyncTENBTTag(tileEntity.func_174877_v().func_177958_n(), tileEntity.func_174877_v().func_177956_o(), tileEntity.func_174877_v().func_177952_p(), tag));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void syncItemNBT(ItemStack item) {
        SecurityCraft.channel.sendToServer((Object)new UpdateNBTTagOnServer(item));
    }

    public static String localize(String key, Object ... params) {
        for (int i = 0; i < params.length; ++i) {
            if (params[i] instanceof TranslationTextComponent) {
                params[i] = ClientUtils.localize(((TranslationTextComponent)params[i]).func_150268_i(), ((TranslationTextComponent)params[i]).func_150271_j());
                continue;
            }
            if (!(params[i] instanceof BlockPos)) continue;
            params[i] = Utils.getFormattedCoordinates((BlockPos)params[i]);
        }
        return new TranslationTextComponent(key, params).func_150254_d();
    }
}

