/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.function.BiFunction;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.api.SecurityCraftTileEntity;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.InventoryScannerTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class InventoryScannerFieldBlock
extends OwnableBlock
implements IIntersectable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty HORIZONTAL = BooleanProperty.func_177716_a((String)"horizontal");
    private static final VoxelShape SHAPE_EW = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape SHAPE_NS = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape HORIZONTAL_SHAPE = Block.func_208617_a((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public InventoryScannerFieldBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)HORIZONTAL, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220071_b(BlockState blockState, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return VoxelShapes.func_197880_a();
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        block5: {
            InventoryScannerTileEntity connectedScanner;
            block4: {
                connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(world, pos);
                if (connectedScanner == null) {
                    return;
                }
                if (!(entity instanceof PlayerEntity) || EntityUtils.isInvisible((LivingEntity)((PlayerEntity)entity))) break block4;
                if (ModuleUtils.checkForModule(world, connectedScanner.func_174877_v(), (PlayerEntity)entity, ModuleType.WHITELIST)) {
                    return;
                }
                for (int i = 0; i < 10; ++i) {
                    if (connectedScanner.getStackInSlotCopy(i).func_190926_b()) continue;
                    InventoryScannerFieldBlock.checkInventory((PlayerEntity)entity, connectedScanner, connectedScanner.getStackInSlotCopy(i));
                }
                break block5;
            }
            if (!(entity instanceof ItemEntity)) break block5;
            for (int i = 0; i < 10; ++i) {
                if (connectedScanner.getStackInSlotCopy(i).func_190926_b() || ((ItemEntity)entity).func_92059_d().func_190926_b()) continue;
                InventoryScannerFieldBlock.checkItemEntity((ItemEntity)entity, connectedScanner, connectedScanner.getStackInSlotCopy(i));
            }
        }
    }

    public static void checkInventory(PlayerEntity player, InventoryScannerTileEntity te, ItemStack stack) {
        boolean hasSmartModule = te.hasModule(ModuleType.SMART);
        boolean hasStorageModule = te.hasModule(ModuleType.STORAGE);
        if (te.hasModule(ModuleType.REDSTONE)) {
            InventoryScannerFieldBlock.redstoneLoop((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, stack, te, hasSmartModule, hasStorageModule);
            InventoryScannerFieldBlock.redstoneLoop((NonNullList<ItemStack>)player.field_71071_by.field_70460_b, stack, te, hasSmartModule, hasStorageModule);
            InventoryScannerFieldBlock.redstoneLoop((NonNullList<ItemStack>)player.field_71071_by.field_184439_c, stack, te, hasSmartModule, hasStorageModule);
        }
        if (hasStorageModule && !te.getOwner().isOwner(player)) {
            InventoryScannerFieldBlock.checkLoop((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, stack, te, hasSmartModule, hasStorageModule);
            InventoryScannerFieldBlock.checkLoop((NonNullList<ItemStack>)player.field_71071_by.field_70460_b, stack, te, hasSmartModule, hasStorageModule);
            InventoryScannerFieldBlock.checkLoop((NonNullList<ItemStack>)player.field_71071_by.field_184439_c, stack, te, hasSmartModule, hasStorageModule);
        }
    }

    private static void redstoneLoop(NonNullList<ItemStack> inventory, ItemStack stack, InventoryScannerTileEntity te, boolean hasSmartModule, boolean hasStorageModule) {
        for (int i = 1; i <= inventory.size(); ++i) {
            ItemStack itemStackChecking = (ItemStack)inventory.get(i - 1);
            if (itemStackChecking.func_190926_b() || !(hasSmartModule && InventoryScannerFieldBlock.areItemStacksEqual(itemStackChecking, stack) && ItemStack.func_77970_a((ItemStack)itemStackChecking, (ItemStack)stack) || !hasSmartModule && itemStackChecking.func_77973_b() == stack.func_77973_b()) && !InventoryScannerFieldBlock.checkForShulkerBox(itemStackChecking, stack, te, hasSmartModule, hasStorageModule)) continue;
            InventoryScannerFieldBlock.updateInventoryScannerPower(te);
        }
    }

    private static void checkLoop(NonNullList<ItemStack> inventory, ItemStack stack, InventoryScannerTileEntity te, boolean hasSmartModule, boolean hasStorageModule) {
        for (int i = 1; i <= inventory.size(); ++i) {
            ItemStack itemStackChecking = (ItemStack)inventory.get(i - 1);
            if (itemStackChecking.func_190926_b()) continue;
            InventoryScannerFieldBlock.checkForShulkerBox(itemStackChecking, stack, te, hasSmartModule, hasStorageModule);
            if ((!hasSmartModule || !InventoryScannerFieldBlock.areItemStacksEqual(itemStackChecking, stack) || !ItemStack.func_77970_a((ItemStack)itemStackChecking, (ItemStack)stack)) && (hasSmartModule || itemStackChecking.func_77973_b() != stack.func_77973_b())) continue;
            if (hasStorageModule) {
                te.addItemToStorage((ItemStack)inventory.get(i - 1));
            }
            inventory.set(i - 1, (Object)ItemStack.field_190927_a);
        }
    }

    public static void checkItemEntity(ItemEntity entity, InventoryScannerTileEntity te, ItemStack stack) {
        boolean hasSmartModule = te.hasModule(ModuleType.SMART);
        boolean hasStorageModule = te.hasModule(ModuleType.STORAGE);
        if (te.hasModule(ModuleType.REDSTONE) && (hasSmartModule && InventoryScannerFieldBlock.areItemStacksEqual(entity.func_92059_d(), stack) && ItemStack.func_77970_a((ItemStack)entity.func_92059_d(), (ItemStack)stack) || !hasSmartModule && entity.func_92059_d().func_77973_b() == stack.func_77973_b() || InventoryScannerFieldBlock.checkForShulkerBox(entity.func_92059_d(), stack, te, hasSmartModule, hasStorageModule))) {
            InventoryScannerFieldBlock.updateInventoryScannerPower(te);
        }
        if (hasStorageModule) {
            InventoryScannerFieldBlock.checkForShulkerBox(entity.func_92059_d(), stack, te, hasSmartModule, hasStorageModule);
            if (hasSmartModule && InventoryScannerFieldBlock.areItemStacksEqual(entity.func_92059_d(), stack) && ItemStack.func_77970_a((ItemStack)entity.func_92059_d(), (ItemStack)stack) || !hasSmartModule && entity.func_92059_d().func_77973_b() == stack.func_77973_b()) {
                if (hasStorageModule) {
                    te.addItemToStorage(entity.func_92059_d());
                }
                entity.func_70106_y();
            }
        }
    }

    private static boolean checkForShulkerBox(ItemStack item, ItemStack stackToCheck, InventoryScannerTileEntity te, boolean hasSmartModule, boolean hasStorageModule) {
        boolean deletedItem = false;
        if (item != null && !item.func_190926_b() && item.func_77978_p() != null && Block.func_149634_a((Item)item.func_77973_b()) instanceof ShulkerBoxBlock) {
            ListNBT list = item.func_77978_p().func_74775_l("BlockEntityTag").func_150295_c("Items", 10);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemInChest = ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(i));
                if ((!hasSmartModule || !InventoryScannerFieldBlock.areItemStacksEqual(itemInChest, stackToCheck) || !ItemStack.func_77970_a((ItemStack)itemInChest, (ItemStack)stackToCheck)) && (hasSmartModule || !InventoryScannerFieldBlock.areItemStacksEqual(itemInChest, stackToCheck))) continue;
                list.remove(i);
                deletedItem = true;
                if (!hasStorageModule) continue;
                te.addItemToStorage(itemInChest);
            }
        }
        return deletedItem;
    }

    private static void updateInventoryScannerPower(InventoryScannerTileEntity te) {
        if (!te.shouldProvidePower()) {
            te.setShouldProvidePower(true);
        }
        te.setCooldown(60);
        InventoryScannerFieldBlock.checkAndUpdateTEAppropriately(te);
        BlockUtils.updateAndNotify(te.func_145831_w(), te.func_174877_v(), te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c(), 1, true);
    }

    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        ItemStack s1 = stack1.func_77946_l();
        ItemStack s2 = stack2.func_77946_l();
        s1.func_190920_e(1);
        s2.func_190920_e(1);
        return ItemStack.func_77989_b((ItemStack)s1, (ItemStack)s2);
    }

    private static void checkAndUpdateTEAppropriately(InventoryScannerTileEntity te) {
        InventoryScannerTileEntity connectedScanner = InventoryScannerBlock.getConnectedInventoryScanner(te.func_145831_w(), te.func_174877_v());
        if (connectedScanner == null) {
            return;
        }
        te.setShouldProvidePower(true);
        te.setCooldown(60);
        BlockUtils.updateAndNotify(te.func_145831_w(), te.func_174877_v(), te.func_195044_w().func_177230_c(), 1, true);
        connectedScanner.setShouldProvidePower(true);
        connectedScanner.setCooldown(60);
        BlockUtils.updateAndNotify(connectedScanner.func_145831_w(), connectedScanner.func_174877_v(), connectedScanner.func_195044_w().func_177230_c(), 1, true);
    }

    public void func_176206_d(IWorld world, BlockPos pos, BlockState state) {
        if (!world.func_201670_d()) {
            Direction facing = (Direction)state.func_177229_b((Property)FACING);
            if (facing == Direction.EAST || facing == Direction.WEST) {
                this.checkAndDestroyFields(world, pos, (p, i) -> p.func_177985_f(i.intValue()));
                this.checkAndDestroyFields(world, pos, (p, i) -> p.func_177965_g(i.intValue()));
            } else if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                this.checkAndDestroyFields(world, pos, (p, i) -> p.func_177964_d(i.intValue()));
                this.checkAndDestroyFields(world, pos, (p, i) -> p.func_177970_e(i.intValue()));
            }
        }
    }

    private void checkAndDestroyFields(IWorld world, BlockPos pos, BiFunction<BlockPos, Integer, BlockPos> posModifier) {
        for (int i = 0; i < (Integer)ConfigHandler.CONFIG.inventoryScannerRange.get(); ++i) {
            BlockPos modifiedPos = posModifier.apply(pos, i);
            if (BlockUtils.getBlock((IBlockReader)world, modifiedPos) != SCContent.INVENTORY_SCANNER.get()) continue;
            for (int j = 1; j < i; ++j) {
                world.func_175655_b(posModifier.apply(pos, j), false);
            }
            break;
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext ctx) {
        if (((Boolean)state.func_177229_b((Property)HORIZONTAL)).booleanValue()) {
            return HORIZONTAL_SHAPE;
        }
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        if (facing == Direction.EAST || facing == Direction.WEST) {
            return SHAPE_EW;
        }
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            return SHAPE_NS;
        }
        return VoxelShapes.func_197868_b();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, HORIZONTAL});
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return ItemStack.field_190927_a;
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new SecurityCraftTileEntity().intersectsEntities();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        if ((side == Direction.UP || side == Direction.DOWN) && state.func_177230_c() == adjacentBlockState.func_177230_c()) {
            return true;
        }
        return super.func_200122_a(state, adjacentBlockState, side);
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }
}

