/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class ExplosiveBlock
extends OwnableBlock
implements IExplosive {
    public ExplosiveBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader world, BlockPos pos) {
        return (Boolean)ConfigHandler.CONFIG.ableToBreakMines.get() == false ? -1.0f : super.func_180647_a(state, player, world, pos);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            if (player.field_71071_by.func_70448_g().func_190926_b() && this.explodesWhenInteractedWith() && this.isActive(world, pos) && !EntityUtils.doesPlayerOwn(player, world, pos)) {
                this.explode(world, pos);
                return ActionResultType.SUCCESS;
            }
            if (PlayerUtils.isHoldingItem(player, SCContent.REMOTE_ACCESS_MINE)) {
                return ActionResultType.SUCCESS;
            }
            if (this.isActive(world, pos) && this.isDefusable() && player.func_184586_b(hand).func_77973_b() == SCContent.WIRE_CUTTERS.get()) {
                this.defuseMine(world, pos);
                player.field_71071_by.func_70448_g().func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(hand));
                return ActionResultType.SUCCESS;
            }
            if (!this.isActive(world, pos) && PlayerUtils.isHoldingItem(player, Items.field_151033_d)) {
                this.activateMine(world, pos);
                return ActionResultType.SUCCESS;
            }
            if (this.explodesWhenInteractedWith() && this.isActive(world, pos) && !EntityUtils.doesPlayerOwn(player, world, pos)) {
                this.explode(world, pos);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    public boolean explodesWhenInteractedWith() {
        return true;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }
}

